/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.common.OptionalDontShowMeAgainDialog;
import freemind.controller.actions.generated.instance.EditNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.HtmlTools;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.EditNodeDialog;
import freemind.view.mindmapview.EditNodeExternalApplication;
import freemind.view.mindmapview.EditNodeTextField;
import freemind.view.mindmapview.EditNodeWYSIWYG;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;

public class EditAction
extends AbstractAction
implements ActorXml {
    private static final Pattern HTML_HEAD = Pattern.compile("\\s*<head>.*</head>", 32);
    private final MindMapController mMindMapController;
    private EditNodeBase mCurrentEditDialog = null;

    public EditAction(MindMapController modeController) {
        super(modeController.getText("edit_node"));
        this.mMindMapController = modeController;
        this.mMindMapController.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent arg0) {
        MindMapNode selected = this.mMindMapController.getSelected();
        this.mMindMapController.edit(null, false, false);
    }

    public void act(XmlAction action) {
        EditNodeAction editAction = (EditNodeAction)action;
        NodeAdapter node = this.mMindMapController.getNodeFromID(editAction.getNode());
        if (!node.toString().equals(editAction.getText())) {
            node.setUserObject(editAction.getText());
            this.mMindMapController.nodeChanged(node);
        }
    }

    public Class getDoActionClass() {
        return EditNodeAction.class;
    }

    public void edit(KeyEvent e, boolean addNew, boolean editLong) {
        NodeView selectedNodeView = this.mMindMapController.getView().getSelected();
        if (selectedNodeView != null) {
            if (e == null || !addNew) {
                this.edit(selectedNodeView, selectedNodeView, e, false, false, editLong);
            } else if (!this.mMindMapController.isBlocked()) {
                this.mMindMapController.addNew(this.mMindMapController.getSelected(), 3, e);
            }
            if (e != null) {
                e.consume();
            }
        }
    }

    public void edit(final NodeView node, final NodeView prevSelected, KeyEvent firstEvent, final boolean isNewNode, final boolean parentFolded, boolean editLong) {
        boolean editExternal;
        String useRichTextInNewLongNodes;
        if (node == null) {
            return;
        }
        MapView map = node.getMap();
        map.validate();
        map.invalidate();
        if (!node.focused()) {
            node.requestFocus();
        }
        this.stopEditing();
        this.mMindMapController.setBlocked(true);
        String text = ((Object)node.getModel()).toString();
        String htmlEditingOption = this.mMindMapController.getController().getProperty("html_editing_option");
        boolean isHtmlNode = HtmlTools.isHtmlNode(text);
        boolean isLongNode = node.getIsLong();
        String string = useRichTextInNewLongNodes = isHtmlNode ? "true" : "false";
        if (!isHtmlNode && !isLongNode && editLong) {
            int showResult = new OptionalDontShowMeAgainDialog(this.mMindMapController.getFrame().getJFrame(), this.mMindMapController.getSelectedView(), "edit.edit_rich_text", "edit.decision", this.mMindMapController, new OptionalDontShowMeAgainDialog.StandardPropertyHandler(this.mMindMapController.getController(), "remind_use_rich_text_in_new_long_nodes"), 1).show().getResult();
            useRichTextInNewLongNodes = showResult == 0 ? "true" : "false";
        }
        boolean editHtml = isHtmlNode || editLong && Tools.safeEquals(useRichTextInNewLongNodes, "true");
        boolean editInternalWysiwyg = editHtml && Tools.safeEquals(htmlEditingOption, "internal-wysiwyg");
        boolean bl = editExternal = editHtml && Tools.safeEquals(htmlEditingOption, "external");
        if (editHtml && !isHtmlNode) {
            text = HtmlTools.plainToHTML(text);
        }
        if (editInternalWysiwyg) {
            EditNodeWYSIWYG editNodeWYSIWYG = new EditNodeWYSIWYG(node, text, firstEvent, this.mMindMapController, new EditNodeBase.EditControl(){

                public void cancel() {
                    EditAction.this.mMindMapController.setBlocked(false);
                    EditAction.this.mCurrentEditDialog = null;
                    EditAction.this.mMindMapController.getController().obtainFocusForSelected();
                }

                public void ok(String newText) {
                    EditAction.this.setHtmlText(node, newText);
                    this.cancel();
                }

                public void split(String newText, int position) {
                    EditAction.this.mMindMapController.splitNode(node.getModel(), position, newText);
                    this.cancel();
                }
            });
            this.mCurrentEditDialog = editNodeWYSIWYG;
            editNodeWYSIWYG.show();
            return;
        }
        if (editExternal) {
            EditNodeExternalApplication editNodeExternalApplication = new EditNodeExternalApplication(node, text, firstEvent, this.mMindMapController, new EditNodeBase.EditControl(){

                public void cancel() {
                    EditAction.this.mMindMapController.setBlocked(false);
                    EditAction.this.mCurrentEditDialog = null;
                    EditAction.this.mMindMapController.getController().obtainFocusForSelected();
                }

                public void ok(String newText) {
                    EditAction.this.setHtmlText(node, newText);
                    this.cancel();
                }

                public void split(String newText, int position) {
                    EditAction.this.mMindMapController.splitNode(node.getModel(), position, newText);
                    this.cancel();
                }
            });
            this.mCurrentEditDialog = editNodeExternalApplication;
            editNodeExternalApplication.show();
            return;
        }
        if (isLongNode || editLong) {
            EditNodeDialog nodeEditDialog = new EditNodeDialog(node, text, firstEvent, this.mMindMapController, new EditNodeBase.EditControl(){

                public void cancel() {
                    EditAction.this.mMindMapController.setBlocked(false);
                    EditAction.this.mCurrentEditDialog = null;
                    EditAction.this.mMindMapController.getController().obtainFocusForSelected();
                }

                public void ok(String newText) {
                    EditAction.this.setNodeText(node.getModel(), newText);
                    this.cancel();
                }

                public void split(String newText, int position) {
                    EditAction.this.mMindMapController.splitNode(node.getModel(), position, newText);
                    this.cancel();
                }
            });
            this.mCurrentEditDialog = nodeEditDialog;
            nodeEditDialog.show();
            return;
        }
        EditNodeTextField textfield = new EditNodeTextField(node, text, firstEvent, this.mMindMapController, new EditNodeBase.EditControl(){

            public void cancel() {
                if (isNewNode) {
                    EditAction.this.mMindMapController.getView().selectAsTheOnlyOneSelected(node);
                    Vector<MindMapNode> nodeList = new Vector<MindMapNode>();
                    nodeList.add(node.getModel());
                    EditAction.this.mMindMapController.cut(nodeList);
                    EditAction.this.mMindMapController.select(prevSelected);
                    if (parentFolded) {
                        EditAction.this.mMindMapController.setFolded(prevSelected.getModel(), true);
                    }
                }
                this.endEdit();
            }

            public void ok(String newText) {
                EditAction.this.setNodeText(node.getModel(), newText);
                this.endEdit();
            }

            private void endEdit() {
                EditAction.this.mMindMapController.getController().obtainFocusForSelected();
                EditAction.this.mMindMapController.setBlocked(false);
                EditAction.this.mCurrentEditDialog = null;
            }

            public void split(String newText, int position) {
            }
        });
        this.mCurrentEditDialog = textfield;
        textfield.show();
    }

    public void setNodeText(MindMapNode selected, String newText) {
        String oldText = ((Object)selected).toString();
        this.mMindMapController.getActionFactory().startTransaction(this.mMindMapController.getText("edit_node"));
        EditNodeAction EditAction2 = new EditNodeAction();
        EditAction2.setNode(this.mMindMapController.getNodeID(selected));
        EditAction2.setText(newText);
        EditNodeAction undoEditAction = new EditNodeAction();
        undoEditAction.setNode(this.mMindMapController.getNodeID(selected));
        undoEditAction.setText(oldText);
        this.mMindMapController.getActionFactory().executeAction(new ActionPair((XmlAction)EditAction2, (XmlAction)undoEditAction));
        this.mMindMapController.getActionFactory().endTransaction(this.mMindMapController.getText("edit_node"));
    }

    protected MindMapController getMindMapController() {
        return this.mMindMapController;
    }

    private void setHtmlText(NodeView node, String newText) {
        String body = HTML_HEAD.matcher(newText).replaceFirst("");
        this.setNodeText(node.getModel(), body);
    }

    public void stopEditing() {
        if (this.mCurrentEditDialog != null) {
            this.mCurrentEditDialog.closeEdit();
            this.mCurrentEditDialog = null;
        }
    }
}

