/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.TextResources;
import freemind.controller.MenuItemSelectedListener;
import freemind.controller.actions.generated.instance.EditNoteToNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookRegistration;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.view.mindmapview.NodeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.html.HTMLDocument;

public class NodeNoteRegistration
implements HookRegistration,
ActorXml,
MenuItemSelectedListener {
    private static SHTMLPanel htmlEditorPanel;
    private static boolean mLastContentEmpty;
    private final MindMapController controller;
    protected SHTMLPanel noteViewerComponent;
    private final MindMap mMap;
    private final Logger logger;
    private NotesManager mNotesManager;
    private static ImageIcon noteIcon;
    private NoteDocumentListener mNoteDocumentListener;
    static Integer sPositionToRecover;
    private JSplitPane mSplitPane = null;

    public NodeNoteRegistration(ModeController controller, MindMap map) {
        this.controller = (MindMapController)controller;
        this.mMap = map;
        this.logger = controller.getFrame().getLogger(this.getClass().getName());
    }

    public boolean shouldUseSplitPane() {
        return "true".equals(this.controller.getFrame().getProperty("use_split_pane"));
    }

    public void register() {
        this.logger.fine("Registration of note handler.");
        FreeMindMain frame = this.controller.getFrame();
        this.controller.getActionFactory().registerActor(this, this.getDoActionClass());
        this.noteViewerComponent = this.getNoteViewerComponent();
        JumpToMapAction jumpToMapAction = new JumpToMapAction();
        String keystroke = this.controller.getFrame().getAdjustableProperty("keystroke_accessories/plugins/NodeNote_jumpto.keystroke.alt_N");
        this.noteViewerComponent.getInputMap(1).put(KeyStroke.getKeyStroke(keystroke), "jumpToMapAction");
        this.noteViewerComponent.getActionMap().put("jumpToMapAction", jumpToMapAction);
        if (this.shouldUseSplitPane()) {
            this.showNotesPanel();
        }
        this.mNotesManager = new NotesManager();
        this.controller.registerNodeSelectionListener(this.mNotesManager);
        this.controller.registerNodeLifetimeListener(this.mNotesManager);
        this.mNoteDocumentListener = new NoteDocumentListener();
    }

    public void deRegister() {
        this.controller.deregisterNodeSelectionListener(this.mNotesManager);
        this.controller.deregisterNodeLifetimeListener(this.mNotesManager);
        this.noteViewerComponent.getActionMap().remove("jumpToMapAction");
        if (this.noteViewerComponent != null && this.shouldUseSplitPane()) {
            this.hideNotesPanel();
            this.noteViewerComponent = null;
        }
        this.logger.fine("Deregistration of note undo handler.");
        this.controller.getActionFactory().deregisterActor(this.getDoActionClass());
    }

    public void showNotesPanel() {
        SouthPanel southPanel = new SouthPanel();
        southPanel.add((Component)this.noteViewerComponent, "Center");
        this.noteViewerComponent.setVisible(true);
        if ("true".equals(this.controller.getFrame().getProperty("resources_use_default_font_for_notes_too"))) {
            Font defaultFont = this.controller.getController().getDefaultFont();
            String rule = "BODY {";
            rule = rule + "font-family: " + defaultFont.getFamily() + ";";
            rule = rule + "font-size: " + defaultFont.getSize() + "pt;";
            rule = rule + "}\n";
            if ("true".equals(this.controller.getFrame().getProperty("resources_use_margin_top_zero_for_notes"))) {
                rule = rule + "p {";
                rule = rule + "margin-top:0;";
                rule = rule + "}\n";
            }
            this.noteViewerComponent.getDocument().getStyleSheet().addRule(rule);
        }
        this.noteViewerComponent.setOpenHyperlinkHandler(new ActionListener(){

            public void actionPerformed(ActionEvent pE) {
                try {
                    NodeNoteRegistration.this.getMindMapController().getFrame().openDocument(new URL(pE.getActionCommand()));
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                }
            }
        });
        this.mSplitPane = this.controller.getFrame().insertComponentIntoSplitPane(southPanel);
        southPanel.revalidate();
    }

    public void hideNotesPanel() {
        this.noteViewerComponent.setVisible(false);
        this.controller.getFrame().removeSplitPane();
        this.mSplitPane = null;
    }

    protected void setStateIcon(MindMapNode node, boolean enabled) {
        if (noteIcon == null) {
            noteIcon = new ImageIcon(this.controller.getResource("images/knotes.png"));
        }
        boolean showIcon = enabled;
        if (Resources.getInstance().getBoolProperty("resources_don_t_show_note_icons")) {
            showIcon = false;
        }
        node.setStateIcon("accessories.plugins.NodeNoteIcon", showIcon ? noteIcon : null);
        this.getMindMapController().setToolTip(node, "nodeNoteText", enabled ? node.getNoteText() : null);
    }

    public void act(XmlAction action) {
        if (action instanceof EditNoteToNodeAction) {
            String oldText;
            EditNoteToNodeAction noteTextAction = (EditNoteToNodeAction)action;
            NodeAdapter node = this.controller.getNodeFromID(noteTextAction.getNode());
            String newText = noteTextAction.getText();
            if (!Tools.safeEquals(newText, oldText = node.getNoteText())) {
                node.setNoteText(newText);
                if (node == this.controller.getSelected() && !Tools.safeEquals(newText, NodeNoteRegistration.getHtmlEditorPanel().getDocumentText())) {
                    NodeNoteRegistration.getHtmlEditorPanel().setCurrentDocumentContent(newText == null ? "" : newText);
                }
                this.setStateIcon(node, newText != null && !newText.equals(""));
                this.controller.nodeChanged(node);
            }
        }
    }

    public Class getDoActionClass() {
        return EditNoteToNodeAction.class;
    }

    public void changeNoteText(String text, MindMapNode node) {
        this.getMindMapController().setNoteText(node, text);
    }

    private MindMapController getMindMapController() {
        return this.controller;
    }

    protected SHTMLPanel getNoteViewerComponent() {
        return NodeNoteRegistration.getHtmlEditorPanel();
    }

    public static SHTMLPanel getHtmlEditorPanel() {
        if (htmlEditorPanel == null) {
            SHTMLPanel.setResources((TextResources)new SimplyHtmlResources());
            htmlEditorPanel = SHTMLPanel.createSHTMLPanel();
            htmlEditorPanel.setMinimumSize(new Dimension(100, 100));
        }
        return htmlEditorPanel;
    }

    public JSplitPane getSplitPane() {
        return this.mSplitPane;
    }

    public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
        return this.getSplitPane() != null;
    }

    static {
        mLastContentEmpty = true;
        noteIcon = null;
        sPositionToRecover = null;
    }

    class JumpToMapAction
    extends AbstractAction {
        JumpToMapAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (sPositionToRecover != null) {
                NodeNoteRegistration.this.mSplitPane.setDividerLocation(sPositionToRecover);
                sPositionToRecover = null;
            }
            NodeNoteRegistration.this.controller.getController().obtainFocusForSelected();
        }
    }

    private final class NotesManager
    implements ModeController.NodeSelectionListener,
    ModeController.NodeLifetimeListener {
        private MindMapNode node;

        public void onDeselectHook(NodeView node) {
            NodeNoteRegistration.this.noteViewerComponent.getDocument().removeDocumentListener(NodeNoteRegistration.this.mNoteDocumentListener);
            this.onSaveNode(node.getModel());
            this.node = null;
        }

        public void onSelectHook(NodeView nodeView) {
            this.node = nodeView.getModel();
            HTMLDocument document = NodeNoteRegistration.this.noteViewerComponent.getDocument();
            document.removeDocumentListener(NodeNoteRegistration.this.mNoteDocumentListener);
            try {
                document.setBase(this.node.getMap().getFile().toURL());
            }
            catch (Exception e) {
                // empty catch block
            }
            String note = this.node.getNoteText();
            if (note != null) {
                NodeNoteRegistration.this.noteViewerComponent.setCurrentDocumentContent(note);
                mLastContentEmpty = false;
            } else if (!mLastContentEmpty) {
                NodeNoteRegistration.this.noteViewerComponent.setCurrentDocumentContent("");
                mLastContentEmpty = true;
            }
            document.addDocumentListener(NodeNoteRegistration.this.mNoteDocumentListener);
        }

        public void onUpdateNodeHook(MindMapNode node) {
        }

        public void onSaveNode(MindMapNode node) {
            if (this.node != node) {
                return;
            }
            boolean editorContentEmpty = true;
            JEditorPane editorPane = NodeNoteRegistration.this.noteViewerComponent.getEditorPane();
            int caretPosition = editorPane.getCaretPosition();
            int selectionStart = editorPane.getSelectionStart();
            int selectionEnd = editorPane.getSelectionEnd();
            String documentText = NodeNoteRegistration.this.noteViewerComponent.getDocumentText();
            editorContentEmpty = (documentText = documentText.replaceFirst("(?s)<style.*?</style>", "")).equals("<html>\n  <head>\n\n  </head>\n  <body>\n    <p>\n      \n    </p>\n  </body>\n</html>\n") || documentText.equals("<html>\n  <head>\n    \n  </head>\n  <body>\n    <p>\n      \n    </p>\n  </body>\n</html>\n");
            NodeNoteRegistration.this.logger.fine("Current document: '" + documentText.replaceAll("\n", "\\\\n") + "', empty=" + editorContentEmpty);
            NodeNoteRegistration.this.controller.deregisterNodeSelectionListener(this);
            if (NodeNoteRegistration.this.noteViewerComponent.needsSaving()) {
                if (editorContentEmpty) {
                    NodeNoteRegistration.this.changeNoteText(null, node);
                } else {
                    NodeNoteRegistration.this.changeNoteText(documentText, node);
                }
                mLastContentEmpty = editorContentEmpty;
            }
            NodeNoteRegistration.this.controller.registerNodeSelectionListener(this);
            editorPane.setCaretPosition(caretPosition);
            editorPane.setSelectionEnd(selectionEnd);
            editorPane.setSelectionStart(selectionStart);
        }

        public void onCreateNodeHook(MindMapNode node) {
            if (node.getXmlNoteText() != null) {
                NodeNoteRegistration.this.setStateIcon(node, true);
            }
        }

        public void onPreDeleteNode(MindMapNode node) {
        }

        public void onPostDeleteNode(MindMapNode pNode, MindMapNode pParent) {
        }
    }

    private final class NoteDocumentListener
    implements DocumentListener {
        private NoteDocumentListener() {
        }

        public void changedUpdate(DocumentEvent arg0) {
            this.docEvent();
        }

        private void docEvent() {
            NodeNoteRegistration.this.getMindMapController().getMap().setSaved(false);
        }

        public void insertUpdate(DocumentEvent arg0) {
            this.docEvent();
        }

        public void removeUpdate(DocumentEvent arg0) {
            this.docEvent();
        }
    }

    private static class SouthPanel
    extends JPanel {
        public SouthPanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return super.processKeyBinding(ks, e, condition, pressed) || e.getKeyChar() == ' ' || e.getKeyChar() == '\u0012';
        }
    }

    public static final class SimplyHtmlResources
    implements TextResources {
        public String getString(String pKey) {
            if (Tools.safeEquals("show_splash_screen", pKey)) {
                return "false";
            }
            pKey = "simplyhtml." + pKey;
            String resourceString = Resources.getInstance().getResourceString(pKey, null);
            if (resourceString == null) {
                resourceString = Resources.getInstance().getProperty(pKey);
            }
            return resourceString;
        }
    }
}

