/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.controller.Controller;
import freemind.controller.MenuItemEnabledListener;
import freemind.extensions.HookRegistration;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeHookAction;
import freemind.modes.mindmapmode.hooks.MindMapNodeHookAdapter;
import freemind.view.MapModule;
import freemind.view.mindmapview.NodeView;
import java.awt.EventQueue;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class NodeHistory
extends MindMapNodeHookAdapter {
    private static Vector sNodeVector = new Vector();
    private static int sCurrentPosition = 0;
    private static boolean sPreventRegistration = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MindMapNode node) {
        super.invoke(node);
        Registration registration = (Registration)this.getPluginBaseClass();
        final MindMapController modeController = this.getMindMapController();
        String direction = this.getResourceString("direction");
        if ("back".equals(direction)) {
            if (sCurrentPosition <= 1) return;
            --sCurrentPosition;
        } else {
            if (sCurrentPosition >= sNodeVector.size()) return;
            ++sCurrentPosition;
        }
        if (sCurrentPosition == 0) {
            return;
        }
        NodeHolder nodeHolder = (NodeHolder)sNodeVector.get(sCurrentPosition - 1);
        final Controller mainController = this.getController().getController();
        final MindMapNode toBeSelected = nodeHolder.getNode(mainController);
        boolean changeModule = false;
        MapModule newModule = null;
        if (nodeHolder.getModeController(mainController) != this.getMindMapController()) {
            changeModule = true;
            newModule = nodeHolder.getMapModule(mainController);
            if (newModule == null) {
                this.invoke(node);
                return;
            }
        }
        final boolean fChangeModule = changeModule;
        final MapModule fNewModule = newModule;
        this.logger.finest("Selecting " + toBeSelected + " at pos " + sCurrentPosition);
        sPreventRegistration = true;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                NodeView nodeView;
                ModeController c = modeController;
                if (fChangeModule) {
                    boolean res = mainController.getMapModuleManager().changeToMapModule(fNewModule.toString());
                    if (!res) {
                        NodeHistory.this.logger.warning("Can't change to map module " + fNewModule);
                        sPreventRegistration = false;
                        return;
                    }
                    c = fNewModule.getModeController();
                }
                if (!toBeSelected.isRoot()) {
                    c.setFolded(toBeSelected.getParentNode(), false);
                }
                if ((nodeView = c.getNodeView(toBeSelected)) != null) {
                    c.select(nodeView);
                    sPreventRegistration = false;
                }
            }
        });
    }

    private void printVector() {
        StringBuffer sb = new StringBuffer("\n");
        int i = 0;
        Iterator iter = sNodeVector.iterator();
        while (iter.hasNext()) {
            NodeHolder holder = (NodeHolder)iter.next();
            sb.append((sCurrentPosition - 1 == i ? "==>" : "   ") + "Node pos " + i + " is " + holder.getNode(this.getMindMapController().getController()));
            sb.append("\n");
            ++i;
        }
        this.logger.info(sb.toString() + "\n");
    }

    public static class Registration
    implements HookRegistration,
    ModeController.NodeSelectionListener,
    MenuItemEnabledListener {
        private final MindMapController controller;
        private final MindMap mMap;
        private final Logger logger;

        public Registration(ModeController controller, MindMap map) {
            this.controller = (MindMapController)controller;
            this.mMap = map;
            this.logger = controller.getFrame().getLogger(this.getClass().getName());
        }

        public void register() {
            this.controller.registerNodeSelectionListener(this);
        }

        public void deRegister() {
            this.controller.deregisterNodeSelectionListener(this);
        }

        public void onDeselectHook(NodeView pNode) {
        }

        public void onSelectHook(NodeView pNode) {
            if (!sPreventRegistration) {
                if (sCurrentPosition > 0 && ((NodeHolder)sNodeVector.get(sCurrentPosition - 1)).isIdentical(pNode.getModel(), this.controller)) {
                    return;
                }
                if (sCurrentPosition != sNodeVector.size()) {
                    for (int i = sNodeVector.size() - 1; i >= sCurrentPosition; --i) {
                        sNodeVector.removeElementAt(i);
                    }
                }
                sNodeVector.add(new NodeHolder(pNode.getModel(), this.controller));
                sCurrentPosition++;
                while (sNodeVector.size() > 100) {
                    sNodeVector.removeElementAt(0);
                    sCurrentPosition--;
                }
            }
        }

        public void onSaveNode(MindMapNode pNode) {
        }

        public void onUpdateNodeHook(MindMapNode pNode) {
        }

        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            String hookName = ((NodeHookAction)pAction).getHookName();
            if ("accessories/plugins/NodeHistoryBack.properties".equals(hookName)) {
                return sCurrentPosition > 1;
            }
            return sCurrentPosition < sNodeVector.size();
        }
    }

    private static class NodeHolder {
        public String mNodeId;
        public String mMapModuleName;

        public NodeHolder(MindMapNode pNode, MindMapController pMindMapController) {
            this.mNodeId = pNode.getObjectId(pMindMapController);
            MapModule mapModule = this.getModuleGivenModeController(pMindMapController);
            if (mapModule == null) {
                throw new IllegalArgumentException("MapModule not present to controller " + pMindMapController);
            }
            this.mMapModuleName = mapModule.toString();
        }

        public MindMapNode getNode(Controller pController) {
            ModeController modeController = this.getModeController(pController);
            if (modeController != null) {
                return modeController.getNodeFromID(this.mNodeId);
            }
            return null;
        }

        private ModeController getModeController(Controller pController) {
            ModeController modeController = null;
            MapModule mapModule = this.getMapModule(pController);
            if (mapModule != null) {
                modeController = mapModule.getModeController();
            }
            return modeController;
        }

        private MapModule getMapModule(Controller pController) {
            MapModule mapModule = null;
            Map mapModules = pController.getMapModuleManager().getMapModules();
            Iterator iter = mapModules.keySet().iterator();
            while (iter.hasNext()) {
                String mapModuleName = (String)iter.next();
                if (mapModuleName == null || !mapModuleName.equals(this.mMapModuleName)) continue;
                mapModule = (MapModule)mapModules.get(mapModuleName);
                break;
            }
            return mapModule;
        }

        public boolean isIdentical(MindMapNode pNode, MindMapController pMindMapController) {
            String id = pNode.getObjectId(pMindMapController);
            MapModule mapModule = this.getModuleGivenModeController(pMindMapController);
            if (mapModule != null) {
                return id.equals(this.mNodeId);
            }
            return false;
        }

        private MapModule getModuleGivenModeController(MindMapController pMindMapController) {
            Map.Entry mapEntry;
            MapModule mapModule = null;
            Iterator iter = pMindMapController.getController().getMapModuleManager().getMapModules().entrySet().iterator();
            while (iter.hasNext() && !pMindMapController.equals((mapModule = (MapModule)(mapEntry = iter.next()).getValue()).getModeController())) {
            }
            return mapModule;
        }
    }
}

