/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXTable;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.core.api.transfer.SourceInfo;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.api.upload.UploadPropertyKey;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.ui.swing.components.decorators.TableDecorator;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class FileInfoTransfersPanel
implements FileInfoPanel {
    @Resource
    private Icon lockIcon;
    @Resource
    private Color foreground;
    @Resource
    private Font smallFont;
    private final JPanel component = new JPanel(new MigLayout("fillx, gap 0"));
    private final DownloadItem download;
    private final UploadItem upload;
    private DownloadStatusListener downloadStatus;
    private JXTable infoTable;
    private FileInfoTableModel infoModel;
    private Timer refreshTimer;
    private JLabel leechersLabel;
    private JLabel seedersLabel;
    private Torrent torrent;

    public FileInfoTransfersPanel(FileInfoDialog.FileInfoType type, PropertiableFile file, TableDecorator tableDecorator) {
        if (file instanceof DownloadItem) {
            this.download = (DownloadItem)file;
            this.upload = null;
        } else if (file instanceof UploadItem) {
            this.download = null;
            this.upload = (UploadItem)file;
        } else {
            this.download = null;
            this.upload = null;
            return;
        }
        GuiUtils.assignResources(this);
        this.infoModel = new FileInfoTableModel();
        this.infoTable = new JXTable(this.infoModel);
        tableDecorator.decorate(this.infoTable);
        this.infoTable.setCellSelectionEnabled(false);
        this.infoTable.setShowGrid(false, false);
        this.infoTable.setEditable(false);
        this.component.add((Component)new JScrollPane(this.infoTable), "gaptop 10, span, grow, wrap");
        if (this.download != null) {
            this.component.add((Component)this.createBoldLabel(I18n.tr("Total Completed:")), "split 2, gaptop 10");
            JLabel percentLabel = this.createPlainLabel("");
            this.component.add((Component)percentLabel, "wrap");
            this.downloadStatus = new DownloadStatusListener(percentLabel);
            this.download.addPropertyChangeListener(this.downloadStatus);
        }
        if (this.download != null && this.download.getDownloadItemType() == DownloadItem.DownloadItemType.BITTORRENT || this.upload != null && this.upload.getUploadItemType() == UploadItem.UploadItemType.BITTORRENT) {
            this.torrent = this.download != null ? (Torrent)this.download.getDownloadProperty(DownloadPropertyKey.TORRENT) : (Torrent)this.upload.getUploadProperty(UploadPropertyKey.TORRENT);
            this.component.add((Component)this.createBoldLabel(I18n.tr("Total Leechers:")), "split 2");
            this.leechersLabel = this.createPlainLabel("");
            this.component.add((Component)this.leechersLabel, "wrap");
            this.component.add((Component)this.createBoldLabel(I18n.tr("Total Seeders:")), "split 2");
            this.seedersLabel = this.createPlainLabel("");
            this.component.add((Component)this.seedersLabel, "wrap");
        } else {
            this.leechersLabel = null;
            this.seedersLabel = null;
        }
        this.init();
        this.refreshTimer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileInfoTransfersPanel.this.refresh();
            }
        });
        this.refreshTimer.start();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
    }

    @Override
    public void dispose() {
        this.refreshTimer.stop();
        if (this.downloadStatus != null) {
            this.download.removePropertyChangeListener(this.downloadStatus);
        }
    }

    private void init() {
        TableColumn column = this.infoTable.getColumn(1);
        column.setCellRenderer(new LockRenderer());
        column.setMaxWidth(12);
        column.setMinWidth(12);
        column.setWidth(12);
        this.infoTable.getColumnExt(0).setComparator(IpPort.IP_COMPARATOR);
        TableColumn ipColumn = this.infoTable.getColumn(0);
        ipColumn.setCellRenderer(new IPRenderer());
        TableColumn uploadColumn = this.infoTable.getColumn(3);
        uploadColumn.setCellRenderer(new SpeedRenderer());
        TableColumn downloadColumn = this.infoTable.getColumn(4);
        downloadColumn.setCellRenderer(new SpeedRenderer());
    }

    private void refresh() {
        this.infoModel.clear();
        if (this.download != null) {
            this.infoModel.addAll(this.download.getSourcesDetails());
        } else {
            this.infoModel.addAll(this.upload.getTransferDetails());
        }
        if (this.torrent != null) {
            TorrentStatus status = this.torrent.getStatus();
            this.seedersLabel.setText(status.getNumComplete() < 0 ? "?" : "" + status.getNumComplete());
            this.leechersLabel.setText(status.getNumIncomplete() < 0 ? "?" : "" + status.getNumIncomplete());
        }
    }

    private JLabel createBoldLabel(String text) {
        JLabel label = this.createPlainLabel(text);
        FontUtils.bold(label);
        return label;
    }

    private JLabel createPlainLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(this.smallFont);
        label.setForeground(this.foreground);
        return label;
    }

    private static class IPRenderer
    extends DefaultTableCellRenderer {
        private IPRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                value = ((IpPort)value).getAddress();
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class SpeedRenderer
    extends DefaultTableCellRenderer {
        private SpeedRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                value = GuiUtils.formatUnitFromBytesPerSec((Long)value);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class FileInfoTableModel
    extends AbstractTableModel {
        public static final int IP = 0;
        public static final int ENCRYPTED = 1;
        public static final int CLIENT_NAME = 2;
        public static final int UPLOAD_SPEED = 3;
        public static final int DOWNLOAD_SPEED = 4;
        private List<SourceInfo> sources = new ArrayList<SourceInfo>();
        private String[] columnNames = new String[]{I18n.tr("Address"), "", I18n.tr("Client"), I18n.tr("Upload"), I18n.tr("Download")};

        private FileInfoTableModel() {
        }

        public void clear() {
            this.sources.clear();
        }

        public void addAll(Collection<SourceInfo> info) {
            this.sources.addAll(info);
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column < this.columnNames.length) {
                return this.columnNames[column];
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.sources.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return null;
            }
            return this.getColumnValue(this.sources.get(rowIndex), columnIndex);
        }

        private Object getColumnValue(SourceInfo info, int column) {
            switch (column) {
                case 0: {
                    try {
                        return new IpPortImpl(info.getIPAddress(), 0);
                    }
                    catch (UnknownHostException e) {
                        return null;
                    }
                }
                case 1: {
                    return info.isEncyrpted();
                }
                case 2: {
                    return info.getClientName();
                }
                case 3: {
                    return (long)Math.round(info.getUploadSpeed());
                }
                case 4: {
                    return (long)Math.round(info.getDownloadSpeed());
                }
            }
            return null;
        }
    }

    private class LockRenderer
    extends DefaultLimeTableCellRenderer {
        public LockRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == Boolean.TRUE) {
                this.setIcon(FileInfoTransfersPanel.this.lockIcon);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    private class DownloadStatusListener
    implements PropertyChangeListener {
        private final JLabel label;

        public DownloadStatusListener(JLabel label) {
            this.label = label;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadStatusListener.this.label.setText(I18n.tr("{0}%", FileInfoTransfersPanel.this.download.getPercentComplete()));
                }
            });
        }
    }
}

