/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.table.TableColumnExt;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.Category;
import org.limewire.core.api.URN;
import org.limewire.core.api.library.LibraryFileList;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.inject.LazySingleton;
import org.limewire.player.api.PlayerState;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.HeaderBar;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.components.decorators.HeaderBarDecorator;
import org.limewire.ui.swing.dnd.LocalFileListTransferHandler;
import org.limewire.ui.swing.library.AddFileAction;
import org.limewire.ui.swing.library.LibraryFilterPanel;
import org.limewire.ui.swing.library.LibraryTransferHandler;
import org.limewire.ui.swing.library.LocalFileItemFilterator;
import org.limewire.ui.swing.library.PublicSharedFeedbackPanel;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.library.sharing.LibrarySharingAction;
import org.limewire.ui.swing.library.sharing.LibrarySharingPanel;
import org.limewire.ui.swing.library.table.AbstractLibraryFormat;
import org.limewire.ui.swing.library.table.LibraryImageTable;
import org.limewire.ui.swing.library.table.LibraryTable;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.player.Audio;
import org.limewire.ui.swing.player.PlayerControlPanelFactory;
import org.limewire.ui.swing.player.PlayerMediator;
import org.limewire.ui.swing.player.PlayerMediatorListener;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.table.TableCellHeaderRenderer;
import org.limewire.ui.swing.table.TableColors;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingHacks;
import org.limewire.util.OSUtils;

@LazySingleton
public class LibraryPanel
extends JPanel {
    @Resource
    private Icon plusIcon;
    @Resource
    private Font fileCountFont;
    @Resource
    private Color fileCountColor;
    @Resource
    private Color tableOverlayColor;
    private static final String TABLE = "TABLE";
    private static final String LIST = "LIST";
    private final HeaderBar headerBar = new HeaderBar();
    private final LockableUI lockableUI;
    private final LibraryTable libraryTable;
    private final LibraryNavigatorPanel libraryNavigatorPanel;
    private final LibrarySharingPanel librarySharingPanel;
    private final PublicSharedFeedbackPanel publicSharedFeedbackPanel;
    private final LibraryFilterPanel libraryFilterPanel;
    private final ButtonDecorator buttonDecorator;
    private final LocalFileListTransferHandler transferHandler;
    private final Provider<LibraryImageTable> libraryImagePanelProvider;
    private LibraryImageTable libraryImagePanel;
    private JPanel tableListPanel;
    private JScrollPane libraryScrollPane;
    private CardLayout tableListLayout;
    private JXButton addFilesButton;
    private JLabel fileCountLabel;
    private JXButton filterToggleButton;
    private Category selectedCategory;
    private EventList<LocalFileItem> eventList;
    private FilterList<LocalFileItem> filteredList;
    private FilterList<LocalFileItem> textFilterList;
    private FileCountListener fileCountListener;
    private LibraryNavItem selectedNavItem;

    @Inject
    public LibraryPanel(LibraryNavigatorPanel navPanel, HeaderBarDecorator headerBarDecorator, LibraryTable libraryTable, LibrarySharingPanel sharingPanel, LibraryFilterPanel libraryFilterPanel, PublicSharedFeedbackPanel publicSharedFeedbackPanel, PlayerControlPanelFactory playerPanel, AddFileAction addFileAction, ButtonDecorator buttonDecorator, LibraryTransferHandler transferHandler, Provider<LibraryImageTable> libraryImagePanelProvider, LibrarySharingAction libraryAction) {
        super(new MigLayout("insets 0, gap 0, fill"));
        this.libraryNavigatorPanel = navPanel;
        this.libraryTable = libraryTable;
        this.librarySharingPanel = sharingPanel;
        this.libraryFilterPanel = libraryFilterPanel;
        this.publicSharedFeedbackPanel = publicSharedFeedbackPanel;
        this.buttonDecorator = buttonDecorator;
        this.transferHandler = transferHandler;
        this.libraryImagePanelProvider = libraryImagePanelProvider;
        this.fileCountListener = new FileCountListener();
        GuiUtils.assignResources(this);
        this.lockableUI = new LockedUI(new LayerEffect[0]);
        this.layoutComponents(headerBarDecorator, playerPanel.createAudioControlPanel(), addFileAction, libraryAction);
        this.eventList = new BasicEventList<LocalFileItem>();
        this.selectTable(libraryFilterPanel.getSelectedTableFormat(), libraryFilterPanel.getSelectedCategory());
    }

    private void layoutComponents(HeaderBarDecorator headerBarDecorator, JComponent playerPanel, AddFileAction addFileAction, LibrarySharingAction libraryAction) {
        headerBarDecorator.decorateBasic(this.headerBar);
        this.createAddFilesButton(addFileAction, libraryAction);
        this.createFilterToggleButton();
        this.fileCountLabel = new JLabel();
        this.fileCountLabel.setForeground(this.fileCountColor);
        this.fileCountLabel.setFont(this.fileCountFont);
        this.headerBar.setLayout(new MigLayout("insets 0 5 1 5, gap 0, fill"));
        this.headerBar.add((Component)this.addFilesButton, "push");
        this.headerBar.add((Component)playerPanel, "pos 0.5al 0.5al");
        this.headerBar.add((Component)this.fileCountLabel, "gapafter 5, pad -2 0 0 0");
        this.headerBar.add(this.filterToggleButton);
        this.tableListLayout = new CardLayout();
        this.tableListPanel = new JPanel(this.tableListLayout);
        this.libraryTable.setTransferHandler(this.transferHandler);
        SwingHacks.fixDnDforKDE(this.libraryTable);
        this.libraryScrollPane = new JScrollPane(this.libraryTable);
        this.libraryScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.configureEnclosingScrollPane(this.libraryScrollPane);
        JXLayer<JComponent> layer = new JXLayer<JComponent>(this.libraryScrollPane, this.lockableUI);
        this.tableListPanel.add(layer, TABLE);
        this.setupHighlighters();
        this.add((Component)this.libraryNavigatorPanel, "dock west, growy");
        this.add((Component)this.headerBar, "dock north, growx");
        this.add((Component)this.libraryFilterPanel.getComponent(), "dock north, growx, hidemode 3");
        this.add((Component)this.librarySharingPanel.getComponent(), "dock west, growy, hidemode 3");
        this.add((Component)this.tableListPanel, "grow");
        this.add((Component)this.publicSharedFeedbackPanel.getComponent(), "dock south, growx, hidemode 3");
    }

    protected void configureEnclosingScrollPane(JScrollPane scrollPane) {
        JTableHeader th = new JTableHeader();
        th.setDefaultRenderer(new TableCellHeaderRenderer());
        Component renderer = th.getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, -1);
        JPanel cornerComponent = new JPanel(new BorderLayout());
        cornerComponent.add(renderer, "Center");
        scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerComponent);
    }

    @Inject
    void register(LibraryManager libraryManager, final @Audio PlayerMediator playerMediator) {
        final LibraryFileList libraryList = libraryManager.getLibraryManagedList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryPanel.this.selectedNavItem = LibraryPanel.this.libraryNavigatorPanel.getSelectedNavItem();
                LibraryPanel.this.eventList = libraryList.getSwingModel();
                LibraryPanel.this.selectTable(LibraryPanel.this.libraryFilterPanel.getSelectedTableFormat(), LibraryPanel.this.libraryFilterPanel.getSelectedCategory());
                LibraryPanel.this.configureEnclosingScrollPane(LibraryPanel.this.libraryScrollPane);
            }
        });
        this.libraryFilterPanel.addSearchTabListener(new LibraryFilterPanel.LibraryCategoryListener(){

            @Override
            public void categorySelected(Category category) {
                if (category != LibraryPanel.this.getSelectedCategory()) {
                    if (playerMediator.isActivePlaylist(LibraryPanel.this.selectedNavItem) && LibraryPanel.isPlayable(LibraryPanel.this.selectedCategory) && !LibraryPanel.isPlayable(LibraryPanel.this.libraryFilterPanel.getSelectedCategory())) {
                        playerMediator.setPlaylist(LibraryPanel.this.libraryTable.getPlayableList());
                    }
                    LibraryPanel.this.selectTable(LibraryPanel.this.libraryFilterPanel.getSelectedTableFormat(), LibraryPanel.this.libraryFilterPanel.getSelectedCategory());
                }
            }
        });
        this.libraryNavigatorPanel.addTableSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    LibraryPanel.this.selectedNavItem.setFilteredText(LibraryPanel.this.libraryFilterPanel.getFilterField().getText());
                    LibraryPanel.this.selectedNavItem.setSelectedCategory(LibraryPanel.this.libraryFilterPanel.getSelectedCategory());
                    LibraryNavItem navItem = LibraryPanel.this.libraryNavigatorPanel.getSelectedNavItem();
                    if (playerMediator.isActivePlaylist(LibraryPanel.this.selectedNavItem) && !playerMediator.isActivePlaylist(navItem) && LibraryPanel.isPlayable(LibraryPanel.this.selectedCategory)) {
                        playerMediator.setPlaylist(LibraryPanel.this.libraryTable.getPlayableList());
                    }
                    LibraryPanel.this.selectedNavItem = navItem;
                    LibraryPanel.this.libraryFilterPanel.setSelectedCategory(navItem.getSelectedCategory(), navItem.getFilteredText());
                    LibraryPanel.this.setPublicSharedComponentVisible(navItem);
                    LibraryPanel.this.eventList = navItem.getLocalFileList().getSwingModel();
                    LibraryPanel.this.selectSharing(navItem);
                    LibraryPanel.this.selectTable(LibraryPanel.this.libraryFilterPanel.getSelectedTableFormat(), LibraryPanel.this.libraryFilterPanel.getSelectedCategory());
                }
            }
        });
        playerMediator.addMediatorListener(new PlayerMediatorListener(){

            @Override
            public void progressUpdated(float progress) {
            }

            @Override
            public void songChanged(String name) {
                if (LibraryPanel.this.libraryTable.isVisible() && LibraryPanel.isPlayable(LibraryPanel.this.libraryFilterPanel.getSelectedCategory())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryPanel.this.libraryTable.repaint();
                        }
                    });
                }
            }

            @Override
            public void stateChanged(final PlayerState state) {
                if ((state == PlayerState.STOPPED || state == PlayerState.EOM || state == PlayerState.UNKNOWN || state == PlayerState.NO_SOUND_DEVICE) && LibraryPanel.this.libraryTable.isVisible() && LibraryPanel.isPlayable(LibraryPanel.this.libraryFilterPanel.getSelectedCategory())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryPanel.this.libraryTable.repaint();
                            if (state == PlayerState.NO_SOUND_DEVICE && OSUtils.isWindows7()) {
                                FocusJOptionPane.showConfirmDialog(null, I18n.tr("LimeWire could not play this file. There may not be a sound device installed on your computer or your speakers may not be plugged in."), I18n.tr("Problem Playing File"), 2);
                            }
                        }
                    });
                }
            }
        });
        this.librarySharingPanel.getComponent().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("EDIT_MODE")) {
                    LibraryPanel.this.setEditSharingModeEnabled((Boolean)evt.getNewValue());
                }
            }
        });
    }

    private void setEditSharingModeEnabled(boolean value) {
        this.lockableUI.setLocked(value);
        this.addFilesButton.setEnabled(!value);
    }

    public Rectangle getTableListRect() {
        Point location = this.tableListPanel.getLocation();
        Dimension size = this.tableListPanel.getSize();
        return new Rectangle(location.x, location.y, size.width, size.height);
    }

    public void selectLocalFileList(LocalFileList localFileList) {
        this.libraryNavigatorPanel.selectLocalFileList(localFileList);
    }

    public void selectAndScrollTo(File file) {
        if (file != null) {
            this.libraryFilterPanel.clearFilters();
            this.libraryTable.selectAndScrollTo(file);
        }
    }

    public void selectAndScrollTo(URN urn) {
        if (urn != null) {
            this.libraryFilterPanel.clearFilters();
            this.libraryTable.selectAndScrollTo(urn);
        }
    }

    private void selectSharing(LibraryNavItem navItem) {
        if (navItem != null && navItem.getLocalFileList() instanceof SharedFileList) {
            this.librarySharingPanel.setSharedFileList((SharedFileList)navItem.getLocalFileList());
        }
        this.librarySharingPanel.getComponent().setVisible(navItem != null && navItem.getType() == LibraryNavItem.NavType.LIST);
        if (!this.librarySharingPanel.getComponent().isVisible()) {
            this.setEditSharingModeEnabled(false);
        }
    }

    private void createImageList() {
        this.libraryImagePanel = this.libraryImagePanelProvider.get();
        this.libraryImagePanel.setTransferHandler(this.transferHandler);
        this.tableListPanel.add((Component)this.libraryImagePanel, LIST);
    }

    public static boolean isPlayable(Category category) {
        return category == null || category == Category.AUDIO;
    }

    public EventList<LocalFileItem> getPlayableList() {
        return this.libraryTable.getPlayableList();
    }

    public Category getSelectedCategory() {
        return this.selectedCategory;
    }

    public LibraryNavItem getSelectedNavItem() {
        return this.libraryNavigatorPanel.getSelectedNavItem();
    }

    List<File> getSelectedFiles() {
        List<LocalFileItem> selected = this.selectedCategory == Category.IMAGE ? this.libraryImagePanel.getSelection() : this.libraryTable.getSelection();
        ArrayList<File> files = new ArrayList<File>(selected.size());
        for (LocalFileItem item : selected) {
            files.add(item.getFile());
        }
        return files;
    }

    public List<LocalFileItem> getSelectedItems() {
        List<LocalFileItem> selected = this.selectedCategory == Category.IMAGE ? this.libraryImagePanel.getSelection() : this.libraryTable.getSelection();
        return selected;
    }

    private void selectTable(AbstractLibraryFormat<LocalFileItem> libraryTableFormat, Category category) {
        this.selectedCategory = category;
        if (category != Category.IMAGE) {
            this.setEventListOnTable(this.eventList);
            this.libraryTable.setupCellRenderers(category, libraryTableFormat);
            this.libraryTable.applySavedColumnSettings();
            TableColumnExt column = this.libraryTable.getColumnExt(libraryTableFormat.getColumnName(libraryTableFormat.getActionColumn()));
            if (column != null) {
                column.setVisible(this.libraryNavigatorPanel.getSelectedNavItem().getType() != LibraryNavItem.NavType.LIBRARY);
            }
            this.tableListLayout.show(this.tableListPanel, TABLE);
        } else {
            if (this.libraryImagePanel == null) {
                this.createImageList();
            }
            this.setEventListOnImages(this.eventList);
            this.libraryImagePanel.setShowButtons(this.libraryNavigatorPanel.getSelectedNavItem().getType() != LibraryNavItem.NavType.LIBRARY);
            this.tableListLayout.show(this.tableListPanel, LIST);
        }
    }

    private void createAddFilesButton(AddFileAction addFileAction, LibrarySharingAction libraryAction) {
        this.addFilesButton = new JXButton(addFileAction);
        this.addFilesButton.setIcon(this.plusIcon);
        this.addFilesButton.setRolloverIcon(this.plusIcon);
        this.addFilesButton.setPressedIcon(this.plusIcon);
        this.addFilesButton.addActionListener(libraryAction);
        this.addFilesButton.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.buttonDecorator.decorateDarkFullImageButton(this.addFilesButton, BorderPainter.AccentType.SHADOW);
    }

    private void createFilterToggleButton() {
        this.filterToggleButton = new JXButton(I18n.tr("Filter"));
        this.filterToggleButton.setSelected(SwingUiSettings.SHOW_LIBRARY_FILTERS.getValue());
        this.filterToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryPanel.this.filterToggleButton.setSelected(!LibraryPanel.this.filterToggleButton.isSelected());
                LibraryPanel.this.libraryFilterPanel.getComponent().setVisible(LibraryPanel.this.filterToggleButton.isSelected());
                LibraryPanel.this.libraryFilterPanel.clearFilters();
                LibraryPanel.this.libraryFilterPanel.getFilterField().requestFocusInWindow();
                SwingUiSettings.SHOW_LIBRARY_FILTERS.setValue(LibraryPanel.this.filterToggleButton.isSelected());
            }
        });
        this.filterToggleButton.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.buttonDecorator.decorateDarkFullImageButton(this.filterToggleButton, BorderPainter.AccentType.SHADOW);
    }

    private EventList<LocalFileItem> recreateFilterList(EventList<LocalFileItem> eventList) {
        if (this.filteredList != null) {
            this.filteredList.dispose();
            this.filteredList = null;
        }
        if (this.textFilterList != null) {
            this.textFilterList.removeListEventListener(this.fileCountListener);
            this.textFilterList.dispose();
        }
        if (this.selectedCategory != null) {
            final Category category = this.selectedCategory;
            this.filteredList = GlazedListsFactory.filterList(eventList, new Matcher<LocalFileItem>(){

                @Override
                public boolean matches(LocalFileItem item) {
                    return item.getCategory().equals((Object)category);
                }
            });
        }
        TextComponentMatcherEditor<LocalFileItem> textMatcherEditor = new TextComponentMatcherEditor<LocalFileItem>(this.libraryFilterPanel.getFilterField(), new LocalFileItemFilterator(this.selectedCategory));
        this.textFilterList = GlazedListsFactory.filterList(this.filteredList == null ? eventList : this.filteredList, textMatcherEditor);
        this.setFileCount(this.textFilterList.size(), eventList.size());
        this.textFilterList.addListEventListener(this.fileCountListener);
        return this.textFilterList;
    }

    private void setEventListOnTable(EventList<LocalFileItem> eventList) {
        this.libraryTable.setEventList(this.recreateFilterList(eventList), this.libraryFilterPanel.getSelectedTableFormat(), LibraryPanel.isPlayable(this.selectedCategory));
    }

    private void setEventListOnImages(EventList<LocalFileItem> eventList) {
        this.libraryImagePanel.setEventList(this.recreateFilterList(eventList));
    }

    private void setPublicSharedComponentVisible(LibraryNavItem navItem) {
        this.publicSharedFeedbackPanel.getComponent().setVisible(navItem != null && navItem.getType() == LibraryNavItem.NavType.PUBLIC_SHARED);
    }

    private void setupHighlighters() {
        TableColors tableColors = new TableColors();
        ColorHighlighter storeHighlighter = new ColorHighlighter(new GrayHighlightPredicate(), null, tableColors.getDisabledForegroundColor(), null, tableColors.getDisabledForegroundColor());
        this.libraryTable.addHighlighter(storeHighlighter);
    }

    private void setFileCount(int filterSize, int totalCount) {
        if (this.selectedCategory == null && filterSize == totalCount) {
            this.fileCountLabel.setText(I18n.tr("{0} files", totalCount));
        } else {
            this.fileCountLabel.setText(I18n.tr("{0} of {1} files", filterSize, totalCount));
        }
    }

    public void clearFilters() {
        this.libraryFilterPanel.clearFilters();
    }

    public void editSharedListName(SharedFileList sharedFileList) {
        this.libraryNavigatorPanel.editSharedListName(sharedFileList);
    }

    public void showEditMode() {
        if (this.librarySharingPanel.getComponent().isVisible()) {
            this.librarySharingPanel.showEditMode();
        }
    }

    private class LockedUI
    extends LockableUI {
        private JXPanel panel;

        public LockedUI(LayerEffect ... lockedEffects) {
            super(lockedEffects);
            this.panel = new JXPanel();
            this.panel.setBackground(LibraryPanel.this.tableOverlayColor);
            this.panel.setVisible(false);
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            JXLayer l = (JXLayer)c;
            l.getGlassPane().setLayout(new BorderLayout());
            l.getGlassPane().add((Component)this.panel, "Center");
        }

        @Override
        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            JXLayer l = (JXLayer)c;
            l.getGlassPane().setLayout(new FlowLayout());
            l.getGlassPane().remove(this.panel);
        }

        @Override
        public void setLocked(boolean isLocked) {
            super.setLocked(isLocked);
            this.panel.setVisible(isLocked);
        }

        @Override
        public Cursor getLockedCursor() {
            return Cursor.getDefaultCursor();
        }
    }

    private class FileCountListener
    implements ListEventListener<LocalFileItem> {
        private FileCountListener() {
        }

        @Override
        public void listChanged(ListEvent<LocalFileItem> listChanges) {
            LibraryPanel.this.setFileCount(LibraryPanel.this.textFilterList.size(), LibraryPanel.this.filteredList == null ? LibraryPanel.this.eventList.size() : LibraryPanel.this.filteredList.size());
        }
    }

    private class GrayHighlightPredicate
    implements HighlightPredicate {
        private GrayHighlightPredicate() {
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            LibraryNavItem navItem = LibraryPanel.this.libraryNavigatorPanel.getSelectedNavItem();
            LocalFileItem item = (LocalFileItem)LibraryPanel.this.libraryTable.getLibraryTableModel().getElementAt(adapter.row);
            if (navItem.getType() == LibraryNavItem.NavType.PUBLIC_SHARED || navItem.getType() == LibraryNavItem.NavType.LIST && ((SharedFileList)navItem.getLocalFileList()).getFriendIds().size() > 0) {
                return !item.isShareable();
            }
            return !item.isLoaded();
        }
    }
}

