/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.animate;

import java.awt.Point;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.jdesktop.animation.transitions.Effect;
import org.jdesktop.animation.transitions.effects.CompositeEffect;
import org.jdesktop.animation.transitions.effects.FadeIn;
import org.jdesktop.animation.transitions.effects.FadeOut;

public class EffectsUtils {
    public static Effect createMoveInEffect(int startX, int startY, boolean grow) {
        CompositeEffect effect = new CompositeEffect();
        effect.addEffect(new MoveIn(startX, startY));
        if (grow) {
            effect.addEffect(new Grow());
        } else {
            effect.addEffect(new FadeIn());
        }
        return effect;
    }

    public static Effect createMoveOutEffect(int endX, int endY, boolean shrink) {
        CompositeEffect effect = new CompositeEffect();
        effect.addEffect(new MoveOut(endX, endY));
        if (shrink) {
            effect.addEffect(new Shrink());
        } else {
            effect.addEffect(new FadeOut());
        }
        return effect;
    }

    public static class Shrink
    extends Effect {
        private PropertySetter psWidth;
        private PropertySetter psHeight;

        @Override
        public void init(Animator animator, Effect parentEffect) {
            Effect targetEffect = parentEffect == null ? this : parentEffect;
            this.psWidth = new PropertySetter((Object)targetEffect, "width", this.getStart().getWidth(), 0);
            animator.addTarget(this.psWidth);
            this.psHeight = new PropertySetter((Object)targetEffect, "height", this.getStart().getHeight(), 0);
            animator.addTarget(this.psHeight);
            super.init(animator, parentEffect);
        }

        @Override
        public void cleanup(Animator animator) {
            animator.removeTarget(this.psWidth);
            animator.removeTarget(this.psHeight);
        }
    }

    public static class Grow
    extends Effect {
        private PropertySetter psWidth;
        private PropertySetter psHeight;

        @Override
        public void init(Animator animator, Effect parentEffect) {
            Effect targetEffect = parentEffect == null ? this : parentEffect;
            this.psWidth = new PropertySetter((Object)targetEffect, "width", 0, this.getEnd().getWidth());
            animator.addTarget(this.psWidth);
            this.psHeight = new PropertySetter((Object)targetEffect, "height", 0, this.getEnd().getHeight());
            animator.addTarget(this.psHeight);
            super.init(animator, parentEffect);
        }

        @Override
        public void cleanup(Animator animator) {
            animator.removeTarget(this.psWidth);
            animator.removeTarget(this.psHeight);
        }
    }

    public static class MoveOut
    extends Effect {
        private final Point endLocation = new Point();
        private PropertySetter ps;

        public MoveOut(int x, int y) {
            this.endLocation.x = x;
            this.endLocation.y = y;
        }

        @Override
        public void init(Animator animator, Effect parentEffect) {
            Effect targetEffect = parentEffect == null ? this : parentEffect;
            this.ps = new PropertySetter((Object)targetEffect, "location", new Point(this.getStart().getX(), this.getStart().getY()), this.endLocation);
            animator.addTarget(this.ps);
            super.init(animator, parentEffect);
        }

        @Override
        public void cleanup(Animator animator) {
            animator.removeTarget(this.ps);
        }
    }

    public static class MoveIn
    extends Effect {
        private final Point startLocation = new Point();
        private PropertySetter ps;

        public MoveIn(int x, int y) {
            this.startLocation.x = x;
            this.startLocation.y = y;
        }

        @Override
        public void init(Animator animator, Effect parentEffect) {
            Effect targetEffect = parentEffect == null ? this : parentEffect;
            this.ps = new PropertySetter((Object)targetEffect, "location", this.startLocation, new Point(this.getEnd().getX(), this.getEnd().getY()));
            animator.addTarget(this.ps);
            super.init(animator, parentEffect);
        }

        @Override
        public void cleanup(Animator animator) {
            animator.removeTarget(this.ps);
        }
    }
}

