/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModelManager;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.DatabaseSettings;
import org.limewire.mojito.statistics.DatabaseStatisticContainer;
import org.limewire.service.ErrorService;

public class StorablePublisher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(StorablePublisher.class);
    private final Context context;
    private final DatabaseStatisticContainer databaseStats;
    private ScheduledFuture future;
    private final PublishTask publishTask = new PublishTask();

    public StorablePublisher(Context context) {
        this.context = context;
        this.databaseStats = context.getDatabaseStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PublishTask publishTask = this.publishTask;
        synchronized (publishTask) {
            if (this.future == null) {
                long delay;
                long initialDelay = delay = DatabaseSettings.STORABLE_PUBLISHER_PERIOD.getValue();
                this.future = this.context.getDHTExecutorService().scheduleWithFixedDelay(this, initialDelay, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PublishTask publishTask = this.publishTask;
        synchronized (publishTask) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
                this.publishTask.stop();
            }
        }
    }

    @Override
    public void run() {
        if (this.context.isBootstrapped() && !this.context.isBootstrapping()) {
            if (this.publishTask.isDone()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(this.context.getName() + " begins with publishing");
                }
                this.publishTask.start();
            }
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info(this.context.getName() + " is not bootstrapped");
            }
            this.publishTask.stop();
        }
    }

    private class StoreResultHandler
    implements DHTFutureListener<StoreResult> {
        private final Storable storable;

        private StoreResultHandler(Storable storable) {
            this.storable = storable;
        }

        @Override
        public void handleFutureSuccess(final StoreResult result) {
            if (LOG.isInfoEnabled()) {
                Collection<? extends Contact> locations = result.getLocations();
                if (!locations.isEmpty()) {
                    LOG.info(result);
                } else {
                    LOG.info("Failed to store " + result.getValues());
                }
            }
            this.storable.handleStoreResult(result);
            StorablePublisher.this.context.getDHTExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    StorablePublisher.this.context.getStorableModelManager().handleStoreResult(StoreResultHandler.this.storable, result);
                }
            });
            if (!StorablePublisher.this.publishTask.next()) {
                StorablePublisher.this.publishTask.stop();
            }
        }

        @Override
        public void handleExecutionException(ExecutionException e) {
            LOG.error("ExecutionException", e);
            if (!(e.getCause() instanceof DHTException)) {
                ErrorService.error(e);
            }
            if (!StorablePublisher.this.publishTask.next()) {
                StorablePublisher.this.publishTask.stop();
            }
        }

        @Override
        public void handleCancellationException(CancellationException e) {
            LOG.debug("CancellationException", e);
            StorablePublisher.this.publishTask.stop();
        }

        @Override
        public void handleInterruptedException(InterruptedException e) {
            LOG.debug("InterruptedException", e);
            StorablePublisher.this.publishTask.stop();
        }
    }

    private class PublishTask {
        private Iterator<Storable> values = null;
        private DHTFuture<StoreResult> future = null;

        private PublishTask() {
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            this.values = null;
        }

        public synchronized boolean isDone() {
            return this.values == null || !this.values.hasNext();
        }

        public synchronized void start() {
            assert (this.isDone());
            StorableModelManager modelManager = StorablePublisher.this.context.getStorableModelManager();
            Collection<Storable> valuesToPublish = modelManager.getStorables();
            if (valuesToPublish == null) {
                valuesToPublish = Collections.emptyList();
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(StorablePublisher.this.context.getName() + " has " + valuesToPublish.size() + " DHTValues to process");
            }
            this.values = valuesToPublish.iterator();
            this.next();
        }

        private synchronized boolean next() {
            if (this.isDone()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(StorablePublisher.this.context.getName() + " is done with publishing");
                }
                return false;
            }
            while (this.values.hasNext()) {
                Storable storable = this.values.next();
                if (!this.publish(storable)) continue;
                return true;
            }
            return false;
        }

        private boolean publish(Storable storable) {
            ((StorablePublisher)StorablePublisher.this).databaseStats.REPUBLISHED_VALUES.incrementStat();
            this.future = StorablePublisher.this.context.store(DHTValueEntity.createFromStorable(StorablePublisher.this.context, storable));
            this.future.addDHTFutureListener(new StoreResultHandler(storable));
            return true;
        }
    }
}

