/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.HashMap;
import java.util.Map;
import org.limewire.collection.NoMoreStorageException;

public class FixedsizeHashMap<K, V> {
    private final Map<K, V> hashMap;
    private final int maxSize;

    public FixedsizeHashMap(int size) {
        this.hashMap = new HashMap(size * 4 / 3);
        this.maxSize = size;
    }

    public synchronized V put(K key, V value) throws NoMoreStorageException {
        V retValue = null;
        if (this.hashMap.size() < this.maxSize) {
            retValue = this.hashMap.put(key, value);
        } else {
            retValue = this.hashMap.get(key);
            if (retValue != null) {
                retValue = this.hashMap.put(key, value);
            } else {
                throw new NoMoreStorageException();
            }
        }
        return retValue;
    }

    public synchronized V get(K key) {
        return this.hashMap.get(key);
    }

    public synchronized void clear() {
        this.hashMap.clear();
    }

    public synchronized String toString() {
        return this.hashMap.toString();
    }
}

