/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.util;

import java.util.Iterator;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.tag.AsfFieldKey;
import org.jaudiotagger.audio.asf.tag.AsfTag;
import org.jaudiotagger.audio.asf.tag.AsfTagCoverField;
import org.jaudiotagger.audio.asf.tag.AsfTagField;
import org.jaudiotagger.audio.asf.tag.AsfTagTextField;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.reference.GenreTypes;

public class TagConverter {
    public static void assignCommonTagValues(Tag tag, ExtendedContentDescription description) {
        ContentDescriptor tmp = null;
        if (!Utils.isBlank(tag.getFirstAlbum())) {
            tmp = new ContentDescriptor(AsfFieldKey.ALBUM.getFieldName(), 0);
            tmp.setStringValue(tag.getFirstAlbum());
            description.addOrReplace(tmp);
        } else {
            description.remove(AsfFieldKey.ALBUM.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirstTrack())) {
            tmp = new ContentDescriptor(AsfFieldKey.TRACK.getFieldName(), 0);
            tmp.setStringValue(tag.getFirstTrack());
            description.addOrReplace(tmp);
        } else {
            description.remove(AsfFieldKey.TRACK.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirstYear())) {
            tmp = new ContentDescriptor(AsfFieldKey.YEAR.getFieldName(), 0);
            tmp.setStringValue(tag.getFirstYear());
            description.addOrReplace(tmp);
        } else {
            description.remove(AsfFieldKey.YEAR.getFieldName());
        }
        if (!Utils.isBlank(tag.getFirstGenre())) {
            tmp = new ContentDescriptor(AsfFieldKey.GENRE.getFieldName(), 0);
            tmp.setStringValue(tag.getFirstGenre());
            description.addOrReplace(tmp);
            Integer genreNum = GenreTypes.getInstanceOf().getIdForName(tag.getFirstGenre());
            if (genreNum != null) {
                tmp = new ContentDescriptor(AsfFieldKey.GENRE_ID.getFieldName(), 0);
                tmp.setStringValue("(" + genreNum + ")");
                description.addOrReplace(tmp);
            } else {
                description.remove(AsfFieldKey.GENRE_ID.getFieldName());
            }
        } else {
            description.remove(AsfFieldKey.GENRE.getFieldName());
            description.remove(AsfFieldKey.GENRE_ID.getFieldName());
        }
    }

    public static void assignOptionalTagValues(AsfTag tag, ExtendedContentDescription descriptor) {
        assert (tag.isCopyingFields());
        Iterator it = tag.getAsfFields();
        while (it.hasNext()) {
            ContentDescriptor contentDesc = ((AsfTagField)it.next()).getDescriptor();
            if (descriptor.containsDescriptor(contentDesc.getName())) continue;
            descriptor.addOrReplace(contentDesc);
        }
    }

    public static ContentDescription createContentDescription(AsfTag tag) {
        ContentDescription result = new ContentDescription();
        result.setAuthor(tag.getFirstArtist());
        result.setTitle(tag.getFirstTitle());
        result.setComment(tag.getFirstComment());
        result.setCopyRight(tag.getFirstCopyright());
        result.setRating(tag.getFirstRating());
        return result;
    }

    public static AsfTag createTagOf(AsfHeader source) {
        AsfTag result = new AsfTag(true);
        ContentDescription contentDescription = source.findContentDescription();
        ExtendedContentDescription extDesc = source.findExtendedContentDescription();
        if (source.findContentDescription() != null) {
            result.setArtist(contentDescription.getAuthor());
            result.setComment(contentDescription.getComment());
            result.setTitle(contentDescription.getTitle());
            result.setCopyright(contentDescription.getCopyRight());
            result.setRating(contentDescription.getRating());
        }
        if (extDesc != null) {
            for (ContentDescriptor current : extDesc.getDescriptors()) {
                if (AsfTag.storesDescriptor(current)) continue;
                if (current.getType() == 1) {
                    if (current.getName().equals(AsfFieldKey.COVER_ART.getFieldName())) {
                        result.add(new AsfTagCoverField(current));
                        continue;
                    }
                    result.add(new AsfTagField(current));
                    continue;
                }
                result.add(new AsfTagTextField(current));
            }
        }
        return result;
    }
}

