/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.detector.InvalidMagicMimeEntryException;
import eu.medsea.mimeutil.detector.MagicMimeEntryOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

class MagicMimeEntry {
    public static final int STRING_TYPE = 1;
    public static final int BELONG_TYPE = 2;
    public static final int SHORT_TYPE = 3;
    public static final int LELONG_TYPE = 4;
    public static final int BESHORT_TYPE = 5;
    public static final int LESHORT_TYPE = 6;
    public static final int BYTE_TYPE = 7;
    public static final int UNKNOWN_TYPE = 20;
    private ArrayList subEntries = new ArrayList();
    private int checkBytesFrom;
    private int type;
    private String typeStr;
    private String content;
    private long contentNumber;
    private MimeType mimeType;
    private String mimeEnc;
    private MagicMimeEntry parent;
    private MagicMimeEntryOperation operation = MagicMimeEntryOperation.EQUALS;
    boolean isBetween;

    public MagicMimeEntry(ArrayList arrayList) throws InvalidMagicMimeEntryException {
        this(0, null, arrayList);
    }

    private MagicMimeEntry(int n, MagicMimeEntry magicMimeEntry, ArrayList arrayList) throws InvalidMagicMimeEntryException {
        int n2;
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        this.parent = magicMimeEntry;
        if (magicMimeEntry != null) {
            magicMimeEntry.subEntries.add(this);
        }
        try {
            this.addEntry((String)arrayList.get(0));
        }
        catch (Exception exception) {
            throw new InvalidMagicMimeEntryException(arrayList, (Throwable)exception);
        }
        arrayList.remove(0);
        while (arrayList.size() > 0 && (n2 = this.howManyGreaterThans((String)arrayList.get(0))) > n) {
            new MagicMimeEntry(n2, this, arrayList);
        }
    }

    public String toString() {
        return "MimeMagicType: " + this.checkBytesFrom + ", " + this.type + ", " + this.content + ", " + this.mimeType + ", " + this.mimeEnc;
    }

    public void traverseAndPrint(String string) {
        System.out.println(string + this.toString());
        int n = this.subEntries.size();
        for (int i = 0; i < n; ++i) {
            MagicMimeEntry magicMimeEntry = (MagicMimeEntry)this.subEntries.get(i);
            magicMimeEntry.traverseAndPrint(string + "\t");
        }
    }

    private int howManyGreaterThans(String string) {
        int n;
        if (string == null) {
            return -1;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == '>'; ++n) {
        }
        return n;
    }

    void addEntry(String string) throws InvalidMagicMimeEntryException {
        String string2 = string.replaceAll("[\\\\][ ]", "<##>").replaceAll("^>*", "").replaceAll("\\s+", "\t").replaceAll("[\t]{2,}", "\t").replaceAll("<##>", "\\\\ ");
        String[] stringArray = string2.split("\t");
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if ("".equals(stringArray[i])) continue;
            vector.add(stringArray[i]);
        }
        stringArray = new String[vector.size()];
        if ((stringArray = vector.toArray(stringArray)).length > 0) {
            String string3 = stringArray[0].trim();
            try {
                this.checkBytesFrom = string3.startsWith("0x") ? Integer.parseInt(string3.substring(2), 16) : Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidMagicMimeEntryException(Collections.singletonList(this), (Throwable)numberFormatException);
            }
        }
        if (stringArray.length > 1) {
            this.typeStr = stringArray[1].trim();
            this.type = this.getType(this.typeStr);
        }
        if (stringArray.length > 2) {
            this.content = this.ltrim(stringArray[2]);
            switch (this.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.operation = MagicMimeEntryOperation.getOperationForNumberField(this.content);
                    break;
                }
                default: {
                    this.operation = MagicMimeEntryOperation.getOperationForStringField(this.content);
                }
            }
            if (this.content.length() > 0 && this.content.charAt(0) == this.operation.getOperationID()) {
                this.content = this.content.substring(1);
            }
            this.content = MagicMimeEntry.stringWithEscapeSubstitutions(this.content);
        } else {
            this.content = "";
        }
        if (stringArray.length > 3) {
            this.mimeType = new MimeType(stringArray[3].trim());
        }
        if (stringArray.length > 4) {
            this.mimeEnc = stringArray[4].trim();
        }
        this.initContentNumber();
    }

    private void initContentNumber() {
        this.contentNumber = 0L;
        if (this.content.length() == 0) {
            return;
        }
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.contentNumber = this.content.startsWith("0x") ? Long.parseLong(this.content.substring(2).trim(), 16) : (this.content.startsWith("0") ? Long.parseLong(this.content.trim(), 8) : Long.parseLong(this.content.trim()));
            }
        }
    }

    private String ltrim(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return string.substring(i);
        }
        return string;
    }

    private int getType(String string) {
        if (string.startsWith("string")) {
            return 1;
        }
        if (string.startsWith("belong")) {
            return 2;
        }
        if (string.equals("short")) {
            return 3;
        }
        if (string.startsWith("lelong")) {
            return 4;
        }
        if (string.startsWith("beshort")) {
            return 5;
        }
        if (string.startsWith("leshort")) {
            return 6;
        }
        if (string.equals("byte")) {
            return 7;
        }
        return 20;
    }

    public int getCheckBytesFrom() {
        return this.checkBytesFrom;
    }

    public int getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MagicMimeEntry getMatch(InputStream inputStream) throws IOException {
        int n = this.getInputStreamMarkLength();
        inputStream.mark(n);
        try {
            int n2;
            byte[] byArray = new byte[n];
            int n3 = 0;
            for (int i = n; i > 0 && (n2 = inputStream.read(byArray, n3, i)) >= 0; i -= n2) {
                n3 += n2;
            }
            MagicMimeEntry magicMimeEntry = this.getMatch(byArray);
            return magicMimeEntry;
        }
        finally {
            inputStream.reset();
        }
    }

    MagicMimeEntry getMatch(byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = this.readBuffer(byArray);
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.position(0);
        boolean bl = this.match(byteBuffer);
        if (bl) {
            int n = this.subEntries.size();
            MimeType mimeType = this.getMimeType();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    MagicMimeEntry magicMimeEntry = (MagicMimeEntry)this.subEntries.get(i);
                    MagicMimeEntry magicMimeEntry2 = magicMimeEntry.getMatch(byArray);
                    if (magicMimeEntry2 == null) continue;
                    return magicMimeEntry2;
                }
                if (mimeType != null) {
                    return this;
                }
            } else if (mimeType != null) {
                return this;
            }
        }
        return null;
    }

    MagicMimeEntry getMatch(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer = this.readBuffer(randomAccessFile);
        if (byteBuffer == null) {
            return null;
        }
        boolean bl = this.match(byteBuffer);
        if (bl) {
            MimeType mimeType = this.getMimeType();
            if (this.subEntries.size() > 0) {
                for (int i = 0; i < this.subEntries.size(); ++i) {
                    MagicMimeEntry magicMimeEntry = (MagicMimeEntry)this.subEntries.get(i);
                    MagicMimeEntry magicMimeEntry2 = magicMimeEntry.getMatch(randomAccessFile);
                    if (magicMimeEntry2 == null) continue;
                    return magicMimeEntry2;
                }
                if (mimeType != null) {
                    return this;
                }
            } else if (mimeType != null) {
                return this;
            }
        }
        return null;
    }

    private ByteBuffer readBuffer(byte[] byArray) throws IOException {
        int n = this.getCheckBytesFrom();
        if (byArray == null || n > byArray.length) {
            return null;
        }
        ByteBuffer byteBuffer = null;
        try {
            switch (this.getType()) {
                case 1: {
                    int n2 = 0;
                    int n3 = this.typeStr.indexOf(">");
                    if (n3 != -1) {
                        n2 = Integer.parseInt(this.typeStr.substring(n3 + 1, this.typeStr.length() - 1));
                        this.isBetween = true;
                    } else {
                        n2 = this.getContent().length();
                    }
                    byteBuffer = ByteBuffer.allocate(n2 + 1);
                    byteBuffer.put(byArray, n, n2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    byteBuffer = ByteBuffer.allocate(2);
                    byteBuffer.put(byArray, n, 2);
                    break;
                }
                case 2: 
                case 4: {
                    byteBuffer = ByteBuffer.allocate(4);
                    byteBuffer.put(byArray, n, 4);
                    break;
                }
                case 7: {
                    byteBuffer = ByteBuffer.allocate(1);
                    byteBuffer.put(byteBuffer.array(), n, 1);
                    break;
                }
                default: {
                    byteBuffer = null;
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        return byteBuffer;
    }

    private ByteBuffer readBuffer(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer;
        int n = this.getCheckBytesFrom();
        if ((long)n > randomAccessFile.length()) {
            return null;
        }
        randomAccessFile.seek(n);
        switch (this.getType()) {
            case 1: {
                int n2 = 0;
                int n3 = this.typeStr.indexOf(">");
                if (n3 != -1) {
                    n2 = Integer.parseInt(this.typeStr.substring(n3 + 1, this.typeStr.length() - 1));
                    this.isBetween = true;
                } else {
                    n2 = this.getContent().length();
                }
                byteBuffer = ByteBuffer.allocate(n2);
                randomAccessFile.read(byteBuffer.array(), 0, n2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                byteBuffer = ByteBuffer.allocate(2);
                randomAccessFile.read(byteBuffer.array(), 0, 2);
                break;
            }
            case 2: 
            case 4: {
                byteBuffer = ByteBuffer.allocate(4);
                randomAccessFile.read(byteBuffer.array(), 0, 4);
                break;
            }
            case 7: {
                byteBuffer = ByteBuffer.allocate(1);
                randomAccessFile.read(byteBuffer.array(), 0, 1);
                break;
            }
            default: {
                byteBuffer = null;
            }
        }
        return byteBuffer;
    }

    private int getInputStreamMarkLength() {
        int n = this._getInputStreamMarkLength();
        for (MagicMimeEntry magicMimeEntry : this.subEntries) {
            int n2 = magicMimeEntry.getInputStreamMarkLength();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    private int _getInputStreamMarkLength() {
        switch (this.getType()) {
            case 1: {
                int n = 0;
                int n2 = this.typeStr.indexOf(">");
                if (n2 != -1) {
                    n = Integer.parseInt(this.typeStr.substring(n2 + 1, this.typeStr.length() - 1));
                    this.isBetween = true;
                } else if (this.getContent() != null) {
                    n = this.getContent().length();
                }
                return this.getCheckBytesFrom() + n + 1;
            }
            case 3: 
            case 5: 
            case 6: {
                return this.getCheckBytesFrom() + 2;
            }
            case 2: 
            case 4: {
                return this.getCheckBytesFrom() + 4;
            }
            case 7: {
                return this.getCheckBytesFrom() + 1;
            }
        }
        return 0;
    }

    private boolean match(ByteBuffer byteBuffer) throws IOException {
        boolean bl = true;
        switch (this.getType()) {
            case 1: {
                bl = this.matchString(byteBuffer);
                break;
            }
            case 3: {
                bl = this.matchShort(byteBuffer, ByteOrder.BIG_ENDIAN);
                break;
            }
            case 5: 
            case 6: {
                ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
                if (this.getType() == 6) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                bl = this.matchShort(byteBuffer, byteOrder);
                break;
            }
            case 2: 
            case 4: {
                ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
                if (this.getType() == 4) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                bl = this.matchLong(byteBuffer, byteOrder);
                break;
            }
            case 7: {
                bl = this.matchByte(byteBuffer);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean matchString(ByteBuffer byteBuffer) throws IOException {
        if (this.isBetween) {
            String string = new String(byteBuffer.array());
            return string.contains(this.getContent());
        }
        if (this.operation.equals(MagicMimeEntryOperation.EQUALS)) {
            int n = this.getContent().length();
            for (int i = 0; i < n; ++i) {
                if ((byteBuffer.get(i) & 0xFF) == this.getContent().charAt(i)) continue;
                return false;
            }
            return true;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NOT_EQUALS)) {
            int n = this.getContent().length();
            for (int i = 0; i < n; ++i) {
                if ((byteBuffer.get(i) & 0xFF) == this.getContent().charAt(i)) continue;
                return true;
            }
            return false;
        }
        if (this.operation.equals(MagicMimeEntryOperation.GREATER_THAN)) {
            String string = new String(byteBuffer.array());
            return string.compareTo(this.getContent()) > 0;
        }
        if (this.operation.equals(MagicMimeEntryOperation.LESS_THAN)) {
            String string = new String(byteBuffer.array());
            return string.compareTo(this.getContent()) < 0;
        }
        return false;
    }

    private long getMask(String string) {
        String[] stringArray = string.split("&");
        if (stringArray.length < 2) {
            return 0xFFFFFFFFL;
        }
        if (stringArray[1].startsWith("0x")) {
            return Long.parseLong(stringArray[1].substring(2).trim(), 16);
        }
        if (stringArray[1].startsWith("0")) {
            return Long.parseLong(stringArray[1], 8);
        }
        return Long.parseLong(stringArray[1]);
    }

    private boolean matchByte(ByteBuffer byteBuffer) throws IOException {
        short s = (short)(byteBuffer.get(0) & 0xFF & (short)this.getMask(this.typeStr));
        if (this.operation.equals(MagicMimeEntryOperation.EQUALS)) {
            return (long)s == this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NOT_EQUALS)) {
            return (long)s != this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.GREATER_THAN)) {
            return (long)s > this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.LESS_THAN)) {
            return (long)s < this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.AND)) {
            boolean bl = ((long)s & this.contentNumber) == this.contentNumber;
            return bl;
        }
        if (this.operation.equals(MagicMimeEntryOperation.ANY)) {
            return true;
        }
        if (this.operation.equals(MagicMimeEntryOperation.CLEAR)) {
            long l = (long)s & this.contentNumber;
            boolean bl = (l ^ this.contentNumber) == 0L;
            return bl;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NEGATED)) {
            int n = ~s;
            return (long)n == this.contentNumber;
        }
        return false;
    }

    private boolean matchShort(ByteBuffer byteBuffer, ByteOrder byteOrder) throws IOException {
        byteBuffer.order(byteOrder);
        int n = byteBuffer.getShort() & 0xFFFF;
        long l = (int)this.getMask(this.typeStr);
        n = (int)((long)n & l);
        if (this.operation.equals(MagicMimeEntryOperation.EQUALS)) {
            return (long)n == this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NOT_EQUALS)) {
            return (long)n != this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.GREATER_THAN)) {
            return (long)n > this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.LESS_THAN)) {
            return (long)n < this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.AND)) {
            boolean bl = ((long)n & this.contentNumber) == this.contentNumber;
            return bl;
        }
        if (this.operation.equals(MagicMimeEntryOperation.ANY)) {
            return true;
        }
        if (this.operation.equals(MagicMimeEntryOperation.CLEAR)) {
            long l2 = (long)n & this.contentNumber;
            boolean bl = (l2 ^ this.contentNumber) == 0L;
            return bl;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NEGATED)) {
            int n2 = ~n;
            return (long)n2 == this.contentNumber;
        }
        return false;
    }

    private boolean matchLong(ByteBuffer byteBuffer, ByteOrder byteOrder) throws IOException {
        byteBuffer.order(byteOrder);
        long l = (long)byteBuffer.getInt() & 0xFFFFFFFFL & this.getMask(this.typeStr);
        if (this.operation.equals(MagicMimeEntryOperation.EQUALS)) {
            return l == this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NOT_EQUALS)) {
            return l != this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.GREATER_THAN)) {
            return l > this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.LESS_THAN)) {
            return l < this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.AND)) {
            boolean bl = (l & this.contentNumber) == this.contentNumber;
            return bl;
        }
        if (this.operation.equals(MagicMimeEntryOperation.ANY)) {
            return true;
        }
        if (this.operation.equals(MagicMimeEntryOperation.CLEAR)) {
            long l2 = l & this.contentNumber;
            boolean bl = (l2 ^ this.contentNumber) == 0L;
            return bl;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NEGATED)) {
            long l3 = l ^ 0xFFFFFFFFFFFFFFFFL;
            return l3 == this.contentNumber;
        }
        return false;
    }

    private static String stringWithEscapeSubstitutions(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n && (c = string.charAt(i)) != '\n'; ++i) {
            if (c == '\\') {
                if (++i >= n) {
                    stringBuffer.append(c);
                    break;
                }
                char c2 = string.charAt(i);
                if (c2 == '\\') {
                    stringBuffer.append('\\');
                    continue;
                }
                if (c2 == ' ') {
                    stringBuffer.append(' ');
                    continue;
                }
                if (c2 == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c2 == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c2 == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c2 == 'x') {
                    int n2;
                    if ((i += 2) >= n) {
                        stringBuffer.append(c);
                        stringBuffer.append(c2);
                        break;
                    }
                    String string2 = string.substring(i - 1, i + 1);
                    try {
                        n2 = Integer.parseInt(string2, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(c);
                        stringBuffer.append(string2);
                        break;
                    }
                    stringBuffer.append((char)n2);
                    continue;
                }
                if (c2 >= '0' && c2 <= '7') {
                    int n3 = c2 - 48;
                    if (++i >= n) {
                        stringBuffer.append((char)n3);
                        break;
                    }
                    c2 = string.charAt(i);
                    if (c2 >= '0' && c2 <= '7') {
                        n3 <<= 3;
                        n3 |= c2 - 48;
                        if (++i >= n) {
                            stringBuffer.append((char)n3);
                            break;
                        }
                        c2 = string.charAt(i);
                        if (c2 >= '0' && c2 <= '7') {
                            n3 <<= 3;
                            n3 |= c2 - 48;
                        } else {
                            --i;
                        }
                    } else {
                        --i;
                    }
                    stringBuffer.append((char)n3);
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    public boolean containsMimeType(String string) {
        if (this.mimeType != null && this.mimeType.equals(string)) {
            return true;
        }
        for (MagicMimeEntry magicMimeEntry : this.subEntries) {
            if (!magicMimeEntry.containsMimeType(string)) continue;
            return true;
        }
        return false;
    }

    public MagicMimeEntry getParent() {
        return this.parent;
    }

    public List getSubEntries() {
        return Collections.unmodifiableList(this.subEntries);
    }
}

