/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MessageSentEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.limewire.inspection.InspectionPoint;
import org.limewire.listener.EventBroadcaster;

@Singleton
public class MessageDispatcher {
    private final Executor DISPATCH;
    private final MessageRouter messageRouter;
    @InspectionPoint(value="routed messages")
    private final Message.MessageCounter messageCounter = new Message.MessageCounter(LimeWireUtils.isBetaRelease() ? 300 : 30);
    private final EventBroadcaster<MessageSentEvent> messageSentEventBroadcaster;

    @Inject
    public MessageDispatcher(MessageRouter messageRouter, @Named(value="messageExecutor") Executor dispatch, EventBroadcaster<MessageSentEvent> messageSentEventBroadcaster) {
        this.messageRouter = messageRouter;
        this.DISPATCH = dispatch;
        this.messageSentEventBroadcaster = messageSentEventBroadcaster;
    }

    public void dispatch(Runnable r) {
        this.DISPATCH.execute(r);
    }

    public void dispatchUDP(Message m, InetSocketAddress addr) {
        this.DISPATCH.execute(new UDPDispatch(this.messageRouter, m, addr, this.messageCounter));
    }

    public void dispatchMulticast(Message m, InetSocketAddress addr) {
        this.DISPATCH.execute(new MulticastDispatch(this.messageRouter, m, addr, this.messageCounter));
    }

    public void dispatchTCP(Message m, RoutedConnection conn) {
        this.DISPATCH.execute(new TCPDispatch(this.messageRouter, m, conn, this.messageCounter));
    }

    public void dispatchTCPMessageSent(Message message, RoutedConnection routedConnection) {
        this.messageSentEventBroadcaster.broadcast(new MessageSentEvent(routedConnection, message));
    }

    private static class TCPDispatch
    extends Dispatch {
        private final RoutedConnection conn;

        TCPDispatch(MessageRouter messageRouter, Message m, RoutedConnection conn, Message.MessageCounter counter) {
            super(messageRouter, m, counter);
            this.conn = conn;
        }

        @Override
        protected void dispatch() {
            this.messageRouter.handleMessage(this.m, this.conn);
        }
    }

    private static class MulticastDispatch
    extends Dispatch {
        private final InetSocketAddress addr;

        MulticastDispatch(MessageRouter messageRouter, Message m, InetSocketAddress addr, Message.MessageCounter counter) {
            super(messageRouter, m, counter);
            this.addr = addr;
        }

        @Override
        protected void dispatch() {
            this.messageRouter.handleMulticastMessage(this.m, this.addr);
        }
    }

    private static class UDPDispatch
    extends Dispatch {
        private final InetSocketAddress addr;

        UDPDispatch(MessageRouter messageRouter, Message m, InetSocketAddress addr, Message.MessageCounter counter) {
            super(messageRouter, m, counter);
            this.addr = addr;
        }

        @Override
        protected void dispatch() {
            this.messageRouter.handleUDPMessage(this.m, this.addr);
        }
    }

    private static abstract class Dispatch
    implements Runnable {
        protected final MessageRouter messageRouter;
        protected final Message m;
        protected final Message.MessageCounter counter;

        Dispatch(MessageRouter messageRouter, Message m, Message.MessageCounter counter) {
            this.messageRouter = messageRouter;
            this.m = m;
            this.counter = counter;
        }

        @Override
        public void run() {
            this.counter.countMessage(this.m);
            this.dispatch();
        }

        protected abstract void dispatch();
    }
}

