/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ITopic;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.datepicker.DatePicker;
import org.xmind.ui.gantt2.viewer.DateInfoPickerViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeEditableTracker;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;

public class TaskTreeStartDateEditableTracker
extends TaskTreeEditableTracker {
    public TaskTreeStartDateEditableTracker(IFigure target, FigureCanvas canvas, TaskTreeItemPart host) {
        super(target, canvas, host);
    }

    protected void edit() {
        this.editStartDate();
    }

    private void editStartDate() {
        DateInfoPickerViewer startDatePicker = this.createStartDatePicker((Composite)this.canvas);
        final Control control = startDatePicker.getControl();
        this.locateEditor(control, this.target, this.canvas.getViewport());
        this.setActiveEditor(control);
        final DatePicker datePicker = startDatePicker.getDatePicker();
        Control datePickerControl = datePicker.getControl();
        datePickerControl.forceFocus();
        datePicker.open();
        startDatePicker.refresh();
        datePicker.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!datePicker.getControl().isDisposed()) {
                    datePicker.close();
                }
            }
        });
        datePicker.getDatePicker().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TaskTreeStartDateEditableTracker.this.preCancelEditing();
                e.display.timerExec(200, new Runnable(){

                    public void run() {
                        if (control != null && !control.isDisposed()) {
                            control.dispose();
                        }
                    }
                });
            }
        });
    }

    private DateInfoPickerViewer createStartDatePicker(Composite parent) {
        final DateInfoPickerViewer startDatePicker = new DateInfoPickerViewer(parent);
        startDatePicker.setInvalidColor(invalidColor);
        startDatePicker.setValidColor(validColor);
        DateInfo startDate = TaskInfoUtils.calculateStartDateInfo((ITopic)this.topic);
        startDatePicker.setDate(startDate);
        startDatePicker.setEnabled(this.topic != null);
        startDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TaskTreeStartDateEditableTracker.this.changeStartDate((DateInfo)((IStructuredSelection)event.getSelection()).getFirstElement());
                TaskTreeStartDateEditableTracker.this.preCancelEditing();
                startDatePicker.refresh();
            }
        });
        return startDatePicker;
    }

    private void changeStartDate(DateInfo date) {
        if (date == null) {
            TaskInfoUtils.changeEndDate((ITopic)this.topic, (ICommandStack)this.getCommandStack(), (DateInfo)date);
        }
        TaskInfoUtils.changeStartDate((ITopic)this.topic, (ICommandStack)this.getCommandStack(), (DateInfo)date);
    }
}

