/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.datepicker;

import java.util.Calendar;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.datepicker.CalendarAnimation;
import org.xmind.ui.datepicker.DayFigure;
import org.xmind.ui.datepicker.IAnimationAdvisor;

class NextMonthAnimation
extends CalendarAnimation {
    private int newRows = 0;

    public NextMonthAnimation(IAnimationAdvisor advisor) {
        super(advisor);
    }

    @Override
    protected void oldDayInNewMonth(DayFigure dayFigure, Calendar date, int month, int index) {
        this.newDays.add(dayFigure);
        if (date.get(5) == 1) {
            this.newRows = index / 7;
        }
    }

    @Override
    protected void createNewDays() {
        List oldDayFigures = this.advisor.getPanel().getChildren();
        Calendar date = ((DayFigure)((Object)oldDayFigures.get(oldDayFigures.size() - 1))).getDate();
        int r = 0;
        while (r < this.newRows) {
            int i = 0;
            while (i < 7) {
                date = (Calendar)date.clone();
                date.add(5, 1);
                DayFigure dayFigure = new DayFigure();
                dayFigure.setDate(date);
                this.advisor.initNewDay(dayFigure);
                this.newPanel.add((IFigure)dayFigure);
                if (date.get(2) == this.advisor.getNewMonth()) {
                    this.newDays.add(dayFigure);
                }
                ++i;
            }
            ++r;
        }
    }

    @Override
    protected Rectangle createOldInitConstraint() {
        int oldRows = 6;
        Rectangle constraint = new Rectangle();
        constraint.width = this.oldSize.width;
        constraint.height = this.oldSize.height * (oldRows + this.newRows) / oldRows;
        return constraint;
    }

    @Override
    protected Rectangle createOldFinalConstraint() {
        return new Rectangle(0, this.oldSize.height - this.oldInitConstraint.height, this.oldInitConstraint.width, this.oldInitConstraint.height);
    }

    @Override
    protected void removeOldDays() {
        IFigure oldPanel = this.advisor.getPanel();
        while (oldPanel.getChildren().size() > 42) {
            oldPanel.remove((IFigure)oldPanel.getChildren().get(0));
        }
    }

    @Override
    protected void updateJobs() {
        this.advisor.addMonthsToRoll(-1);
    }
}

