/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.status.IStatusListener;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.gef.tool.ITool;

public class TraverseTool
extends GraphicalTool
implements ISourceTool,
IStatusListener {
    private IGraphicalEditPart source;
    private IPart lastSource = null;
    private IPart lastTarget = null;
    private IPart[] traversables = null;
    private int currentIndex = -1;
    private boolean smartMode = false;
    private boolean oldSourceSelected = false;
    private boolean oldSourceFocused = false;
    private boolean oldSourcePreselected = false;

    public String getType() {
        return "traverse tool";
    }

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        Assert.isTrue((this.getSource() != null ? 1 : 0) != 0);
        this.getTargetViewer().setSelection((ISelection)new StructuredSelection((Object)this.getSource()), true);
        this.start();
    }

    protected void start() {
        Request request = new Request("get_traversables");
        request.setPrimaryTarget(this.getSource());
        request.setDomain(this.getDomain());
        request.setViewer(this.getTargetViewer());
        this.getSource().handleRequest(request, "traversable role");
        Object result = request.getResult("traverseResult");
        if (result != null && result instanceof IPart[] && ((IPart[])result).length > 0) {
            this.traversables = (IPart[])result;
            if (this.traversables.length == 0) {
                this.cancel();
            } else if (this.traversables.length == 1) {
                this.traverseTo(this.traversables[0]);
            } else {
                if (this.getStatus().isStatus(14)) {
                    this.getStatus().addStatusListener(this);
                    this.smartMode = true;
                } else {
                    this.smartMode = false;
                }
                this.showFeedback();
            }
        } else {
            this.finish();
        }
    }

    protected void handleSingleRequest(Request request) {
        String reqType = request.getType();
        if ("traverse".equals(reqType)) {
            this.assistTraverseNext();
        } else if ("finish".equals(reqType)) {
            if (this.traversables != null && this.currentIndex >= 0) {
                this.traverseTo(this.traversables[this.currentIndex]);
            } else {
                this.cancel();
            }
        } else if ("cancel".equals(reqType)) {
            this.cancel();
        } else {
            if (this.traversables != null && this.currentIndex >= 0) {
                this.traverseTo(this.traversables[this.currentIndex]);
            } else {
                this.cancel();
            }
            this.getDomain().handleRequest(request);
        }
    }

    private void showFeedback() {
        this.showSourceFeedback(this.getSource());
        IPart[] iPartArray = this.traversables;
        int n = this.traversables.length;
        int n2 = 0;
        while (n2 < n) {
            IPart p = iPartArray[n2];
            this.showAssistFeedback(p);
            ++n2;
        }
        int lastIndex = this.findLastSource();
        this.lastSource = null;
        this.lastTarget = null;
        this.currentIndex = lastIndex >= 0 ? lastIndex : 0;
        this.showTargetFeedback(this.traversables[this.currentIndex]);
    }

    private int findLastSource() {
        if (this.getSource() == this.lastTarget && this.lastSource != null) {
            int i = 0;
            while (i < this.traversables.length) {
                if (this.traversables[i] == this.lastSource) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void showSourceFeedback(IGraphicalEditPart source) {
        this.oldSourceSelected = source.getStatus().isSelected();
        this.oldSourceFocused = source.getStatus().isFocused();
        this.oldSourcePreselected = source.getStatus().isPreSelected();
        source.getStatus().deSelect();
        source.getStatus().dePreSelect();
        source.getStatus().lostFocus();
    }

    protected void hideSourceFeedback(IGraphicalEditPart source) {
        if (this.oldSourceSelected) {
            source.getStatus().select();
        } else {
            source.getStatus().deSelect();
        }
        if (this.oldSourceFocused) {
            source.getStatus().setFocus();
        } else {
            source.getStatus().lostFocus();
        }
        if (this.oldSourcePreselected) {
            source.getStatus().preSelect();
        } else {
            source.getStatus().dePreSelect();
        }
    }

    protected void showAssistFeedback(IPart part) {
        part.getStatus().preSelect();
    }

    protected void hideAssistFeedback(IPart part) {
        part.getStatus().dePreSelect();
    }

    protected void showTargetFeedback(IPart part) {
        part.getStatus().select();
    }

    protected void hideTargetFeedback(IPart part) {
        part.getStatus().deSelect();
    }

    private void assistTraverseNext() {
        if (this.currentIndex >= 0) {
            this.hideTargetFeedback(this.traversables[this.currentIndex]);
        }
        ++this.currentIndex;
        if (this.currentIndex >= this.traversables.length) {
            this.currentIndex = 0;
        }
        this.showTargetFeedback(this.traversables[this.currentIndex]);
    }

    protected void traverseTo(IPart target) {
        this.eraseFeedback();
        this.lastSource = this.getSource();
        this.lastTarget = target;
        this.getTargetViewer().setSelection((ISelection)new StructuredSelection((Object)target), true);
        this.finish();
    }

    protected void onDeactivated(ITool nextTool) {
        this.getStatus().removeStatusListener(this);
        super.onDeactivated(nextTool);
    }

    public IGraphicalEditPart getSource() {
        return this.source;
    }

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((source == null || source.getStatus().isActive() ? 1 : 0) != 0);
        Assert.isTrue((source == null || source.hasRole("traversable role") ? 1 : 0) != 0);
        this.source = source;
    }

    public void statusChanged(StatusEvent event) {
        if (this.smartMode && (event.key & 0xE) != 0) {
            if (this.currentIndex >= 0) {
                this.traverseTo(this.traversables[this.currentIndex]);
            } else {
                this.cancel();
            }
        }
    }

    protected void eraseFeedback() {
        if (this.traversables != null) {
            IPart[] iPartArray = this.traversables;
            int n = this.traversables.length;
            int n2 = 0;
            while (n2 < n) {
                IPart p = iPartArray[n2];
                this.hideAssistFeedback(p);
                this.hideTargetFeedback(p);
                ++n2;
            }
            this.traversables = null;
        }
        this.currentIndex = -1;
        this.hideSourceFeedback(this.getSource());
    }

    protected void finish() {
        this.setSource(null);
        this.changeActiveTool("default tool");
    }

    protected void cancel() {
        this.eraseFeedback();
        this.finish();
    }
}

