/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.internal;

import org.xmind.core.audio.AudioValues;
import org.xmind.core.audio.IAudioChannel;
import org.xmind.core.audio.IAudioDevice;
import org.xmind.core.audio.IAudioProcessListener;
import org.xmind.core.audio.ICoreAudioClient;
import org.xmind.core.audio.internal.CoreAudioService;

public class CoreAudioSession
implements IAudioProcessListener {
    private String id;
    private CoreAudioService service;
    private IAudioDevice device;
    private ICoreAudioClient client;
    private IAudioChannel channel;

    public CoreAudioSession(String id, CoreAudioService service, ICoreAudioClient client, IAudioDevice device) {
        this.id = id;
        this.service = service;
        this.client = client;
        this.device = device;
    }

    void start() throws Exception {
        this.channel = this.device.openChannel(this.client.getSource(), this.client.getTarget());
        this.channel.addAudioProcessListener(this);
    }

    void stop() throws Exception {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }

    boolean isActive() {
        return this.channel != null && this.channel.isOpen();
    }

    public String getId() {
        return this.id;
    }

    public CoreAudioService getService() {
        return this.service;
    }

    public IAudioDevice getDevice() {
        return this.device;
    }

    public ICoreAudioClient getClient() {
        return this.client;
    }

    public IAudioChannel getChannel() {
        return this.channel;
    }

    public void audioProcessStopped(IAudioChannel channel) {
        this.service.removeSession(this);
        this.client.notifyStopped(this.id);
    }

    public void audioProcessValueChanged(IAudioChannel channel, AudioValues values) {
        this.client.notifyValueChanged(this.id, values);
    }
}

