/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.transfer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.command.Command;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.IReturnValueConsumer;
import org.xmind.core.command.ReturnValue;
import org.xmind.core.command.arguments.Attributes;
import org.xmind.core.command.binary.IBinaryStore;
import org.xmind.core.command.transfer.ChunkReader;
import org.xmind.core.command.transfer.ChunkWriter;
import org.xmind.core.command.transfer.CommandTransferUtil;
import org.xmind.core.internal.command.remote.Messages;
import org.xmind.core.internal.command.remote.RemoteCommandPlugin;

public class OutgoingCommandHandler {
    private static final String DEBUG_OPTION = "/debug/outgoingCommandHandler";
    private static boolean DEBUGGING = RemoteCommandPlugin.getDefault().isDebugging("/debug/outgoingCommandHandler");
    private Object remoteLocation = "(unknown location)";
    private String pluginId = "org.xmind.core.command.remote";

    public void setRemoteLocation(Object location) {
        if (location == null) {
            location = "(unknown location)";
        }
        this.remoteLocation = location;
    }

    public Object getRemoteLocation() {
        return this.remoteLocation;
    }

    public void setPluginId(String pluginId) {
        if (pluginId == null) {
            pluginId = "org.xmind.core.command.remote";
        }
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public IStatus handleOutgoingCommand(IProgressMonitor monitor, ICommand command, IReturnValueConsumer returnValueConsumer, InputStream input, OutputStream output) {
        ChunkReader reader = new ChunkReader(input);
        try {
            IStatus iStatus;
            ChunkWriter writer = new ChunkWriter(output);
            try {
                iStatus = this.handleOutgoingCommand(monitor, command, returnValueConsumer, reader, writer);
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    RemoteCommandPlugin.log(null, e);
                }
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                RemoteCommandPlugin.log(null, e);
            }
            return iStatus;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                RemoteCommandPlugin.log(null, e);
            }
        }
    }

    public IStatus handleOutgoingCommand(IProgressMonitor monitor, ICommand command, IReturnValueConsumer returnValueConsumer, ChunkReader reader, ChunkWriter writer) {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.OutgoingCommandHandler_ExcuteCommand);
        SubProgressMonitor executeMonitor = new SubProgressMonitor(monitor, 90);
        IStatus returnValue = this.executeCommandRemotely((IProgressMonitor)executeMonitor, command, reader, writer);
        if (!executeMonitor.isCanceled()) {
            executeMonitor.done();
        }
        try {
            monitor.subTask(Messages.OutgoingCommandHandler_ConsumeReturnValue);
            SubProgressMonitor consumeMonitor = new SubProgressMonitor(monitor, 10);
            this.consumeCommand((IProgressMonitor)consumeMonitor, command, returnValue, returnValueConsumer);
            if (!consumeMonitor.isCanceled()) {
                consumeMonitor.done();
            }
            if (!monitor.isCanceled()) {
                monitor.done();
            }
            IStatus iStatus = returnValue;
            return iStatus;
        }
        finally {
            Object value;
            if (returnValue != null && returnValue instanceof ReturnValue && (value = ((ReturnValue)returnValue).getValue()) instanceof IBinaryStore) {
                ((IBinaryStore)value).clear();
            }
        }
    }

    private IStatus executeCommandRemotely(IProgressMonitor monitor, ICommand command, ChunkReader reader, ChunkWriter writer) {
        IStatus returnValue;
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.OutgoingCommandHandler_SendCommand);
        SubProgressMonitor sendMonitor = new SubProgressMonitor(monitor, 30);
        try {
            this.sendCommand((IProgressMonitor)sendMonitor, command, writer);
        }
        catch (Throwable e) {
            return this.createSendingErrorStatus(e);
        }
        if (sendMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        sendMonitor.done();
        monitor.subTask(Messages.OutgoingCommandHandler_ReceiveReturnValue);
        SubProgressMonitor receiveMonitor = new SubProgressMonitor(monitor, 70);
        try {
            returnValue = this.receive((IProgressMonitor)receiveMonitor, reader);
        }
        catch (Throwable e) {
            returnValue = this.createReceivingErrorStatus(e);
        }
        if (!receiveMonitor.isCanceled()) {
            receiveMonitor.done();
        }
        if (!monitor.isCanceled()) {
            monitor.done();
        }
        return returnValue;
    }

    private void sendCommand(IProgressMonitor monitor, ICommand command, ChunkWriter writer) throws IOException {
        monitor.beginTask(null, 100);
        if (DEBUGGING) {
            System.out.println("Sending command to " + this.remoteLocation + ": " + command);
        }
        long start = System.currentTimeMillis();
        String uri = Command.toURI((ICommand)command);
        writer.writeText(uri);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(40);
        IBinaryStore files = command.getBinaryStore();
        if (files != null && !files.isEmpty()) {
            writer.writeText("[FILES]");
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(10);
            SubProgressMonitor filesMonitor = new SubProgressMonitor(monitor, 40);
            CommandTransferUtil.writeFiles((IProgressMonitor)filesMonitor, files, writer);
            if (monitor.isCanceled()) {
                return;
            }
            filesMonitor.done();
        } else {
            monitor.worked(50);
        }
        writer.writeText("");
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(10);
        writer.flush();
        if (monitor.isCanceled()) {
            return;
        }
        monitor.done();
        long end = System.currentTimeMillis();
        if (DEBUGGING) {
            System.out.println("Command sent to " + this.remoteLocation + " (" + (end - start) + " ms): " + command);
        }
    }

    private IStatus receive(IProgressMonitor monitor, ChunkReader reader) throws IOException {
        Status returnValue;
        int code;
        int severity;
        monitor.beginTask(null, 100);
        if (DEBUGGING) {
            System.out.println("Receiving return value from " + this.remoteLocation);
        }
        long start = System.currentTimeMillis();
        String status = reader.readText();
        if (status == null) {
            return null;
        }
        try {
            severity = Integer.parseInt(status, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return new Status(4, this.getPluginId(), NLS.bind((String)Messages.OutgoingCommandHandler_InvalidReturnValueStatus, (Object)status));
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(15);
        String pluginId = reader.readText();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(15);
        String codeStr = reader.readText();
        if (codeStr != null && !"".equals(codeStr)) {
            try {
                code = Integer.parseInt(codeStr, 10);
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, this.getPluginId(), NLS.bind((String)Messages.OutgoingCommandHandler_InvalidReturnValueCode, (Object)codeStr));
            }
        } else {
            code = 0;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(15);
        String message = reader.readText();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(15);
        String responseType = reader.readText();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(15);
        if ("[PROPERTIES]".equals(responseType)) {
            String value;
            String name;
            Attributes attrs = new Attributes();
            while ((name = reader.readText()) != null && (value = reader.readText()) != null) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if ("".equals(name) || "".equals(value)) break;
                attrs.with(CommandTransferUtil.decode(name), CommandTransferUtil.decode(value));
            }
            returnValue = new ReturnValue(severity, pluginId, code, message, attrs);
        } else if ("[VALUES]".equals(responseType)) {
            String value;
            ArrayList<String> values = new ArrayList<String>();
            while ((value = reader.readText()) != null) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if ("".equals(value)) break;
                values.add(CommandTransferUtil.decode(value));
            }
            returnValue = new ReturnValue(severity, pluginId, code, message, values.toArray(new String[values.size()]));
        } else if ("[FILES]".equals(responseType)) {
            SubProgressMonitor filesMonitor = new SubProgressMonitor(monitor, 20);
            IBinaryStore files = CommandTransferUtil.readFiles((IProgressMonitor)filesMonitor, reader);
            if (filesMonitor.isCanceled()) {
                if (files != null) {
                    files.clear();
                }
                return Status.CANCEL_STATUS;
            }
            filesMonitor.done();
            returnValue = new ReturnValue(severity, pluginId, code, message, files);
        } else {
            returnValue = new Status(severity, pluginId, code, message, null);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        long end = System.currentTimeMillis();
        if (DEBUGGING) {
            System.out.println("Return value received from " + this.remoteLocation + " (" + (end - start) + " ms): " + returnValue);
        }
        return returnValue;
    }

    private void consumeCommand(IProgressMonitor monitor, ICommand command, IStatus returnValue, IReturnValueConsumer returnValueConsumer) {
        if (returnValueConsumer != null) {
            try {
                IStatus consumed = returnValueConsumer.consumeReturnValue(monitor, returnValue);
                if (!monitor.isCanceled() && consumed != null && !consumed.isOK() && consumed.getSeverity() != 8) {
                    RemoteCommandPlugin.log(consumed);
                }
            }
            catch (Throwable e) {
                RemoteCommandPlugin.log("Error occurred while consuming return value.", e);
            }
        }
    }

    protected IStatus createSendingErrorStatus(Throwable e) {
        return new Status(4, this.getPluginId(), null, e);
    }

    protected IStatus createReceivingErrorStatus(Throwable e) {
        if (e instanceof EOFException) {
            return new Status(2, this.getPluginId(), Messages.OutgoingCommandHandler_ConnectionClose, e);
        }
        return new Status(4, this.getPluginId(), null, e);
    }
}

