/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.draw2d.Layer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.dialogs.WallpaperDialog;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.internal.properties.Utils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.viewers.MButton;
import org.xmind.ui.viewers.SWTUtils;
import org.xmind.ui.viewers.SliderViewer;

public class WallpaperPropertySectionPart
extends StyledPropertySectionPart {
    private MButton selectWallpaperWidget;
    private WallpaperDialog selectWallpaperDialog;
    private IAction removeWallpaperAction;
    private Composite opacityGroup;
    private Text opacityInput;
    private SliderViewer opacityScale;
    private Image selectWallpaperImage;
    private Image opacityImage;

    @Override
    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout1 = new GridLayout(2, false);
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        layout1.horizontalSpacing = 3;
        line1.setLayout((Layout)layout1);
        this.createLineContent1(line1);
        this.opacityGroup = new Composite(parent, 0);
        this.opacityGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout2 = new GridLayout(4, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 3;
        this.opacityGroup.setLayout((Layout)layout2);
        this.createLineContent2(this.opacityGroup);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WallpaperPropertySectionPart.this.releaseImages();
            }
        });
    }

    private void createLineContent1(Composite parent) {
        this.selectWallpaperWidget = new MButton(parent, 0);
        this.selectWallpaperWidget.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.selectWallpaperWidget.setImage(this.getSelectWallpaperImage());
        this.selectWallpaperWidget.setText(PropertyMessages.SelectWallpaper_text);
        this.selectWallpaperWidget.getControl().setToolTipText(PropertyMessages.SelectWallpaper_toolTip);
        this.selectWallpaperWidget.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                WallpaperPropertySectionPart.this.openSelectWallpaperDialog();
            }
        });
        this.removeWallpaperAction = new RemoveWallpaperAction();
        ToolBarManager removeWallpaperBar = new ToolBarManager(0x800000);
        removeWallpaperBar.add(this.removeWallpaperAction);
        removeWallpaperBar.createControl(parent);
        removeWallpaperBar.getControl().setLayoutData((Object)new GridData(3, 2, false, false));
    }

    private void createLineContent2(Composite parent) {
        Label opacityLabel = new Label(parent, 0);
        opacityLabel.setImage(this.getOpacityImage());
        opacityLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.opacityInput = new Text(parent, 133124);
        SWTUtils.makeNumeralInput((Control)opacityLabel, (boolean)false, (boolean)false);
        GridData inputData = new GridData(4, 2, false, false);
        inputData.widthHint = 25;
        this.opacityInput.setLayoutData((Object)inputData);
        this.opacityInput.setTextLimit(3);
        this.opacityInput.setToolTipText(PropertyMessages.WallpaperOpacity_toolTip);
        Listener inputEventHandler = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 14) {
                    int value = WallpaperPropertySectionPart.this.getOpacityValueFromTextWidget();
                    if (value >= 0) {
                        WallpaperPropertySectionPart.this.changeOpacity(value);
                        WallpaperPropertySectionPart.this.selectAllOpacityText(false);
                    }
                } else if (event.type == 1) {
                    if (event.character == '\u001b') {
                        WallpaperPropertySectionPart.this.updateOpacityToWidget();
                    }
                } else if (event.type == 15) {
                    WallpaperPropertySectionPart.this.selectAllOpacityText(false);
                }
            }
        };
        this.opacityInput.addListener(14, inputEventHandler);
        this.opacityInput.addListener(1, inputEventHandler);
        this.opacityInput.addListener(15, inputEventHandler);
        Label percentageLabel = new Label(parent, 0);
        percentageLabel.setText("%");
        percentageLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.opacityScale = new SliderViewer(parent, 256);
        this.opacityScale.setLabelProvider((IBaseLabelProvider)new OpacityLabelProvider());
        this.opacityScale.getControl().setLayoutData((Object)new GridData(4, 2, true, false));
        this.opacityScale.getControl().setBackground(parent.getBackground());
        this.opacityScale.addSelectionChangedListener((ISelectionChangedListener)new OpacitySelectionChangedListener());
        this.opacityScale.addPostSelectionChangedListener((ISelectionChangedListener)new OpacityPostSelectionChangedListener());
    }

    private void selectAllOpacityText(final boolean takeFocus) {
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            this.opacityInput.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WallpaperPropertySectionPart.this.opacityInput != null && !WallpaperPropertySectionPart.this.opacityInput.isDisposed()) {
                        if (takeFocus) {
                            WallpaperPropertySectionPart.this.opacityInput.setFocus();
                        }
                        WallpaperPropertySectionPart.this.opacityInput.selectAll();
                    }
                }
            });
        }
    }

    private int getOpacityValueFromTextWidget() {
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            try {
                return Math.min(100, Integer.parseInt(this.opacityInput.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    private int getOpacityValueFromScaleSelection(ISelection selection) {
        Object o = ((IStructuredSelection)selection).getFirstElement();
        return this.getOpacityValueFromScaleElement(o);
    }

    private int getOpacityValueFromScaleElement(Object o) {
        if (o instanceof Double) {
            double value = (Double)o;
            return (int)Math.round(value * 100.0);
        }
        return -1;
    }

    private Image getSelectWallpaperImage() {
        ImageDescriptor icon;
        if ((this.selectWallpaperImage == null || this.selectWallpaperImage.isDisposed()) && (icon = MindMapUI.getImages().get("insertimage.png", true)) != null) {
            this.selectWallpaperImage = icon.createImage(false);
        }
        return this.selectWallpaperImage;
    }

    private Image getOpacityImage() {
        ImageDescriptor icon;
        if (this.opacityImage == null && (icon = MindMapUI.getImages().get("icons/prop/opaque.gif")) != null) {
            this.opacityImage = icon.createImage(false);
        }
        return this.opacityImage;
    }

    private void releaseImages() {
        if (this.selectWallpaperImage != null) {
            this.selectWallpaperImage.dispose();
            this.selectWallpaperImage = null;
        }
        if (this.opacityImage != null) {
            this.opacityImage.dispose();
            this.opacityImage = null;
        }
    }

    public void setFocus() {
        if (this.selectWallpaperWidget != null && !this.selectWallpaperWidget.getControl().isDisposed()) {
            this.selectWallpaperWidget.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.selectWallpaperDialog = null;
        this.selectWallpaperWidget = null;
        this.removeWallpaperAction = null;
        this.opacityGroup = null;
        this.opacityInput = null;
        this.opacityScale = null;
    }

    @Override
    protected void doRefresh() {
        boolean hasWallpaper;
        String value = this.getStyleValue("background", null);
        boolean bl = hasWallpaper = value != null;
        if (this.removeWallpaperAction != null) {
            this.removeWallpaperAction.setEnabled(hasWallpaper);
        }
        if (this.opacityGroup != null && !this.opacityGroup.isDisposed()) {
            Utils.setAllEnabled((Control)this.opacityGroup, hasWallpaper);
        }
        this.updateOpacityToWidget();
    }

    private void updateOpacityToWidget() {
        String value = this.getStyleValue("svg:opacity", null);
        double doubleValue = this.parseOpacityValue(value);
        doubleValue = Math.max(0.0, Math.min(1.0, doubleValue));
        if (this.opacityInput != null && !this.opacityInput.isDisposed()) {
            this.opacityInput.setText(String.valueOf((int)Math.round(doubleValue * 100.0)));
        }
        if (this.opacityScale != null && !this.opacityScale.getControl().isDisposed()) {
            this.opacityScale.setSelection((ISelection)new StructuredSelection((Object)doubleValue));
        }
    }

    private double parseOpacityValue(String value) {
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 1.0;
    }

    private void openSelectWallpaperDialog() {
        if (this.selectWallpaperWidget != null && this.selectWallpaperWidget.getControl() != null && !this.selectWallpaperWidget.getControl().isDisposed()) {
            if (this.selectWallpaperDialog == null) {
                Control handle = this.selectWallpaperWidget.getControl();
                this.selectWallpaperDialog = new WallpaperDialog(handle.getShell(), handle);
            }
            this.selectWallpaperDialog.setMindMapViewer(this.getActiveViewer());
            this.selectWallpaperDialog.open();
            Shell shell = this.selectWallpaperDialog.getShell();
            if (shell != null && !shell.isDisposed()) {
                this.selectWallpaperWidget.setForceFocus(true);
                shell.addListener(12, new Listener(){

                    public void handleEvent(Event event) {
                        if (WallpaperPropertySectionPart.this.selectWallpaperWidget != null && !WallpaperPropertySectionPart.this.selectWallpaperWidget.getControl().isDisposed()) {
                            WallpaperPropertySectionPart.this.selectWallpaperWidget.setForceFocus(false);
                        }
                    }
                });
            }
        }
    }

    private void removeWallpaper() {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyWallpaper);
        this.addStyle(request, "background", "");
        this.sendRequest(request);
    }

    private void changeOpacity(int opacityValue) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyWallpaperOpacity);
        String value = String.valueOf((double)opacityValue * 1.0 / 100.0);
        this.addStyle(request, "svg:opacity", value);
        this.sendRequest(request);
    }

    private void previewOpacity(int value) {
        Layer layer;
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null && (layer = viewer.getLayer(GEF.LAYER_BACKGROUND)) != null && layer instanceof IUseTransparency) {
            int alpha = value * 255 / 100;
            ((IUseTransparency)layer).setSubAlpha(alpha);
        }
    }

    private class OpacityLabelProvider
    extends LabelProvider {
        private OpacityLabelProvider() {
        }

        public String getText(Object element) {
            int value = WallpaperPropertySectionPart.this.getOpacityValueFromScaleElement(element);
            if (value >= 0) {
                return NLS.bind((String)PropertyMessages.WallpaperOpacity_pattern, (Object)value);
            }
            return super.getText(element);
        }
    }

    private class OpacityPostSelectionChangedListener
    implements ISelectionChangedListener {
        private OpacityPostSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            int value = WallpaperPropertySectionPart.this.getOpacityValueFromScaleSelection(event.getSelection());
            if (value >= 0) {
                WallpaperPropertySectionPart.this.changeOpacity(value);
                WallpaperPropertySectionPart.this.selectAllOpacityText(true);
            }
        }
    }

    private class OpacitySelectionChangedListener
    implements ISelectionChangedListener {
        private OpacitySelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            int value = WallpaperPropertySectionPart.this.getOpacityValueFromScaleSelection(event.getSelection());
            if (value >= 0) {
                WallpaperPropertySectionPart.this.opacityInput.setText(String.valueOf(value));
                WallpaperPropertySectionPart.this.previewOpacity(value);
            }
        }
    }

    private class RemoveWallpaperAction
    extends Action {
        public RemoveWallpaperAction() {
            super(null, 1);
            this.setImageDescriptor(MindMapUI.getImages().get("trash.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("trash.png", false));
            this.setToolTipText(PropertyMessages.RemoveWallpaper_toolTip);
        }

        public void run() {
            WallpaperPropertySectionPart.this.removeWallpaper();
        }
    }
}

