/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.prefs;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.prefs.PrefMessages;

public class ThemeApplyPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore pref = MindMapUIPlugin.getDefault().getPreferenceStore();
    private Button override;
    private Button keep;
    private Button ask;

    public ThemeApplyPrefPage() {
        super(PrefMessages.ThemePrefPage_title);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite group = this.createGroup(parent);
        this.override = new Button(group, 16);
        this.override.setText(PrefMessages.ThemePrefPage_OverrideButton);
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        this.override.setLayoutData((Object)data);
        this.keep = new Button(group, 16);
        this.keep.setText(PrefMessages.ThemePrefPage_KeepButton);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        this.keep.setLayoutData((Object)data);
        this.ask = new Button(group, 16);
        this.ask.setText(PrefMessages.ThemePrefPage_AskButton);
        data = new GridData(4, 0, true, true);
        data.horizontalSpan = 3;
        this.ask.setLayoutData((Object)data);
        this.updateStatus();
        return parent;
    }

    private void updateStatus() {
        String themeOverride = this.pref.getString("Theme_Apply");
        this.override.setSelection("THEME_OVERRIDE".equals(themeOverride));
        this.keep.setSelection("THEME_KEEP".equals(themeOverride));
        this.ask.setSelection("ASK_USER".equals(themeOverride) || "".equals(themeOverride));
    }

    private Composite createGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)gridLayout);
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(PrefMessages.ThemePrefPage_Group_text);
        return group;
    }

    protected void performDefaults() {
        this.override.setSelection(false);
        this.keep.setSelection(false);
        this.ask.setSelection(true);
        this.pref.setValue("Theme_Apply", "ASK_USER");
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.override.getSelection()) {
            this.pref.setValue("Theme_Apply", "THEME_OVERRIDE");
        } else if (this.keep.getSelection()) {
            this.pref.setValue("Theme_Apply", "THEME_KEEP");
        } else if (this.ask.getSelection()) {
            this.pref.setValue("Theme_Apply", "ASK_USER");
        }
        this.updateStatus();
        return true;
    }
}

