/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.ui.branch.IBranchStructure;
import org.xmind.ui.internal.branch.DefaultStructureDescriptor;
import org.xmind.ui.internal.branch.IStructureDescriptor;
import org.xmind.ui.util.Logger;

class StructureDescriptor
implements IStructureDescriptor {
    private IConfigurationElement element;
    private String id;
    private String name;
    private ImageDescriptor icon;
    private IBranchStructure structure;

    public StructureDescriptor(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name");
        if (RegistryReader.getClassValue((IConfigurationElement)element, (String)"class") == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            this.icon = this.createIcon();
        }
        return this.icon;
    }

    private ImageDescriptor createIcon() {
        String iconName = this.element.getAttribute("icon");
        if (iconName != null) {
            String plugId = this.element.getNamespaceIdentifier();
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)plugId, (String)iconName);
        }
        return null;
    }

    @Override
    public IBranchStructure getAlgorithm() {
        if (this.structure == null) {
            try {
                this.structure = (IBranchStructure)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.log(e, "Failed to create structure: " + this.id);
                this.structure = DefaultStructureDescriptor.getInstance().getAlgorithm();
            }
        }
        return this.structure;
    }
}

