/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.internal.layers.BaseLayer;
import org.xmind.ui.internal.presentation.Button;
import org.xmind.ui.internal.presentation.ControlPanel;
import org.xmind.ui.internal.presentation.ControlPanelFactory;
import org.xmind.ui.internal.presentation.Presentation;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.PresentationViewer;
import org.xmind.ui.internal.presentation.Slider;

public class PresentationMenuService
extends GraphicalViewerService {
    private static final String PATH = "/icons/panel/";
    private static final String IMAGE_SUFFIX = ".png";
    private static final String DAY = "day-";
    private static final String NIGHT = "night-";
    private static final String NORMAL_STATE = "-normal";
    private static final String HOVER_STATE = "-hover";
    private static final String HOVER_PANEL_STATE = "-hover-panel";
    private static final String GO_INTO = "into";
    private static final String GO_NEXT = "next";
    private static final String LIGHT = "light";
    private static final String SIDEBAR = "sidebar";
    private static final String QUIT = "quit";
    private static final String ZOOM_BUTTON = "zoom-button";
    private static final String SLIDER_WAY = "zoom";
    private static final String CONTROL_PANEL = "panel";
    private ControlPanel controlPanel;
    private SizeableImageFigure goNextFigure;
    private SizeableImageFigure goIntoFigure;
    private SizeableImageFigure lightFigure;
    private SizeableImageFigure sidebarFigure;
    private SizeableImageFigure quitFigure;
    private Button zoomFigure;
    private Button sliderWay;
    private Slider slider;
    private IFigure mouseTarget = null;
    private Map<String, Image> menuImages = null;
    private boolean hovered = false;
    private String hoveredFigure = null;
    private Button currentTargetButton = null;
    private Button sourceButton = null;
    private boolean modifyingZoom = false;
    private boolean isDayMode;

    public PresentationMenuService(IGraphicalViewer viewer) {
        super(viewer);
    }

    protected void activate() {
        Layer layer = this.getViewer().getLayer(PresentationViewer.LAYER_MENU);
        if (layer == null) {
            this.getViewer().getLayerManager().insertLayer(PresentationViewer.LAYER_MENU, (Layer)new BaseLayer(), null, false);
            layer = this.getViewer().getLayer(PresentationViewer.LAYER_MENU);
        }
        if (layer != null) {
            this.controlPanel = ControlPanelFactory.getInstance().createControlPanel();
            this.goNextFigure = this.controlPanel.getButton(0);
            this.goIntoFigure = this.controlPanel.getButton(1);
            this.lightFigure = this.controlPanel.getButton(2);
            this.sidebarFigure = this.controlPanel.getButton(5);
            this.quitFigure = this.controlPanel.getButton(6);
            this.slider = this.controlPanel.getSlider(3);
            this.zoomFigure = this.controlPanel.getButton(3);
            this.sliderWay = this.slider.getSliderWay();
            layer.add((IFigure)this.controlPanel);
        }
        ((PresentationViewer)this.getViewer()).refresh();
        ZoomManager zm = this.getViewer().getZoomManager();
        this.scaleChanged((ZoomObject)zm, 0.0, zm.getScale());
        this.isDayMode = this.getDayMode();
    }

    private Image getImage(String name) {
        Image image;
        String mode = this.isDayMode ? DAY : NIGHT;
        String imageName = String.valueOf(mode) + name;
        imageName = CONTROL_PANEL.equals(name) ? String.valueOf(imageName) + (this.hovered ? HOVER_STATE : NORMAL_STATE) : (ZOOM_BUTTON.equals(name) ? (this.hovered && !SLIDER_WAY.equals(this.hoveredFigure) ? String.valueOf(imageName) + HOVER_PANEL_STATE : (this.hovered && SLIDER_WAY.equals(this.hoveredFigure) ? String.valueOf(imageName) + HOVER_STATE : String.valueOf(imageName) + NORMAL_STATE)) : (this.hoveredFigure != null && this.hoveredFigure.equals(name) ? String.valueOf(imageName) + HOVER_STATE : String.valueOf(imageName) + NORMAL_STATE));
        imageName = String.valueOf(imageName) + IMAGE_SUFFIX;
        if (this.menuImages == null) {
            this.menuImages = new HashMap<String, Image>();
        }
        if ((image = this.menuImages.get(imageName)) == null && this.isActive()) {
            image = PresentationMenuService.getImageDescriptor(imageName).createImage();
            this.menuImages.put(imageName, image);
        }
        return image;
    }

    protected void deactivate() {
        if (this.controlPanel != null) {
            if (this.controlPanel.getParent() != null) {
                this.controlPanel.getParent().remove((IFigure)this.controlPanel);
            }
            this.controlPanel = null;
        }
        if (this.menuImages != null && !this.menuImages.isEmpty()) {
            for (Image image : this.menuImages.values()) {
                image.dispose();
            }
            this.menuImages = null;
        }
    }

    private void updateIcons() {
        if (this.controlPanel != null) {
            this.controlPanel.setImage(this.getImage(CONTROL_PANEL));
        }
        if (this.goNextFigure != null) {
            this.goNextFigure.setImage(this.getImage(GO_NEXT));
        }
        if (this.goIntoFigure != null) {
            this.goIntoFigure.setImage(this.getImage(GO_INTO));
        }
        if (this.lightFigure != null) {
            this.lightFigure.setImage(this.getImage(LIGHT));
        }
        if (this.sidebarFigure != null) {
            this.sidebarFigure.setImage(this.getImage(SIDEBAR));
        }
        if (this.quitFigure != null) {
            this.quitFigure.setImage(this.getImage(QUIT));
        }
        if (this.sliderWay != null) {
            this.sliderWay.setImage(this.getImage(SLIDER_WAY));
        }
        if (this.zoomFigure != null) {
            this.zoomFigure.setImage(this.getImage(ZOOM_BUTTON));
        }
    }

    public boolean handleMouseMove(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        IFigure oldTarget = this.mouseTarget;
        if (this.controlPanel != null && this.controlPanel.containsPoint(p)) {
            this.hovered = true;
            this.getViewer().setPreselected(null);
            Button bt = this.controlPanel.findButton(p);
            if (bt != null) {
                this.mouseTarget = bt;
                switch (bt.getId()) {
                    case 0: {
                        this.hoveredFigure = GO_NEXT;
                        break;
                    }
                    case 1: {
                        this.hoveredFigure = GO_INTO;
                        break;
                    }
                    case 2: {
                        this.hoveredFigure = LIGHT;
                        break;
                    }
                    case 5: {
                        this.hoveredFigure = SIDEBAR;
                        break;
                    }
                    case 6: {
                        this.hoveredFigure = QUIT;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.hoveredFigure = SLIDER_WAY;
                        break;
                    }
                    default: {
                        this.hoveredFigure = null;
                        break;
                    }
                }
            } else {
                this.mouseTarget = null;
                this.hoveredFigure = null;
            }
        } else {
            this.hovered = false;
            this.hoveredFigure = null;
            this.mouseTarget = null;
        }
        this.checkControlPanel(me);
        this.updateIcons();
        if (oldTarget != this.mouseTarget) {
            this.getViewer().updateToolTip();
        }
        return true;
    }

    public boolean handleMouseDown(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        this.sourceButton = this.controlPanel.findButton(p);
        if (this.goNextFigure != null && this.goNextFigure.containsPoint(p)) {
            this.performAction("org.xmind.ui.presentation.action.navSibling");
            return true;
        }
        if (this.goIntoFigure != null && this.goIntoFigure.containsPoint(p)) {
            this.performAction("org.xmind.ui.presentation.action.navChild");
            return true;
        }
        if (this.lightFigure != null && this.lightFigure.containsPoint(p)) {
            this.performAction("org.xmind.ui.presentation.action.light");
            this.isDayMode = this.getDayMode();
            this.updateIcons();
            ((PresentationViewer)this.getViewer()).refresh();
            return true;
        }
        if (this.sidebarFigure != null && this.sidebarFigure.containsPoint(p)) {
            this.performAction("org.xmind.ui.presentation.action.sideBar");
            return true;
        }
        if (this.quitFigure != null && this.quitFigure.containsPoint(p)) {
            this.performAction("org.xmind.ui.presentation.action.quit");
            return true;
        }
        if (this.slider != null && this.zoomFigure != null && this.zoomFigure.containsPoint(p)) {
            int id = this.slider.getId();
            this.controlPanel.setSliderValue(id, p);
            this.handleButtonDragged(id);
            return true;
        }
        return false;
    }

    public boolean handleMouseDrag(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        if (this.sourceButton != null) {
            int id = this.sourceButton.getId();
            if (this.controlPanel.getSlider(id) != null) {
                this.controlPanel.setSliderValue(id, p);
                this.handleButtonDragged(id);
            }
            return true;
        }
        return false;
    }

    public boolean handleMouseUp(MouseEvent me) {
        if (this.sourceButton != null) {
            this.sourceButton = null;
            return true;
        }
        return false;
    }

    private void handleButtonDragged(int id) {
        float value = this.controlPanel.getSliderValue(id);
        if (id == 3) {
            ZoomManager zm = this.getViewer().getZoomManager();
            double newScale = zm.getMin() + (zm.getMax() - zm.getMin()) * (double)value;
            this.modifyingZoom = true;
            this.getViewer().getEditDomain().handleRequest(new Request(SLIDER_WAY).setViewer((IViewer)this.getViewer()).setParameter("zoomScale", (Object)newScale));
            this.modifyingZoom = false;
        }
    }

    public boolean handleMouseDoubleClick(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        if (this.controlPanel.containsPoint(p)) {
            me.consume();
            return true;
        }
        return false;
    }

    public IFigure getToolTip(Point p) {
        Button bt;
        if (this.controlPanel != null && this.controlPanel.containsPoint(p) && (bt = this.controlPanel.findButton(p)) != null) {
            return bt.getToolTip();
        }
        return null;
    }

    private void performAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            action.run();
        }
    }

    private IAction getAction(String actionId) {
        IActionRegistry actionReg = (IActionRegistry)this.getViewer().getProperties().get("actions");
        if (actionReg != null) {
            return actionReg.getAction(actionId);
        }
        return null;
    }

    private void checkControlPanel(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        this.currentTargetButton = this.controlPanel == null ? null : this.controlPanel.findButton(p);
    }

    public Button getCurrentButton(Point p) {
        return this.currentTargetButton;
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        if (this.modifyingZoom) {
            return;
        }
        ZoomManager zm = (ZoomManager)source;
        this.setZoomSliderValue(zm, newValue);
    }

    private void setZoomSliderValue(ZoomManager zm, double newValue) {
        if (this.controlPanel == null) {
            return;
        }
        double value = (newValue - zm.getMin()) / (zm.getMax() - zm.getMin());
        this.controlPanel.setSliderValue(3, (float)value);
        Button button = this.controlPanel.getButton(3);
        if (button != null) {
            String percentage = String.format("%.0f%%", newValue * 100.0);
            button.setToolTip((IFigure)new Label(NLS.bind((String)PresentationMessages.Zoom_toolTip, (Object)percentage)));
        }
    }

    private boolean getDayMode() {
        return Boolean.TRUE.equals(this.getViewer().getProperties().get("org.xmind.ui.presentation.lightOnOff"));
    }

    private static ImageDescriptor getImageDescriptor(String name) {
        return Presentation.imageFrom(PATH + name);
    }
}

