/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.core.internal;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import net.xmind.core.IAccount;
import net.xmind.core.IAuthenticationListener;
import net.xmind.core.IAuthenticationListener2;
import net.xmind.core.ICredentialsBuilder;
import net.xmind.core.internal.API;
import net.xmind.core.internal.CredentialsBuilder;
import net.xmind.core.internal.InternalAccountManager;
import net.xmind.core.internal.UserCredentials;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.json.JSONObject;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.IDataStore;
import org.xmind.core.net.JSONStore;
import org.xmind.core.net.http.FormEntity;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.net.util.LinkUtils;

public class Account
implements IAccount {
    public static boolean DEBUG_ACCOUNT_OPERATIONS = false;
    public static boolean DEBUG_ACCOUNT_REQUESTS = false;
    public static boolean DEBUG_ACCOUNT_AUTHCHANGES = false;
    private InternalAccountManager manager = null;
    private JSONObject properties = new JSONObject();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ListenerList<IAuthenticationListener> authChangeSupport = new ListenerList();

    JSONObject toJSON() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProperties(JSONObject properties) {
        Object newValue;
        Object oldValue;
        String key;
        boolean isAuthenticated;
        JSONObject oldInfo;
        boolean wasAuthenticated;
        Account account = this;
        synchronized (account) {
            wasAuthenticated = this.isAuthenticated();
            oldInfo = this.properties;
            this.properties = properties;
            isAuthenticated = this.isAuthenticated();
            if (this.manager != null) {
                this.manager.save();
            }
        }
        HashSet<String> oldKeys = new HashSet<String>();
        Iterator keyIt = oldInfo.keys();
        while (keyIt.hasNext()) {
            key = (String)keyIt.next();
            oldValue = oldInfo.opt(key);
            if (!(oldValue == (newValue = properties.opt(key)) || oldValue != null && oldValue.equals(newValue))) {
                this.propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
            }
            oldKeys.add(key);
        }
        keyIt = properties.keys();
        while (keyIt.hasNext()) {
            key = (String)keyIt.next();
            if (oldKeys.contains(key) || (oldValue = oldInfo.opt(key)) == (newValue = properties.opt(key)) || oldValue != null && oldValue.equals(newValue)) continue;
            this.propertyChangeSupport.firePropertyChange(key, oldValue, newValue);
        }
        if (wasAuthenticated && !isAuthenticated) {
            this.fireUnauthenticated();
        } else if (!wasAuthenticated && isAuthenticated) {
            this.fireAuthenticated();
        }
    }

    void setManager(InternalAccountManager manager) {
        this.manager = manager;
    }

    @Override
    public synchronized boolean isAuthenticated() {
        return this.properties.has("user") && this.properties.has("token");
    }

    @Override
    public synchronized boolean isAuthenticationExpired() {
        return this.properties.has("user") && !this.properties.has("token");
    }

    @Override
    public synchronized boolean hasValidSubscription() {
        if (!this.properties.has("expireDate")) {
            return false;
        }
        if (this.properties.has("expired")) {
            return !this.properties.getBoolean("expired");
        }
        return this.properties.getLong("expireDate") > System.currentTimeMillis();
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.opt(key);
    }

    @Override
    public void addPropertyChangeListener(String key, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(key, listener);
    }

    @Override
    public void removePropertyChangeListener(String key, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(key, listener);
    }

    @Override
    public void addAuthenticationListener(IAuthenticationListener listener) {
        this.authChangeSupport.add((Object)listener);
    }

    @Override
    public void removeAuthenticationListener(IAuthenticationListener listener) {
        this.authChangeSupport.remove((Object)listener);
    }

    @Override
    public ICredentialsBuilder newCredentialsBuilder() {
        return new CredentialsBuilder();
    }

    @Override
    public boolean authenticate(IProgressMonitor monitor, Object credentials) throws InterruptedException, HttpException {
        if (credentials == null || !(credentials instanceof UserCredentials)) {
            throw new IllegalArgumentException("Incorrect user credentials type");
        }
        UserCredentials credentialsImpl = (UserCredentials)credentials;
        String userName = credentialsImpl.getUserName();
        String password = credentialsImpl.getPassword();
        if (userName == null || password == null) {
            throw new IllegalArgumentException("Insufficient user credentials, e.g. no user name or password");
        }
        if (DEBUG_ACCOUNT_OPERATIONS) {
            System.out.println("[XMindNetAccount] Signing in: " + userName);
        }
        FieldSet params = new FieldSet().add("user", (Object)userName);
        String pwd = Account.toPwd(password);
        if (pwd != null) {
            params.add("pwd", (Object)pwd);
        } else {
            params.add("password", (Object)password);
        }
        JSONObject data = null;
        String host = this.getAuthenticateHost();
        HttpRequest request = null;
        int code = -1;
        int timeoutRetryCount = 0;
        boolean timeoutRetry = false;
        do {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            FieldSet settings = new FieldSet();
            settings.add("connectTimeout", (Object)60000);
            settings.add("readTimeout", (Object)60000);
            timeoutRetry = false;
            request = new HttpRequest(true, host, -1, EncodingUtils.format((String)"/_res/token/%s", (Object[])new Object[]{userName}), null, null, "POST", null, (HttpEntity)new FormEntity(params), settings, null);
            if (DEBUG_ACCOUNT_REQUESTS) {
                request.debug(System.out);
            }
            try {
                request.execute((IProgressMonitor)subMonitor);
            }
            catch (HttpException e) {
                if (e.getCause() instanceof SocketTimeoutException && timeoutRetryCount < 1) {
                    timeoutRetry = true;
                    ++timeoutRetryCount;
                }
                throw e;
            }
            API.Result result = API.toResult(request);
            code = result.getCode();
            data = result.getData();
            host = this.getRetryHost(data, timeoutRetry, host);
        } while (this.shouldRetry(data, code, timeoutRetry));
        if (code != 200) {
            throw new HttpException(request, code, "Unexpected Error", null);
        }
        this.setProperties(data);
        return this.isAuthenticated();
    }

    private static String toPwd(String password) {
        byte[] bytes;
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        try {
            bytes = EncodingUtils.toDefaultBytes((String)password);
        }
        catch (AssertionError assertionError) {
            return null;
        }
        return String.valueOf(EncodingUtils.base64Encode((byte[])md5.digest(bytes)));
    }

    @Override
    public void unauthenticate(IProgressMonitor monitor) throws HttpException, InterruptedException {
        if (DEBUG_ACCOUNT_OPERATIONS) {
            System.out.println("[XMindNetAccount] Signing out: " + this.properties.optString("user"));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.preUnauthentication((IProgressMonitor)subMonitor.newChild(20));
        if (subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        JSONObject data = new JSONObject(this.properties.toString());
        if (!data.has("user") || !data.has("token")) {
            this.setProperties(new JSONObject());
            return;
        }
        String userName = data.getString("user");
        String token = data.getString("token");
        this.setProperties(new JSONObject());
        HttpRequest request = new HttpRequest(true, this.getOtherHost(), -1, EncodingUtils.format((String)"/_res/token/%s", (Object[])new Object[]{userName}), null, null, "DELETE", new FieldSet().add("AuthToken", (Object)token), null, null, null);
        if (DEBUG_ACCOUNT_REQUESTS) {
            request.debug(System.out);
        }
        request.execute((IProgressMonitor)subMonitor.newChild(80));
    }

    private void fireAuthenticated() {
        if (DEBUG_ACCOUNT_AUTHCHANGES) {
            System.out.println("[XMindNetAccount] Authenticated: " + this.properties.optString("user"));
        }
        final Account account = this;
        for (final IAuthenticationListener listener : this.authChangeSupport) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.onAuthenticated(account);
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    private void fireUnauthenticated() {
        if (DEBUG_ACCOUNT_AUTHCHANGES) {
            System.out.println("[XMindNetAccount] Unauthenticated.");
        }
        final Account account = this;
        for (final IAuthenticationListener listener : this.authChangeSupport) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.onUnauthenticated(account);
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    private void preUnauthentication(IProgressMonitor monitor) throws InterruptedException {
        int remaining = this.authChangeSupport.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)remaining);
        Account account = this;
        Object[] objectArray = this.authChangeSupport.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IAuthenticationListener2) {
                ((IAuthenticationListener2)listener).preUnauthenticate((IProgressMonitor)subMonitor.newChild(1), account);
            }
            --remaining;
            if (subMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            subMonitor.setWorkRemaining(remaining);
            ++n2;
        }
    }

    @Override
    public void update(IProgressMonitor monitor) throws HttpException, InterruptedException {
        JSONObject data;
        if (DEBUG_ACCOUNT_OPERATIONS) {
            System.out.println("[XMindNetAccount] Updating account info: " + this.properties.optString("user"));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        JSONObject oldData = new JSONObject(this.properties.toString());
        if (!oldData.has("user") || !oldData.has("token")) {
            return;
        }
        String userName = oldData.getString("user");
        String token = oldData.getString("token");
        HttpRequest request = new HttpRequest(true, this.getOtherHost(), -1, "/_res/session", null, null, "GET", new FieldSet().add("AuthToken", (Object)token), null, null, null);
        if (DEBUG_ACCOUNT_REQUESTS) {
            request.debug(System.out);
        }
        try {
            request.execute((IProgressMonitor)subMonitor);
            API.Result result = API.toCheckedResult(request);
            data = result.getData();
            data.put("token", (Object)token);
        }
        catch (HttpException e) {
            if (e.getCode() == 401) {
                data = new JSONObject().put("user", (Object)userName);
            }
            throw e;
        }
        if (subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.setProperties(data);
    }

    @Override
    public IDataStore get(IProgressMonitor monitor, String resource, FieldSet parameters) throws HttpException, InterruptedException {
        return this.execute(monitor, "GET", resource, parameters);
    }

    @Override
    public IDataStore put(IProgressMonitor monitor, String resource, FieldSet parameters) throws HttpException, InterruptedException {
        return this.execute(monitor, "PUT", resource, parameters);
    }

    @Override
    public IDataStore post(IProgressMonitor monitor, String resource, FieldSet parameters) throws HttpException, InterruptedException {
        return this.execute(monitor, "POST", resource, parameters);
    }

    @Override
    public IDataStore delete(IProgressMonitor monitor, String resource, FieldSet parameters) throws HttpException, InterruptedException {
        return this.execute(monitor, "DELETE", resource, parameters);
    }

    private IDataStore execute(IProgressMonitor monitor, String method, String resource, FieldSet parameters) throws HttpException, InterruptedException {
        FormEntity entity;
        FieldSet query;
        if (DEBUG_ACCOUNT_OPERATIONS) {
            System.out.println("[XMindNetAccount] Execute: " + method + " " + resource + " " + parameters.toString());
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if ("GET".equals(method)) {
            query = parameters;
            entity = null;
        } else {
            query = null;
            entity = parameters == null ? null : new FormEntity(parameters);
        }
        String userName = this.properties.optString("user", null);
        String token = this.properties.optString("token", null);
        HttpRequest request = new HttpRequest(true, this.getOtherHost(), -1, resource, query, null, method, new FieldSet().add("AuthToken", (Object)token), (HttpEntity)entity, null, null);
        if (userName == null || "".equals(userName) || token == null || "".equals(token)) {
            throw new HttpException(request, 401, "Unauthenticated", null);
        }
        if (DEBUG_ACCOUNT_REQUESTS) {
            request.debug(System.out);
        }
        try {
            request.execute((IProgressMonitor)subMonitor);
        }
        catch (HttpException e) {
            if (e.getCode() == 401) {
                this.setProperties(new JSONObject().put("user", (Object)userName));
            }
            throw e;
        }
        if (subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        API.Result result = API.toCheckedResult(request);
        return new JSONStore(result.getData());
    }

    private String getAuthenticateHost() {
        String cloudSite = (String)this.getProperty("cloud_site");
        if (cloudSite != null) {
            return LinkUtils.getHostByUser((boolean)"cn".equals(cloudSite), (boolean)false, (boolean)false);
        }
        return LinkUtils.getHostByLanguage((boolean)false, (boolean)false);
    }

    private String getOtherHost() {
        String cloudSite = (String)this.getProperty("cloud_site");
        if (cloudSite != null) {
            return LinkUtils.getHostByUser((boolean)"cn".equals(cloudSite), (boolean)false, (boolean)false);
        }
        return "www.xmind.net";
    }

    private boolean shouldRetry(JSONObject data, int code, boolean timeoutRetry) {
        return timeoutRetry || data != null && 404 == code && data.opt("retry") != null;
    }

    private String getRetryHost(JSONObject data, boolean timeoutRetry, String oldHost) {
        if (timeoutRetry) {
            return "www.xmind.cn".equals(oldHost) ? "www.xmind.net" : "www.xmind.cn";
        }
        if (data == null) {
            return "www.xmind.net";
        }
        String retry = (String)data.opt("retry");
        return "cn".equals(retry) ? "www.xmind.cn" : "www.xmind.net";
    }

    @Override
    public boolean isCnUser() {
        return "cn".equals((String)this.getProperty("cloud_site"));
    }
}

