/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.IOException;
import java.util.Arrays;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class HyperlinkRecord
extends Record {
    protected static final int HLINK_URL = 1;
    protected static final int HLINK_ABS = 2;
    protected static final int HLINK_LABEL = 20;
    protected static final int HLINK_PLACE = 8;
    protected static final byte[] STD_MONIKER = new byte[]{-48, -55, -22, 121, -7, -70, -50, 17, -116, -126, 0, -86, 0, 75, -87, 11};
    protected static final byte[] URL_MONIKER = new byte[]{-32, -55, -22, 121, -7, -70, -50, 17, -116, -126, 0, -86, 0, 75, -87, 11};
    protected static final byte[] FILE_MONIKER = new byte[]{3, 3, 0, 0, 0, 0, 0, 0, -64, 0, 0, 0, 0, 0, 0, 70};
    protected static final byte[] URL_TAIL = new byte[]{121, 88, -127, -12, 59, 29, 127, 72, -81, 44, -126, 93, -60, -123, 39, 99, 0, 0, 0, 0, -91, -85, 0, 0};
    protected static final byte[] FILE_TAIL = new byte[]{-1, -1, -83, -34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final short sid = 440;
    private int rwFirst;
    private int rwLast;
    private short colFirst;
    private short colLast;
    private byte[] guid;
    private int label_opts;
    private short file_opts;
    private int link_opts;
    private String label;
    private byte[] moniker;
    private String address;
    private byte[] tail;

    public HyperlinkRecord() {
    }

    public short getFirstColumn() {
        return this.colFirst;
    }

    public void setFirstColumn(short col) {
        this.colFirst = col;
    }

    public short getLastColumn() {
        return this.colLast;
    }

    public void setLastColumn(short col) {
        this.colLast = col;
    }

    public int getFirstRow() {
        return this.rwFirst;
    }

    public void setFirstRow(int row) {
        this.rwFirst = row;
    }

    public int getLastRow() {
        return this.rwLast;
    }

    public void setLastRow(int row) {
        this.rwLast = row;
    }

    public byte[] getGuid() {
        return this.guid;
    }

    public byte[] getMoniker() {
        return this.moniker;
    }

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        int idx = this.label.indexOf(0);
        return idx == -1 ? this.label : this.label.substring(0, idx);
    }

    public void setLabel(String label) {
        this.label = label + '\u0000';
    }

    public String getAddress() {
        if (this.address == null) {
            return null;
        }
        int idx = this.address.indexOf(0);
        return idx == -1 ? this.address : this.address.substring(0, idx);
    }

    public void setAddress(String address) {
        this.address = address + '\u0000';
    }

    public int getLinkOptions() {
        return this.link_opts;
    }

    public int getLabelOptions() {
        return this.label_opts;
    }

    public int getFileOptions() {
        return this.file_opts;
    }

    public byte[] getTail() {
        return this.tail;
    }

    public HyperlinkRecord(RecordInputStream in) {
        try {
            int len;
            this.rwFirst = in.readShort();
            this.rwLast = in.readUShort();
            this.colFirst = in.readShort();
            this.colLast = in.readShort();
            this.guid = new byte[16];
            in.read(this.guid);
            this.label_opts = in.readInt();
            this.link_opts = in.readInt();
            if ((this.link_opts & 0x14) != 0) {
                int label_len = in.readInt();
                this.label = in.readUnicodeLEString(label_len);
            }
            if ((this.link_opts & 1) != 0) {
                this.moniker = new byte[16];
                in.read(this.moniker);
                if (Arrays.equals(URL_MONIKER, this.moniker)) {
                    len = in.readInt();
                    this.address = in.readUnicodeLEString(len / 2);
                    this.tail = in.readRemainder();
                } else if (Arrays.equals(FILE_MONIKER, this.moniker)) {
                    this.file_opts = in.readShort();
                    len = in.readInt();
                    byte[] path_bytes = new byte[len];
                    in.read(path_bytes);
                    this.address = new String(path_bytes);
                    this.tail = in.readRemainder();
                }
            } else if ((this.link_opts & 8) != 0) {
                len = in.readInt();
                this.address = in.readUnicodeLEString(len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public short getSid() {
        return 440;
    }

    public int serialize(int offset, byte[] data) {
        int pos = offset;
        LittleEndian.putShort(data, pos, (short)440);
        LittleEndian.putShort(data, pos += 2, (short)(this.getRecordSize() - 4));
        LittleEndian.putUShort(data, pos += 2, this.rwFirst);
        LittleEndian.putUShort(data, pos += 2, this.rwLast);
        LittleEndian.putShort(data, pos += 2, this.colFirst);
        LittleEndian.putShort(data, pos += 2, this.colLast);
        System.arraycopy(this.guid, 0, data, pos += 2, this.guid.length);
        LittleEndian.putInt(data, pos += this.guid.length, this.label_opts);
        LittleEndian.putInt(data, pos += 4, this.link_opts);
        pos += 4;
        if ((this.link_opts & 0x14) != 0) {
            LittleEndian.putInt(data, pos, this.label.length());
            StringUtil.putUnicodeLE(this.label, data, pos += 4);
            pos += this.label.length() * 2;
        }
        if ((this.link_opts & 1) != 0) {
            System.arraycopy(this.moniker, 0, data, pos, this.moniker.length);
            pos += this.moniker.length;
            if (Arrays.equals(URL_MONIKER, this.moniker)) {
                LittleEndian.putInt(data, pos, this.address.length() * 2 + this.tail.length);
                StringUtil.putUnicodeLE(this.address, data, pos += 4);
                pos += this.address.length() * 2;
                if (this.tail.length > 0) {
                    System.arraycopy(this.tail, 0, data, pos, this.tail.length);
                    pos += this.tail.length;
                }
            } else if (Arrays.equals(FILE_MONIKER, this.moniker)) {
                LittleEndian.putShort(data, pos, this.file_opts);
                LittleEndian.putInt(data, pos += 2, this.address.length());
                byte[] bytes = this.address.getBytes();
                System.arraycopy(bytes, 0, data, pos += 4, bytes.length);
                pos += bytes.length;
                if (this.tail.length > 0) {
                    System.arraycopy(this.tail, 0, data, pos, this.tail.length);
                    pos += this.tail.length;
                }
            }
        } else if ((this.link_opts & 8) != 0) {
            LittleEndian.putInt(data, pos, this.address.length());
            StringUtil.putUnicodeLE(this.address, data, pos += 4);
            pos += this.address.length() * 2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int size = 4;
        size += 8;
        size += this.guid.length;
        size += 4;
        size += 4;
        if ((this.link_opts & 0x14) != 0) {
            size += 4;
            size += this.label.length() * 2;
        }
        if ((this.link_opts & 1) != 0) {
            size += this.moniker.length;
            if (Arrays.equals(URL_MONIKER, this.moniker)) {
                size += 4;
                size += this.address.length() * 2;
                size += this.tail.length;
            } else if (Arrays.equals(FILE_MONIKER, this.moniker)) {
                size += 2;
                size += 4;
                size += this.address.length();
                size += this.tail.length;
            }
        } else if ((this.link_opts & 8) != 0) {
            size += 4;
            size += this.address.length() * 2;
        }
        return size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[HYPERLINK RECORD]\n");
        buffer.append("    .rwFirst            = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        buffer.append("    .rwLast         = ").append(Integer.toHexString(this.getLastRow())).append("\n");
        buffer.append("    .colFirst            = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        buffer.append("    .colLast         = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        buffer.append("    .guid        = ").append(HexDump.toHex(this.guid)).append("\n");
        buffer.append("    .label_opts          = ").append(this.label_opts).append("\n");
        buffer.append("    .label          = ").append(this.getLabel()).append("\n");
        if ((this.link_opts & 1) != 0) {
            buffer.append("    .moniker          = ").append(HexDump.toHex(this.moniker)).append("\n");
        }
        buffer.append("    .address            = ").append(this.getAddress()).append("\n");
        buffer.append("[/HYPERLINK RECORD]\n");
        return buffer.toString();
    }

    public void newUrlLink() {
        this.rwFirst = 0;
        this.rwLast = 0;
        this.colFirst = 0;
        this.colLast = 0;
        this.guid = STD_MONIKER;
        this.label_opts = 2;
        this.link_opts = 23;
        this.label = "\u0000";
        this.moniker = URL_MONIKER;
        this.address = "\u0000";
        this.tail = URL_TAIL;
    }

    public void newFileLink() {
        this.rwFirst = 0;
        this.rwLast = 0;
        this.colFirst = 0;
        this.colLast = 0;
        this.guid = STD_MONIKER;
        this.label_opts = 2;
        this.link_opts = 21;
        this.file_opts = 0;
        this.label = "\u0000";
        this.moniker = FILE_MONIKER;
        this.address = "\u0000";
        this.tail = FILE_TAIL;
    }

    public void newDocumentLink() {
        this.rwFirst = 0;
        this.rwLast = 0;
        this.colFirst = 0;
        this.colLast = 0;
        this.guid = STD_MONIKER;
        this.label_opts = 2;
        this.link_opts = 28;
        this.label = "\u0000";
        this.moniker = FILE_MONIKER;
        this.address = "\u0000";
        this.tail = new byte[0];
    }

    public Object clone() {
        HyperlinkRecord rec = new HyperlinkRecord();
        rec.rwFirst = this.rwFirst;
        rec.rwLast = this.rwLast;
        rec.colFirst = this.colFirst;
        rec.colLast = this.colLast;
        rec.guid = this.guid;
        rec.label_opts = this.label_opts;
        rec.link_opts = this.link_opts;
        rec.file_opts = this.file_opts;
        rec.label = this.label;
        rec.address = this.address;
        rec.moniker = this.moniker;
        rec.tail = this.tail;
        return rec;
    }
}

