/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import com.tictactec.ta.lib.Core;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.yccheok.jstock.analysis.AbstractOperator;
import org.yccheok.jstock.analysis.Utils;
import org.yccheok.jstock.charting.TechnicalAnalysis;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryServer;

public class StockRelativeHistoryOperator
extends AbstractOperator {
    private Object value = null;
    private Function function = Function.Max;
    private Type type = Type.OpenPrice;
    private int day = 1;
    private int skipDay = 0;

    @Override
    protected Object calculate() {
        return this.value;
    }

    public int getDay() {
        return this.day;
    }

    public int getSkipDay() {
        return this.skipDay;
    }

    public void setDay(int day) {
        if (day < 0) {
            return;
        }
        int oldDay = this.day;
        this.day = day;
        if (oldDay != this.day) {
            this.firePropertyChange("attribute", oldDay + "d " + this.getSkipDayAsString(this.skipDay) + (Object)((Object)this.function) + " " + (Object)((Object)this.type), this.day + "d " + this.getSkipDayAsString(this.skipDay) + (Object)((Object)this.function) + " " + (Object)((Object)this.type));
        }
    }

    public void setSkipDay(int skipDay) {
        if (skipDay < 0) {
            return;
        }
        int oldSkipDay = this.skipDay;
        this.skipDay = skipDay;
        if (oldSkipDay != this.skipDay) {
            this.firePropertyChange("attribute", this.day + "d " + this.getSkipDayAsString(oldSkipDay) + (Object)((Object)this.function) + " " + (Object)((Object)this.type), this.day + "d " + this.getSkipDayAsString(skipDay) + (Object)((Object)this.function) + " " + (Object)((Object)this.type));
        }
    }

    public void setFunction(Function function) {
        Function oldFunction = this.function;
        this.function = function;
        if (!Utils.equals((Object)oldFunction, (Object)this.function)) {
            this.firePropertyChange("attribute", this.day + "d " + this.getSkipDayAsString(this.skipDay) + (Object)((Object)oldFunction) + " " + (Object)((Object)this.type), this.day + "d " + this.getSkipDayAsString(this.skipDay) + (Object)((Object)this.function) + " " + (Object)((Object)this.type));
        }
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public int getNumOfInputConnector() {
        return 0;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        if (!Utils.equals((Object)oldType, (Object)this.type)) {
            this.firePropertyChange("attribute", this.day + "d " + this.getSkipDayAsString(this.skipDay) + (Object)((Object)this.function) + " " + (Object)((Object)oldType), this.day + "d " + this.getSkipDayAsString(this.skipDay) + (Object)((Object)this.function) + " " + (Object)((Object)this.type));
        }
    }

    private double average(List<Double> values) {
        int size = values.size();
        assert (size >= 0);
        Double sum = 0.0;
        for (Double v : values) {
            sum = sum + v;
        }
        return sum / (double)size;
    }

    public int getRequiredHistorySize() {
        if (this.function == Function.EMA) {
            Core core = new Core();
            int lookback = core.emaLookback(this.day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.RSI) {
            Core core = new Core();
            int lookback = core.rsiLookback(this.day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.MFI) {
            Core core = new Core();
            int lookback = core.mfiLookback(this.day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.MACD) {
            Core core = new Core();
            int lookback = core.macdFixLookback(this.day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.MACDSignal) {
            Core core = new Core();
            int lookback = core.macdFixLookback(this.day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.MACDHist) {
            Core core = new Core();
            int lookback = core.macdFixLookback(this.day);
            return lookback + 1 << 2;
        }
        return this.day;
    }

    public void calculate(StockHistoryServer stockHistoryServer) {
        if (this.day <= 0 || this.skipDay < 0) {
            Object oldValue = this.value;
            this.value = null;
            if (!Utils.equals(oldValue, this.value)) {
                this.firePropertyChange("value", oldValue, this.value);
            }
            return;
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Double> highs = new ArrayList<Double>();
        ArrayList<Double> lows = new ArrayList<Double>();
        ArrayList<Double> closes = new ArrayList<Double>();
        ArrayList<Long> volumes = new ArrayList<Long>();
        int size = stockHistoryServer.size();
        int start = Math.max(0, size - this.getRequiredHistorySize());
        int ei = Math.max(0, size - this.skipDay);
        for (int i = Math.max(0, start - this.skipDay); i < ei; ++i) {
            long timestamp = stockHistoryServer.getTimestamp(i);
            Iterator stock = stockHistoryServer.getStock(timestamp);
            stocks.add((Stock)((Object)stock));
        }
        if (this.function == Function.MFI) {
            for (Stock stock : stocks) {
                values.add(TechnicalAnalysis.getTypicalPrice(stock));
                highs.add(stock.getHighPrice());
                lows.add(stock.getLowPrice());
                closes.add(stock.getLastPrice());
                volumes.add(stock.getVolume());
            }
        } else {
            switch (this.type) {
                case PrevPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getPrevPrice());
                    }
                    break;
                }
                case OpenPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getOpenPrice());
                    }
                    break;
                }
                case HighPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getHighPrice());
                    }
                    break;
                }
                case LowPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getLowPrice());
                    }
                    break;
                }
                case LastPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getLastPrice());
                    }
                    break;
                }
                case TypicalPrice: {
                    for (Stock stock : stocks) {
                        values.add(TechnicalAnalysis.getTypicalPrice(stock));
                    }
                    break;
                }
                case Volume: {
                    for (Stock stock : stocks) {
                        values.add(new Double(stock.getVolume()));
                    }
                    break;
                }
                case MarketCapital: {
                    values.add(new Double(stockHistoryServer.getMarketCapital()));
                    break;
                }
                case SharesIssued: {
                    values.add(new Double(stockHistoryServer.getSharesIssued()));
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw new AssertionError();
                }
            }
        }
        int dataSize = values.size();
        if (dataSize == 0) {
            Object oldValue = this.value;
            this.value = null;
            if (!Utils.equals(oldValue, this.value)) {
                this.firePropertyChange("value", oldValue, this.value);
            }
            return;
        }
        Double v = this.function == Function.Min ? Double.MAX_VALUE : 0.0;
        double tmp_v = v;
        switch (this.function) {
            case Max: {
                for (Double _value : values) {
                    tmp_v = Math.max(tmp_v, _value);
                }
                v = tmp_v;
                break;
            }
            case Min: {
                for (Double _value : values) {
                    tmp_v = Math.min(tmp_v, _value);
                }
                v = tmp_v;
                break;
            }
            case Average: {
                v = this.average(values);
                break;
            }
            case MeanDeviation: {
                double average = 0.0;
                for (Double _value : values) {
                    average += _value.doubleValue();
                }
                average /= (double)dataSize;
                for (Double _value : values) {
                    tmp_v += Math.abs(_value - average);
                }
                v = tmp_v /= (double)dataSize;
                break;
            }
            case RSI: {
                v = TechnicalAnalysis.createRSI(values, this.day);
                break;
            }
            case EMA: {
                v = TechnicalAnalysis.createEMA(values, this.day);
                break;
            }
            case MFI: {
                v = TechnicalAnalysis.createMFI(highs, lows, closes, volumes, this.day);
                break;
            }
            case MACD: {
                v = TechnicalAnalysis.createMACDFix(values, (int)this.day).outMACD;
                break;
            }
            case MACDSignal: {
                v = TechnicalAnalysis.createMACDFix(values, (int)this.day).outMACDSignal;
                break;
            }
            case MACDHist: {
                v = TechnicalAnalysis.createMACDFix(values, (int)this.day).outMACDHist;
                break;
            }
            case StandardDeviation: {
                if (dataSize - 1 <= 0) {
                    Object oldValue = this.value;
                    this.value = null;
                    if (!Utils.equals(oldValue, this.value)) {
                        this.firePropertyChange("value", oldValue, this.value);
                    }
                    return;
                }
                double mean = this.average(values);
                double squareSum = 0.0;
                for (Double _value : values) {
                    squareSum += Math.pow(_value - mean, 2.0);
                }
                v = Math.sqrt(squareSum / (double)(dataSize - 1));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Object oldValue = this.value;
        this.value = v;
        if (!Utils.equals(oldValue, this.value)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    @Override
    public Class getInputClass(int index) {
        return null;
    }

    @Override
    public Class getOutputClass(int index) {
        return Double.class;
    }

    private String getSkipDayAsString(int skipDay) {
        if (skipDay <= 0) {
            return "";
        }
        return "(-" + skipDay + ") ";
    }

    public static enum Type {
        PrevPrice,
        OpenPrice,
        HighPrice,
        LowPrice,
        LastPrice,
        TypicalPrice,
        Volume,
        MarketCapital,
        SharesIssued;

    }

    public static enum Function {
        Max,
        Min,
        Average,
        MeanDeviation,
        RSI,
        EMA,
        MFI,
        MACD,
        MACDSignal,
        MACDHist,
        StandardDeviation;

    }
}

