/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel.websocket;

import com.google.inject.Provider;
import com.google.inject.servlet.ServletModule;
import java.util.Arrays;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.guacamole.tunnel.TunnelLoader;
import org.apache.guacamole.tunnel.TunnelRequestService;
import org.apache.guacamole.tunnel.websocket.RestrictedGuacamoleWebSocketTunnelEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTunnelModule
extends ServletModule
implements TunnelLoader {
    private final Logger logger = LoggerFactory.getLogger(WebSocketTunnelModule.class);

    public boolean isSupported() {
        try {
            Class.forName("javax.websocket.Endpoint");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    public void configureServlets() {
        this.logger.info("Loading JSR-356 WebSocket support...");
        ServerContainer container = (ServerContainer)this.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
        if (container == null) {
            this.logger.warn("ServerContainer attribute required by JSR-356 is missing. Cannot load JSR-356 WebSocket support.");
            return;
        }
        Provider tunnelRequestServiceProvider = this.getProvider(TunnelRequestService.class);
        ServerEndpointConfig config = ServerEndpointConfig.Builder.create(RestrictedGuacamoleWebSocketTunnelEndpoint.class, (String)"/websocket-tunnel").configurator((ServerEndpointConfig.Configurator)new RestrictedGuacamoleWebSocketTunnelEndpoint.Configurator(tunnelRequestServiceProvider)).subprotocols(Arrays.asList("guacamole")).build();
        try {
            container.addEndpoint(config);
        }
        catch (DeploymentException e) {
            this.logger.error("Unable to deploy WebSocket tunnel.", (Throwable)e);
        }
    }
}

