/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.inject.AbstractModule;
import java.io.File;
import org.apache.guacamole.environment.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(LogModule.class);
    private final Environment environment;

    public LogModule(Environment environment) {
        this.environment = environment;
    }

    protected void configure() {
        File guacamoleHome = this.environment.getGuacamoleHome();
        if (!guacamoleHome.isDirectory()) {
            return;
        }
        File logbackConfiguration = new File(guacamoleHome, "logback.xml");
        if (!logbackConfiguration.exists()) {
            return;
        }
        this.logger.info("Loading logback configuration from \"{}\".", (Object)logbackConfiguration);
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            configurator.doConfigure(logbackConfiguration);
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
        catch (JoranException e) {
            this.logger.error("Initialization of logback failed: {}", (Object)e.getMessage());
            this.logger.debug("Unable to load logback configuration..", (Throwable)e);
        }
    }
}

