/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.DefaultConnectFuture;
import org.apache.mina.core.service.AbstractIoConnector;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.proxy.AbstractProxyIoHandler;
import org.apache.mina.proxy.filter.ProxyFilter;
import org.apache.mina.proxy.handlers.socks.SocksProxyRequest;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.session.ProxyIoSessionInitializer;
import org.apache.mina.transport.socket.DefaultSocketSessionConfig;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.SocketSessionConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyConnector
extends AbstractIoConnector {
    private static final TransportMetadata METADATA = new DefaultTransportMetadata("proxy", "proxyconnector", false, true, InetSocketAddress.class, SocketSessionConfig.class, IoBuffer.class, FileRegion.class);
    private SocketConnector connector = null;
    private final ProxyFilter proxyFilter = new ProxyFilter();
    private ProxyIoSession proxyIoSession;
    private DefaultConnectFuture future;

    public ProxyConnector(SocketConnector socketConnector) {
        this(socketConnector, new DefaultSocketSessionConfig(), null);
    }

    public ProxyConnector(SocketConnector socketConnector, IoSessionConfig ioSessionConfig, Executor executor) {
        super(ioSessionConfig, executor);
        this.setConnector(socketConnector);
    }

    @Override
    public IoSessionConfig getSessionConfig() {
        return this.connector.getSessionConfig();
    }

    public void setProxyIoSession(ProxyIoSession proxyIoSession) {
        if (proxyIoSession == null) {
            throw new IllegalArgumentException("proxySession object cannot be null");
        }
        if (proxyIoSession.getProxyAddress() == null) {
            throw new IllegalArgumentException("proxySession.proxyAddress cannot be null");
        }
        proxyIoSession.setConnector(this);
        this.setDefaultRemoteAddress(proxyIoSession.getProxyAddress());
        this.proxyIoSession = proxyIoSession;
    }

    @Override
    protected ConnectFuture connect0(SocketAddress socketAddress, SocketAddress socketAddress2, IoSessionInitializer<? extends ConnectFuture> ioSessionInitializer) {
        Object object;
        if (!this.proxyIoSession.isReconnectionNeeded()) {
            object = this.getHandler();
            if (!(object instanceof AbstractProxyIoHandler)) {
                throw new IllegalArgumentException("IoHandler must be an instance of AbstractProxyIoHandler");
            }
            this.connector.setHandler((IoHandler)object);
            this.future = new DefaultConnectFuture();
        }
        object = this.connector.connect(this.proxyIoSession.getProxyAddress(), new ProxyIoSessionInitializer<ConnectFuture>(ioSessionInitializer, this.proxyIoSession));
        if (this.proxyIoSession.getRequest() instanceof SocksProxyRequest || this.proxyIoSession.isReconnectionNeeded()) {
            return object;
        }
        return this.future;
    }

    public void cancelConnectFuture() {
        this.future.cancel();
    }

    protected ConnectFuture fireConnected(IoSession ioSession) {
        this.future.setSession(ioSession);
        return this.future;
    }

    private final void setConnector(SocketConnector socketConnector) {
        if (socketConnector == null) {
            throw new IllegalArgumentException("connector cannot be null");
        }
        this.connector = socketConnector;
        String string = ProxyFilter.class.getName();
        if (socketConnector.getFilterChain().contains(string)) {
            socketConnector.getFilterChain().remove(string);
        }
        socketConnector.getFilterChain().addFirst(string, this.proxyFilter);
    }

    @Override
    protected void dispose0() throws Exception {
        if (this.connector != null) {
            this.connector.dispose();
        }
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }
}

