/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class MemoryIndicator
extends JPanel {
    private final JProgressBar progressBar;

    public MemoryIndicator() {
        this.setLayout(new BoxLayout(this, 2));
        this.progressBar = new JProgressBar();
        this.add(this.progressBar);
        JButton button = ComponentFactory.getToolbarButton();
        button.setName("btnGC");
        Swinger.getResourceMap().injectComponent(button);
        button.setIconTextGap(0);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).start();
            }
        });
        this.add(button);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setStringPainted(true);
        this.updateInfo();
        final Timer timer = new Timer(2500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryIndicator.this.updateInfo();
            }
        });
        timer.start();
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    timer.start();
                } else {
                    timer.stop();
                }
            }
        });
    }

    private void updateInfo() {
        Runtime s_runtime = Runtime.getRuntime();
        int max = (int)(s_runtime.maxMemory() / 1024L / 1024L);
        long used_memory = s_runtime.totalMemory() - s_runtime.freeMemory();
        used_memory = used_memory / 1024L / 1024L;
        String s = Swinger.getResourceMap().getString("memoryIndicator", used_memory, max);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue((int)used_memory);
        this.progressBar.setString(s);
    }
}

