/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.userprefs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.QuietMode;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesDialog;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesTab;
import cz.vity.freerapid.swing.Swinger;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.application.Action;

public class AlertsTab
extends UserPreferencesTab {
    private JRadioButton radioButtonActivateQMAlways;
    private JRadioButton radioButtonActivateQMWhenWindowsFound;
    private JPanel panelSearchForWindows;
    private JList listQuietModeDetectionStrings;
    private JButton btnAddQuietModeDetectionString;
    private JButton btnRemoveQuietModeDetectionString;
    private JCheckBox checkCaseSensitiveSearchQM;
    private JCheckBox checkNoSoundsInQM;
    private JCheckBox checkNoCaptchaInQM;
    private JCheckBox checkNoConfirmDialogsInQM;
    private JCheckBox checkPlaySoundForQM;
    private JCheckBox checkPlaySoundInCaseOfError;
    private JCheckBox checkPlaySoundWhenComplete;
    private JCheckBox checkConfirmExiting;
    private JCheckBox checkConfirmFileDeletion;
    private JCheckBox checkConfirmFileRemove;
    private JCheckBox checkConfirmDownloadingRemoveOnly;

    AlertsTab(UserPreferencesDialog dialog) {
        super(dialog);
    }

    @Override
    public void init() {
        this.bind(this.checkPlaySoundWhenComplete, "playSoundOK", (Object)true);
        this.bind(this.checkPlaySoundInCaseOfError, "playSoundsFailed", (Object)true);
        this.bind(this.checkConfirmExiting, "confirmExit", (Object)true);
        this.bind(this.checkConfirmFileDeletion, "confirmFileDelete", (Object)true);
        ValueModel confirmRemove = this.bind(this.checkConfirmFileRemove, "confirmRemove", (Object)true);
        this.bind(this.checkConfirmDownloadingRemoveOnly, "confirmDownloadingRemove", (Object)false);
        PropertyConnector.connectAndUpdate(confirmRemove, this.checkConfirmDownloadingRemoveOnly, "enabled");
        ValueModel valueModelQMActivation = this.dialog.getModel().getBufferedPreferences("quietModeActivationMode", "always");
        Bindings.bind(this.radioButtonActivateQMAlways, valueModelQMActivation, (Object)"always");
        Bindings.bind(this.radioButtonActivateQMWhenWindowsFound, valueModelQMActivation, (Object)"whenWindowsFound");
        final class ItemListenerQMActivation
        implements ItemListener {
            ItemListenerQMActivation() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                this.refresh();
            }

            public void refresh() {
                boolean enabled = AlertsTab.this.radioButtonActivateQMWhenWindowsFound.isSelected();
                AlertsTab.this.actionMap.get("btnAddQuietModeDetectionStringAction").setEnabled(enabled);
                AlertsTab.this.actionMap.get("btnRemoveQuietModeDetectionStringAction").setEnabled(enabled);
                this.refresh(AlertsTab.this.panelSearchForWindows, enabled);
            }

            private void refresh(Component component, boolean enabled) {
                component.setEnabled(enabled);
                if (component instanceof Container) {
                    for (Component c : ((Container)component).getComponents()) {
                        this.refresh(c, enabled);
                    }
                }
            }
        }
        ItemListenerQMActivation itemListenerQMActivation = new ItemListenerQMActivation();
        this.radioButtonActivateQMWhenWindowsFound.addItemListener(itemListenerQMActivation);
        itemListenerQMActivation.refresh();
        ArrayListModel<String> arrayListModel = new ArrayListModel<String>();
        arrayListModel.addAll(QuietMode.getInstance().getActivationStrings());
        this.listQuietModeDetectionStrings.setModel(arrayListModel);
        this.bind(this.checkCaseSensitiveSearchQM, "quietModeCaseSensitiveSearch", (Object)false);
        this.bind(this.checkNoSoundsInQM, "quietModeNoSounds", (Object)true);
        this.bind(this.checkNoCaptchaInQM, "quietModeNoCaptcha", (Object)true);
        this.bind(this.checkNoConfirmDialogsInQM, "quietModeNoConfirmDialogs", (Object)true);
        this.bind(this.checkPlaySoundForQM, "quietModePlaySoundOnActivate", (Object)false);
        this.setAction(this.btnAddQuietModeDetectionString, "btnAddQuietModeDetectionStringAction");
        this.setAction(this.btnRemoveQuietModeDetectionString, "btnRemoveQuietModeDetectionStringAction");
    }

    @Action
    public void btnAddQuietModeDetectionStringAction() {
        JTextField textField = new JTextField();
        int result = Swinger.showInputDialog(this.resourceMap.getString("addNewWindowPopupTitle", new Object[0]), textField, true);
        String text = textField.getText().trim();
        if (result == 0 && !text.isEmpty()) {
            this.dialog.getModel().setBuffering(true);
            ArrayListModel listModel = (ArrayListModel)this.listQuietModeDetectionStrings.getModel();
            int indexOf = listModel.indexOf(text);
            if (indexOf != -1) {
                this.listQuietModeDetectionStrings.setSelectedIndex(indexOf);
            } else {
                listModel.add(text);
                this.listQuietModeDetectionStrings.setSelectedIndex(listModel.size() - 1);
            }
        }
    }

    @Action
    public void btnRemoveQuietModeDetectionStringAction() {
        int[] selected = this.listQuietModeDetectionStrings.getSelectedIndices();
        if (selected.length > 0) {
            this.dialog.getModel().setBuffering(true);
            ArrayListModel listModel = (ArrayListModel)this.listQuietModeDetectionStrings.getModel();
            for (int i = selected.length - 1; i >= 0; --i) {
                listModel.remove(selected[i]);
            }
            if (selected.length == 1) {
                this.listQuietModeDetectionStrings.setSelectedIndex(selected[0]);
            }
        }
    }

    @Override
    public void apply() {
        ArrayListModel arrayListModel = (ArrayListModel)this.listQuietModeDetectionStrings.getModel();
        QuietMode.getInstance().setActivationStrings(arrayListModel);
    }

    @Override
    public void build(CellConstraints cc) {
        JPanel alertsPanelGeneral = new JPanel();
        JPanel panelSound = new JPanel();
        JPanel panelConfirmation = new JPanel();
        JPanel alertsPanelQM = new JPanel();
        JPanel panelActivateQM = new JPanel();
        JPanel panelQMOptions = new JPanel();
        JTabbedPane alertsTabbedPane = new JTabbedPane();
        this.checkPlaySoundInCaseOfError = new JCheckBox();
        this.checkPlaySoundInCaseOfError.setName("checkPlaySoundInCaseOfError");
        this.checkPlaySoundWhenComplete = new JCheckBox();
        this.checkPlaySoundWhenComplete.setName("checkPlaySoundWhenComplete");
        this.checkConfirmExiting = new JCheckBox();
        this.checkConfirmExiting.setName("checkConfirmExiting");
        this.checkConfirmFileDeletion = new JCheckBox();
        this.checkConfirmFileDeletion.setName("checkConfirmFileDeletion");
        this.checkConfirmFileRemove = new JCheckBox();
        this.checkConfirmFileRemove.setName("checkConfirmFileRemove");
        this.checkConfirmDownloadingRemoveOnly = new JCheckBox();
        this.checkConfirmDownloadingRemoveOnly.setName("checkConfirmDownloadingRemoveOnly");
        this.radioButtonActivateQMAlways = new JRadioButton();
        this.radioButtonActivateQMAlways.setName("radioButtonActivateQMAlways");
        this.radioButtonActivateQMWhenWindowsFound = new JRadioButton();
        this.radioButtonActivateQMWhenWindowsFound.setName("radioButtonActivateQMWhenWindowsFound");
        this.panelSearchForWindows = new JPanel();
        JLabel labelSearchForWindows = new JLabel();
        labelSearchForWindows.setName("labelSearchForWindows");
        this.listQuietModeDetectionStrings = new JList();
        this.listQuietModeDetectionStrings.setVisibleRowCount(6);
        JScrollPane panelQMChoice = new JScrollPane();
        panelQMChoice.setViewportView(this.listQuietModeDetectionStrings);
        this.btnAddQuietModeDetectionString = new JButton();
        this.btnAddQuietModeDetectionString.setName("btnAddQuietModeDetectionString");
        this.btnRemoveQuietModeDetectionString = new JButton();
        this.btnRemoveQuietModeDetectionString.setName("btnRemoveQuietModeDetectionString");
        this.checkCaseSensitiveSearchQM = new JCheckBox();
        this.checkCaseSensitiveSearchQM.setName("checkCaseSensitiveSearchQM");
        this.checkNoSoundsInQM = new JCheckBox();
        this.checkNoSoundsInQM.setName("checkNoSoundsInQM");
        this.checkNoCaptchaInQM = new JCheckBox();
        this.checkNoCaptchaInQM.setName("checkNoCaptchaInQM");
        this.checkNoConfirmDialogsInQM = new JCheckBox();
        this.checkNoConfirmDialogsInQM.setName("checkNoConfirmDialogsInQM");
        this.checkPlaySoundForQM = new JCheckBox();
        this.checkPlaySoundForQM.setName("checkPlaySoundForQM");
        JLabel labelNoteForQM = new JLabel();
        labelNoteForQM.setName("labelNoteForQM");
        this.setBorder(Borders.TABBED_DIALOG);
        alertsPanelGeneral.setBorder(new EmptyBorder(4, 4, 4, 4));
        panelSound.setBorder(new CompoundBorder(new TitledBorder(null, this.resourceMap.getString("panelSound.border", new Object[0]), 4, 2), Borders.DLU2));
        PanelBuilder panelSoundBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs("default, default")), panelSound);
        panelSoundBuilder.add((Component)this.checkPlaySoundInCaseOfError, cc.xy(3, 1));
        panelSoundBuilder.add((Component)this.checkPlaySoundWhenComplete, cc.xy(3, 2));
        panelConfirmation.setBorder(new CompoundBorder(new TitledBorder(null, this.resourceMap.getString("panelConfirmation.border", new Object[0]), 4, 2), Borders.DLU2));
        PanelBuilder panelConfirmationBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, Sizes.dluX(0), 0.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, new ColumnSpec(Sizes.dluX(9)), FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), panelConfirmation);
        panelConfirmationBuilder.add((Component)this.checkConfirmExiting, cc.xyw(3, 1, 3));
        panelConfirmationBuilder.add((Component)this.checkConfirmFileDeletion, cc.xy(7, 1));
        panelConfirmationBuilder.add((Component)this.checkConfirmFileRemove, cc.xyw(3, 2, 3));
        panelConfirmationBuilder.add((Component)this.checkConfirmDownloadingRemoveOnly, cc.xy(5, 3));
        PanelBuilder alertsPanelGeneralBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), alertsPanelGeneral);
        alertsPanelGeneralBuilder.add((Component)panelSound, cc.xy(1, 1));
        alertsPanelGeneralBuilder.add((Component)panelConfirmation, cc.xy(1, 3));
        alertsTabbedPane.addTab(this.resourceMap.getString("alertsPanelGeneral.tab.title", new Object[0]), alertsPanelGeneral);
        alertsPanelQM.setBorder(new EmptyBorder(4, 4, 4, 4));
        panelActivateQM.setBorder(new TitledBorder(this.resourceMap.getString("panelActivateQM.border", new Object[0])));
        PanelBuilder panelActivateQMBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), panelActivateQM);
        panelActivateQMBuilder.add((Component)this.radioButtonActivateQMAlways, cc.xy(1, 1));
        panelActivateQMBuilder.add((Component)this.radioButtonActivateQMWhenWindowsFound, cc.xy(1, 3));
        PanelBuilder panelSearchForWindowsBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(20)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(140)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.MIN_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.ZERO, 1.0), FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), this.panelSearchForWindows);
        panelSearchForWindowsBuilder.add((Component)labelSearchForWindows, cc.xy(3, 1));
        panelSearchForWindowsBuilder.add((Component)panelQMChoice, cc.xywh(3, 3, 3, 4));
        panelSearchForWindowsBuilder.add((Component)this.btnAddQuietModeDetectionString, cc.xy(7, 3));
        panelSearchForWindowsBuilder.add((Component)this.btnRemoveQuietModeDetectionString, cc.xy(7, 5));
        panelSearchForWindowsBuilder.add((Component)this.checkCaseSensitiveSearchQM, cc.xy(3, 8));
        panelActivateQMBuilder.add((Component)this.panelSearchForWindows, cc.xy(1, 5));
        panelQMOptions.setBorder(new TitledBorder(this.resourceMap.getString("panelQMOptions.border", new Object[0])));
        PanelBuilder panelQMOptionsBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.dluX(105), 1.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}), panelQMOptions);
        panelQMOptionsBuilder.add((Component)this.checkNoSoundsInQM, cc.xy(1, 1));
        panelQMOptionsBuilder.add((Component)this.checkNoCaptchaInQM, cc.xy(1, 3));
        panelQMOptionsBuilder.add((Component)this.checkNoConfirmDialogsInQM, cc.xy(1, 5));
        panelQMOptionsBuilder.add((Component)this.checkPlaySoundForQM, cc.xy(1, 7));
        PanelBuilder alertsPanelQMBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, Sizes.DEFAULT, 1.0)}), alertsPanelQM);
        alertsPanelQMBuilder.add((Component)panelActivateQM, cc.xy(1, 1));
        alertsPanelQMBuilder.add((Component)panelQMOptions, cc.xy(1, 3));
        alertsPanelQMBuilder.add((Component)labelNoteForQM, cc.xy(1, 5));
        alertsTabbedPane.addTab(this.resourceMap.getString("alertsPanelQM.tab.title", new Object[0]), alertsPanelQM);
        PanelBuilder thisBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs("default:grow"), new RowSpec[]{new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 1.0), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode("5px")}), this);
        thisBuilder.add((Component)alertsTabbedPane, cc.xy(1, 1));
    }
}

