/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.bernstein;

import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.plaf.UIResource;

public class BernsteinIcons
extends BaseIcons {
    private static Icon radioButtonIcon;
    private static Icon checkBoxIcon;
    private static Icon thumbIcon;
    private static Icon thumbIconRollover;
    private static Icon splitterUpArrowIcon;
    private static Icon splitterDownArrowIcon;
    private static Icon splitterLeftArrowIcon;
    private static Icon splitterRightArrowIcon;

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getThumbHorIcon() {
        if (thumbIcon == null) {
            thumbIcon = new LazyImageIcon("bernstein/icons/radio.gif");
        }
        return thumbIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbIcon == null) {
            thumbIcon = new LazyImageIcon("bernstein/icons/radio.gif");
        }
        return thumbIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbIconRollover == null) {
            thumbIconRollover = new LazyImageIcon("bernstein/icons/radio_rollover.gif");
        }
        return thumbIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbIconRollover == null) {
            thumbIconRollover = new LazyImageIcon("bernstein/icons/radio_rollover.gif");
        }
        return thumbIconRollover;
    }

    public static Icon getSplitterUpArrowIcon() {
        if (splitterUpArrowIcon == null) {
            splitterUpArrowIcon = new LazyImageIcon("bernstein/icons/SplitterUpArrow.gif");
        }
        return splitterUpArrowIcon;
    }

    public static Icon getSplitterDownArrowIcon() {
        if (splitterDownArrowIcon == null) {
            splitterDownArrowIcon = new LazyImageIcon("bernstein/icons/SplitterDownArrow.gif");
        }
        return splitterDownArrowIcon;
    }

    public static Icon getSplitterLeftArrowIcon() {
        if (splitterLeftArrowIcon == null) {
            splitterLeftArrowIcon = new LazyImageIcon("bernstein/icons/SplitterLeftArrow.gif");
        }
        return splitterLeftArrowIcon;
    }

    public static Icon getSplitterRightArrowIcon() {
        if (splitterRightArrowIcon == null) {
            splitterRightArrowIcon = new LazyImageIcon("bernstein/icons/SplitterRightArrow.gif");
        }
        return splitterRightArrowIcon;
    }

    static {
        thumbIcon = null;
        thumbIconRollover = null;
        splitterUpArrowIcon = null;
        splitterDownArrowIcon = null;
        splitterLeftArrowIcon = null;
        splitterRightArrowIcon = null;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource {
        private Icon radioIcon = new LazyImageIcon("bernstein/icons/radio.gif");
        private Icon radioSelectedIcon = new LazyImageIcon("bernstein/icons/radio_selected.gif");
        private Icon radioRolloverIcon = new LazyImageIcon("bernstein/icons/radio_rollover.gif");
        private Icon radioRolloverSelectedIcon = new LazyImageIcon("bernstein/icons/radio_rollover_selected.gif");
        private Icon radioDisabledIcon = new LazyImageIcon("bernstein/icons/radio_disabled.gif");
        private Icon radioDisabledSelectedIcon = new LazyImageIcon("bernstein/icons/radio_disabled_selected.gif");

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 2;
            }
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            if (jRadioButton.isEnabled()) {
                if (buttonModel.isSelected()) {
                    if (jRadioButton.isRolloverEnabled() && buttonModel.isRollover()) {
                        this.radioRolloverSelectedIcon.paintIcon(component, graphics, n, n2);
                    } else {
                        this.radioSelectedIcon.paintIcon(component, graphics, n, n2);
                    }
                } else if (jRadioButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    this.radioRolloverIcon.paintIcon(component, graphics, n, n2);
                } else {
                    this.radioIcon.paintIcon(component, graphics, n, n2);
                }
            } else if (buttonModel.isSelected()) {
                this.radioDisabledSelectedIcon.paintIcon(component, graphics, n, n2);
            } else {
                this.radioDisabledIcon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.radioIcon.getIconWidth() + 2;
        }

        public int getIconHeight() {
            return this.radioIcon.getIconHeight();
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource {
        private static Icon checkIcon = null;
        private static Icon checkSelectedIcon = null;
        private static Icon checkPressedIcon = null;
        private static Icon checkRolloverIcon = null;
        private static Icon checkRolloverSelectedIcon = null;
        private static Icon checkDisabledIcon = null;
        private static Icon checkDisabledSelectedIcon = null;

        public CheckBoxIcon() {
            checkIcon = new LazyImageIcon("bernstein/icons/check.gif");
            checkSelectedIcon = new LazyImageIcon("bernstein/icons/check_selected.gif");
            checkPressedIcon = new LazyImageIcon("bernstein/icons/check_pressed.gif");
            checkRolloverIcon = new LazyImageIcon("bernstein/icons/check_rollover.gif");
            checkRolloverSelectedIcon = new LazyImageIcon("bernstein/icons/check_rollover_selected.gif");
            checkDisabledIcon = new LazyImageIcon("bernstein/icons/check_disabled.gif");
            checkDisabledSelectedIcon = new LazyImageIcon("bernstein/icons/check_disabled_selected.gif");
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 2;
            }
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            if (jCheckBox.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    checkPressedIcon.paintIcon(component, graphics, n, n2);
                } else if (buttonModel.isSelected()) {
                    if (jCheckBox.isRolloverEnabled() && buttonModel.isRollover() && !buttonModel.isArmed()) {
                        checkRolloverSelectedIcon.paintIcon(component, graphics, n, n2);
                    } else {
                        checkSelectedIcon.paintIcon(component, graphics, n, n2);
                    }
                } else if (jCheckBox.isRolloverEnabled() && buttonModel.isRollover() && !buttonModel.isArmed()) {
                    checkRolloverIcon.paintIcon(component, graphics, n, n2);
                } else {
                    checkIcon.paintIcon(component, graphics, n, n2);
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                checkPressedIcon.paintIcon(component, graphics, n, n2);
            } else if (buttonModel.isSelected()) {
                checkDisabledSelectedIcon.paintIcon(component, graphics, n, n2);
            } else {
                checkDisabledIcon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return checkIcon.getIconWidth() + 2;
        }

        public int getIconHeight() {
            return checkIcon.getIconHeight();
        }
    }
}

