/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aero;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class AeroTabbedPaneUI
extends BaseTabbedPaneUI {
    private Color[] sepColors = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AeroTabbedPaneUI();
    }

    protected void installComponents() {
        this.simpleButtonBorder = true;
        super.installComponents();
    }

    protected Color[] getContentBorderColors(int n) {
        if (this.sepColors == null) {
            this.sepColors = new Color[5];
            this.sepColors[0] = ColorHelper.brighter(AeroLookAndFeel.getControlColorDark(), 40.0);
            this.sepColors[1] = ColorHelper.brighter(AeroLookAndFeel.getControlColorLight(), 40.0);
            this.sepColors[2] = ColorHelper.brighter(AeroLookAndFeel.getControlColorLight(), 60.0);
            this.sepColors[3] = ColorHelper.brighter(AeroLookAndFeel.getControlColorLight(), 20.0);
            this.sepColors[4] = ColorHelper.brighter(AeroLookAndFeel.getControlColorDark(), 30.0);
        }
        return this.sepColors;
    }

    protected Font getTabFont(boolean bl) {
        if (bl) {
            return super.getTabFont(bl).deriveFont(1);
        }
        return super.getTabFont(bl);
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(AbstractLookAndFeel.getTabAreaBackgroundColor());
        int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
        int n8 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
        if (n == 1 || n == 2) {
            graphics.fillRect(n3, n4, n8, n7);
        } else if (n == 3) {
            graphics.fillRect(n3, n6 - n7 + 1, n5, n7);
        } else {
            graphics.fillRect(n5 - n8 + 1, n4, n8, n6);
        }
        super.paintContentBorder(graphics, n, n2, n3, n4, n5, n6);
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            view.paint(graphics, rectangle);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        } else {
            int n3 = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                if (bl) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
                    if (ColorHelper.getGrayValue(colorUIResource) > 164) {
                        graphics.setColor(Color.black);
                    } else {
                        graphics.setColor(Color.white);
                    }
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
                    graphics.setColor(colorUIResource);
                } else {
                    graphics.setColor(this.tabPane.getForegroundAt(n2));
                }
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }
}

