/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;

public final class NameUtil {
    private NameUtil() {
    }

    public static String getCommonName(X500Name x500Name) {
        if (x500Name == null) {
            return null;
        }
        RDN[] rDNArray = x500Name.getRDNs(BCStyle.CN);
        if (rDNArray.length == 0) {
            return null;
        }
        return rDNArray[0].getFirst().getValue().toString();
    }

    static String getCommonName(X500Principal x500Principal) {
        if (x500Principal == null) {
            return null;
        }
        return NameUtil.getCommonName(X500Name.getInstance(x500Principal.getEncoded()));
    }
}

