/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.resource;

import java.io.File;
import org.simpleframework.http.Path;
import org.simpleframework.http.resource.Context;
import org.simpleframework.http.resource.FileIndexer;
import org.simpleframework.http.resource.Index;

public class FileContext
implements Context {
    private final FileIndexer indexer;
    private final File base;

    public FileContext() {
        this(new File("."));
    }

    public FileContext(File base) {
        this.indexer = new FileIndexer(base);
        this.base = base;
    }

    public String getBasePath() {
        return this.base.getAbsolutePath();
    }

    public String getRealPath(String target) {
        return this.getIndex(target).getRealPath();
    }

    public String getRequestPath(String target) {
        return this.getIndex(target).getRequestPath();
    }

    public File getFile(String target) {
        return this.getIndex(target).getFile();
    }

    public File getDirectory(String target) {
        return this.getIndex(target).getDirectory();
    }

    public Path getPath(String target) {
        return this.getIndex(target).getPath();
    }

    public String getContentType(String target) {
        return this.getIndex(target).getContentType();
    }

    public String getName(String target) {
        return this.getIndex(target).getName();
    }

    public Index getIndex(String target) {
        return this.indexer.getIndex(target);
    }
}

