/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.impl.GdbMinimalSymbol;
import agent.gdb.model.impl.GdbModelTargetSymbolContainer;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSymbol;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Symbol", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetSymbol
extends DefaultTargetObject<TargetObject, GdbModelTargetSymbolContainer>
implements TargetSymbol {
    protected final boolean constant;
    protected final Address value;
    protected final long size;

    protected static String indexSymbol(GdbMinimalSymbol symbol) {
        return symbol.getName();
    }

    protected static String keySymbol(GdbMinimalSymbol symbol) {
        return PathUtils.makeKey((String)GdbModelTargetSymbol.indexSymbol(symbol));
    }

    public GdbModelTargetSymbol(GdbModelTargetSymbolContainer symbols, GdbMinimalSymbol symbol) {
        super((AbstractDebuggerObjectModel)symbols.impl, (TargetObject)symbols, GdbModelTargetSymbol.keySymbol(symbol), "Symbol");
        symbols.impl.addModelObject(symbol, (TargetObject)this);
        this.constant = false;
        this.value = symbols.impl.space.getAddress(symbol.getAddress());
        this.size = 0L;
        this.changeAttributes(List.of(), Map.of("_namespace", symbols, "_value", this.value, "_size", this.size, "_display", symbol.getName()), "Initialized");
    }

    public GdbModelTargetSymbolContainer getNamespace() {
        return (GdbModelTargetSymbolContainer)this.parent;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public Address getValue() {
        return this.value;
    }

    public long getSize() {
        return this.size;
    }
}

