/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.GdbModule;
import agent.gdb.manager.GdbModuleSection;
import agent.gdb.manager.impl.GdbInferiorImpl;
import agent.gdb.manager.impl.GdbMinimalSymbol;
import agent.gdb.manager.impl.GdbModuleSectionImpl;
import agent.gdb.manager.impl.cmd.GdbConsoleExecCommand;
import ghidra.async.AsyncLazyValue;
import ghidra.async.AsyncUtils;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GdbModuleImpl
implements GdbModule {
    protected static final Pattern OBJECT_FILE_LINE_PATTERN = Pattern.compile("\\s*Object file: (?<name>.*)");
    protected static final Pattern OBJECT_SECTION_LINE_PATTERN_V8 = Pattern.compile("\\s*0x(?<vmaS>[0-9A-Fa-f]+)\\s*->\\s*0x(?<vmaE>[0-9A-Fa-f]+)\\s+at\\s+0x(?<offset>[0-9A-Fa-f]+)\\s*:\\s*(?<name>\\S+)\\s+(?<attrs>.*)");
    protected static final Pattern OBJECT_SECTION_LINE_PATTERN_V10 = Pattern.compile("\\s*\\[\\s*(?<idx>\\d+)\\]\\s+0x(?<vmaS>[0-9A-Fa-f]+)\\s*->\\s*0x(?<vmaE>[0-9A-Fa-f]+)\\s+at\\s+0x(?<offset>[0-9A-Fa-f]+)\\s*:\\s*(?<name>\\S+)\\s+(?<attrs>.*)");
    protected static final Pattern MSYMBOL_LINE_PATTERN = Pattern.compile("\\s*\\[\\s*(?<idx>\\d+)\\]\\s+(?<type>\\S+)\\s+0x(?<addr>[0-9A-Fa-f]+)\\s+(?<name>\\S+)\\s+.*");
    protected final GdbInferiorImpl inferior;
    protected final String name;
    protected Long base = null;
    protected Long max = null;
    protected Pattern sectionLinePattern = OBJECT_SECTION_LINE_PATTERN_V10;
    protected final Map<String, GdbModuleSectionImpl> sections = new LinkedHashMap<String, GdbModuleSectionImpl>();
    protected final Map<String, GdbModuleSection> unmodifiableSections = Collections.unmodifiableMap(this.sections);
    protected final AsyncLazyValue<Void> loadSections = new AsyncLazyValue(this::doLoadSections);
    protected final AsyncLazyValue<Map<String, GdbMinimalSymbol>> minimalSymbols = new AsyncLazyValue(this::doGetMinimalSymbols);

    public GdbModuleImpl(GdbInferiorImpl inferior, String name) {
        this.inferior = inferior;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected CompletableFuture<Void> doLoadSections() {
        return ((CompletableFuture)this.inferior.loadSections().thenCompose(__ -> {
            if (!this.loadSections.isDone()) {
                this.inferior.loadSections.forget();
                return this.inferior.loadSections();
            }
            return AsyncUtils.NIL;
        })).thenAccept(__ -> {
            if (!this.loadSections.isDone()) {
                Msg.warn((Object)this, (Object)("Module's sections still not known: " + this.name + ". Probably got unloaded."));
            }
        });
    }

    @Override
    public CompletableFuture<Long> computeBase() {
        return this.loadSections.request().thenApply(__ -> this.base);
    }

    @Override
    public CompletableFuture<Long> computeMax() {
        return this.loadSections.request().thenApply(__ -> this.max);
    }

    @Override
    public Long getKnownBase() {
        return this.base;
    }

    @Override
    public Long getKnownMax() {
        return this.max;
    }

    @Override
    public CompletableFuture<Map<String, GdbModuleSection>> listSections() {
        return this.loadSections.request().thenApply(__ -> this.unmodifiableSections);
    }

    @Override
    public Map<String, GdbModuleSection> getKnownSections() {
        return this.unmodifiableSections;
    }

    protected CompletableFuture<Map<String, GdbMinimalSymbol>> doGetMinimalSymbols() {
        String cmd = "maintenance print msymbols -objfile " + this.name;
        return this.inferior.consoleCapture(cmd, GdbConsoleExecCommand.CompletesWithRunning.CANNOT).thenApply(out -> {
            LinkedHashMap<String, GdbMinimalSymbol> result = new LinkedHashMap<String, GdbMinimalSymbol>();
            for (String line : out.split("\n")) {
                Matcher mat = MSYMBOL_LINE_PATTERN.matcher(line);
                if (!mat.matches()) continue;
                long index = Long.parseLong(mat.group("idx"));
                String type = Objects.requireNonNull(mat.group("type"));
                long address = Long.parseLong(mat.group("addr"), 16);
                String symName = Objects.requireNonNull(mat.group("name"));
                result.put(symName, new GdbMinimalSymbol(index, type, symName, address));
            }
            return Collections.unmodifiableMap(result);
        });
    }

    @Override
    public CompletableFuture<Map<String, GdbMinimalSymbol>> listMinimalSymbols() {
        return this.minimalSymbols.request();
    }

    protected Matcher matchSectionLine(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            this.sectionLinePattern = pattern;
        }
        return matcher;
    }

    protected Matcher matchSectionLine(String line) {
        Matcher matcher = this.sectionLinePattern.matcher(line);
        if (matcher.matches()) {
            return matcher;
        }
        matcher = this.matchSectionLine(OBJECT_SECTION_LINE_PATTERN_V10, line);
        if (matcher.matches()) {
            return matcher;
        }
        matcher = this.matchSectionLine(OBJECT_SECTION_LINE_PATTERN_V8, line);
        if (matcher.matches()) {
            return matcher;
        }
        return matcher;
    }

    protected void processSectionLine(String line) {
        Matcher matcher = this.matchSectionLine(line);
        if (matcher.matches()) {
            try {
                long vmaStart = Long.parseLong(matcher.group("vmaS"), 16);
                long vmaEnd = Long.parseLong(matcher.group("vmaE"), 16);
                long offset = Long.parseLong(matcher.group("offset"), 16);
                String sectionName = matcher.group("name");
                ArrayList<String> attrs = new ArrayList<String>();
                for (String a : matcher.group("attrs").split("\\s+")) {
                    if (a.length() == 0) continue;
                    attrs.add(a);
                }
                if (attrs.contains("ALLOC")) {
                    long b = vmaStart - offset;
                    this.base = this.base == null ? b : MathUtilities.unsignedMin((long)this.base, (long)b);
                    this.max = this.max == null ? b : MathUtilities.unsignedMax((long)this.max, (long)vmaEnd);
                }
                if (this.sections.put(sectionName, new GdbModuleSectionImpl(sectionName, vmaStart, vmaEnd, offset, attrs)) != null) {
                    Msg.warn((Object)this, (Object)("Duplicate section name: " + line));
                }
            }
            catch (NumberFormatException e) {
                Msg.error((Object)this, (Object)("Invalid number in section entry: " + line));
            }
        }
    }
}

