/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.gadp;

import agent.gdb.GdbCompatibility;
import agent.gdb.gadp.GdbGadpServer;
import ghidra.dbg.gadp.server.AbstractGadpLocalDebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.dbg.util.ShellUtils;
import ghidra.util.classfinder.ExtensionPointProperties;
import java.util.List;

@ConfigurableFactory.FactoryDescription(brief="GNU gdb local agent via GADP/TCP", htmlDetails="Launch a new agent using GDB. This may start a new session or join an existing one.")
@ExtensionPointProperties(priority=100)
public class GdbLocalDebuggerModelFactory
extends AbstractGadpLocalDebuggerModelFactory {
    private String gdbCmd = "/usr/bin/gdb";
    @ConfigurableFactory.FactoryOption(value="GDB launch command")
    public final ConfigurableFactory.Property<String> gdbCommandOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getGdbCommand, this::setGdbCommand);
    private boolean existing = false;
    @ConfigurableFactory.FactoryOption(value="Use existing session via new-ui")
    public final ConfigurableFactory.Property<Boolean> useExistingOption = ConfigurableFactory.Property.fromAccessors(Boolean.TYPE, this::isUseExisting, this::setUseExisting);

    public boolean isCompatible() {
        return GdbCompatibility.INSTANCE.isCompatible(this.gdbCmd);
    }

    public String getGdbCommand() {
        return this.gdbCmd;
    }

    public void setGdbCommand(String gdbCmd) {
        this.gdbCmd = gdbCmd;
    }

    public boolean isUseExisting() {
        return this.existing;
    }

    public void setUseExisting(boolean existing) {
        this.existing = existing;
        this.gdbCommandOption.setEnabled(!existing);
    }

    protected String getThreadName() {
        return "Local gdb Agent stdout";
    }

    protected void completeCommandLine(List<String> cmd) {
        List gdbCmdLine = ShellUtils.parseArgs((String)this.gdbCmd);
        cmd.add(GdbGadpServer.class.getCanonicalName());
        if (!this.existing && gdbCmdLine.size() >= 2) {
            cmd.addAll(gdbCmdLine.subList(1, gdbCmdLine.size()));
        }
        cmd.add("--gadp-args");
        cmd.addAll(List.of("-H", this.host));
        cmd.addAll(List.of("-p", Integer.toString(this.port)));
        if (!this.existing && gdbCmdLine.size() >= 1) {
            cmd.add("-g");
            cmd.add((String)gdbCmdLine.get(0));
        } else {
            cmd.add("-x");
        }
    }
}

