/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.JComponent;

public class JungPickingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected V vertex;
    protected E edge;
    protected double offsetx;
    protected double offsety;
    protected boolean locked;
    protected int addToSelectionModifiers;
    protected Rectangle2D rect = new Rectangle2D.Float();
    protected VisualizationServer.Paintable lensPaintable;
    protected Color lensColor = Color.cyan;

    public JungPickingGraphMousePlugin() {
        this(1024, 1088);
    }

    public JungPickingGraphMousePlugin(int selectionModifiers, int addToSelectionModifiers) {
        super(selectionModifiers);
        this.addToSelectionModifiers = addToSelectionModifiers;
        this.lensPaintable = new LensPaintable();
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public Color getLensColor() {
        return this.lensColor;
    }

    public void setLensColor(Color lensColor) {
        this.lensColor = lensColor;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.down = e.getPoint();
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        PickedState pickedVertexState = vv.getPickedVertexState();
        PickedState pickedEdgeState = vv.getPickedEdgeState();
        if (pickSupport != null && pickedVertexState != null) {
            Layout layout = vv.getGraphLayout();
            if (e.getModifiersEx() == this.modifiers) {
                this.rect.setFrameFromDiagonal(this.down, this.down);
                Point ip = e.getPoint();
                this.vertex = pickSupport.getVertex(layout, ((Point2D)ip).getX(), ((Point2D)ip).getY());
                if (this.vertex != null) {
                    if (!pickedVertexState.isPicked(this.vertex)) {
                        pickedVertexState.clear();
                        pickedVertexState.pick(this.vertex, true);
                    }
                    Point2D q = (Point2D)layout.apply(this.vertex);
                    Point2D gp = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.LAYOUT, (Point2D)ip);
                    this.offsetx = (float)(gp.getX() - q.getX());
                    this.offsety = (float)(gp.getY() - q.getY());
                } else {
                    this.edge = pickSupport.getEdge(layout, ((Point2D)ip).getX(), ((Point2D)ip).getY());
                    if (this.edge != null) {
                        pickedEdgeState.clear();
                        pickedEdgeState.pick(this.edge, true);
                    } else {
                        vv.addPostRenderPaintable(this.lensPaintable);
                        pickedEdgeState.clear();
                        pickedVertexState.clear();
                    }
                }
            } else if (e.getModifiersEx() == this.addToSelectionModifiers) {
                vv.addPostRenderPaintable(this.lensPaintable);
                this.rect.setFrameFromDiagonal(this.down, this.down);
                Point ip = e.getPoint();
                this.vertex = pickSupport.getVertex(layout, ((Point2D)ip).getX(), ((Point2D)ip).getY());
                if (this.vertex != null) {
                    boolean wasThere = pickedVertexState.pick(this.vertex, !pickedVertexState.isPicked(this.vertex));
                    if (wasThere) {
                        this.vertex = null;
                    } else {
                        Point2D q = (Point2D)layout.apply(this.vertex);
                        Point2D gp = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.LAYOUT, (Point2D)ip);
                        this.offsetx = (float)(gp.getX() - q.getX());
                        this.offsety = (float)(gp.getY() - q.getY());
                    }
                } else {
                    this.edge = pickSupport.getEdge(layout, ((Point2D)ip).getX(), ((Point2D)ip).getY());
                    if (this.edge != null) {
                        pickedEdgeState.pick(this.edge, !pickedEdgeState.isPicked(this.edge));
                    }
                }
            }
        }
        if (this.vertex != null) {
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        if (e.getModifiersEx() == this.addToSelectionModifiers) {
            if (this.down != null) {
                Point out = e.getPoint();
                if (this.vertex == null && !this.heyThatsTooClose(this.down, out, 5.0)) {
                    this.pickContainedVertices(vv, this.down, out, false);
                }
            }
        } else if (this.down != null) {
            Point out = e.getPoint();
            if (this.vertex == null && !this.heyThatsTooClose(this.down, out, 5.0)) {
                this.pickContainedVertices(vv, this.down, out, true);
            }
        }
        this.down = null;
        this.vertex = null;
        this.edge = null;
        this.rect.setFrame(0.0, 0.0, 0.0, 0.0);
        vv.removePostRenderPaintable(this.lensPaintable);
        vv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.locked) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (this.vertex != null) {
                Point p = e.getPoint();
                Point2D graphPoint = vv.getRenderContext().getMultiLayerTransformer().inverseTransform((Point2D)p);
                Point2D graphDown = vv.getRenderContext().getMultiLayerTransformer().inverseTransform((Point2D)this.down);
                Layout layout = vv.getGraphLayout();
                double dx = graphPoint.getX() - graphDown.getX();
                double dy = graphPoint.getY() - graphDown.getY();
                PickedState ps = vv.getPickedVertexState();
                for (Object v : ps.getPicked()) {
                    Point2D vp = (Point2D)layout.apply(v);
                    vp.setLocation(vp.getX() + dx, vp.getY() + dy);
                    layout.setLocation(v, vp);
                }
                this.down = p;
            } else {
                Point out = e.getPoint();
                if (e.getModifiersEx() == this.addToSelectionModifiers || e.getModifiersEx() == this.modifiers) {
                    this.rect.setFrameFromDiagonal(this.down, out);
                }
            }
            if (this.vertex != null) {
                e.consume();
            }
            vv.repaint();
        }
    }

    private boolean heyThatsTooClose(Point2D p, Point2D q, double min) {
        return Math.abs(p.getX() - q.getX()) < min && Math.abs(p.getY() - q.getY()) < min;
    }

    protected void pickContainedVertices(VisualizationViewer<V, E> vv, Point2D down, Point2D out, boolean clear) {
        Layout layout = vv.getGraphLayout();
        PickedState pickedVertexState = vv.getPickedVertexState();
        Rectangle2D.Double pickRectangle = new Rectangle2D.Double();
        pickRectangle.setFrameFromDiagonal(down, out);
        if (pickedVertexState != null) {
            if (clear) {
                pickedVertexState.clear();
            }
            GraphElementAccessor pickSupport = vv.getPickSupport();
            Collection picked = pickSupport.getVertices(layout, (Shape)pickRectangle);
            for (Object v : picked) {
                pickedVertexState.pick(v, true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    class LensPaintable
    implements VisualizationServer.Paintable {
        LensPaintable() {
        }

        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(JungPickingGraphMousePlugin.this.lensColor);
            ((Graphics2D)g).draw(JungPickingGraphMousePlugin.this.rect);
            g.setColor(oldColor);
        }

        public boolean useTransform() {
            return false;
        }
    }
}

