/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.local.IndexedLocalFileSystem;
import ghidra.framework.store.local.IndexedV1LocalFileSystem;
import ghidra.framework.store.local.MangledLocalFileSystem;
import java.io.File;
import java.io.IOException;

public class LocalFilesystemTestUtils {
    private LocalFilesystemTestUtils() {
    }

    public static MangledLocalFileSystem createMangledFilesystem(String rootPath, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching) throws IOException {
        LocalFilesystemTestUtils.createRootDir(rootPath);
        return new MangledLocalFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching);
    }

    public static IndexedLocalFileSystem createOriginalIndexedFilesystem(String rootPath, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching) throws IOException {
        LocalFilesystemTestUtils.createRootDir(rootPath);
        return null;
    }

    public static IndexedLocalFileSystem createIndexedV0Filesystem(String rootPath, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching) throws IOException {
        LocalFilesystemTestUtils.createRootDir(rootPath);
        return new IndexedLocalFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching, true);
    }

    public static IndexedV1LocalFileSystem createIndexedV1Filesystem(String rootPath, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching) throws IOException {
        LocalFilesystemTestUtils.createRootDir(rootPath);
        return new IndexedV1LocalFileSystem(rootPath, isVersioned, readOnly, enableAsyncronousDispatching, true);
    }

    private static void createRootDir(String rootPath) throws IOException {
        File dir = new File(rootPath);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Failed to create root directory: " + dir);
        }
    }
}

