/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocationComparator;
import ghidra.program.util.ProgramUtilities;
import ghidra.util.Msg;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class ProgramLocation
implements Comparable<ProgramLocation> {
    protected Program program;
    protected Address addr;
    protected Address refAddr;
    private int[] componentPath;
    private Address byteAddr;
    private int row;
    private int col;
    private int charOffset;

    public ProgramLocation(Program program, Address addr, Address byteAddr, int[] componentPath, Address refAddr, int row, int col, int charOffset) {
        NullPointerException exc;
        if (program == null) {
            exc = new NullPointerException("Null program passed to ProgramLocation");
            ProgramLocation.showException(exc);
        }
        if (addr == null) {
            exc = new NullPointerException("Null address passed to ProgramLocation");
            ProgramLocation.showException(exc);
        }
        this.program = program;
        this.addr = addr;
        this.byteAddr = byteAddr;
        this.refAddr = refAddr;
        this.row = row;
        this.col = col;
        this.charOffset = charOffset;
        this.componentPath = componentPath;
    }

    public ProgramLocation(Program program, Address addr, int[] componentPath, Address refAddr, int row, int col, int charOffset) {
        this(program, ProgramLocation.getCodeUnitAddress(program, addr), addr, componentPath, refAddr, row, col, charOffset);
    }

    public ProgramLocation(Program program, Address addr) {
        this(program, ProgramLocation.getCodeUnitAddress(program, addr), addr, null, null, 0, 0, 0);
    }

    public ProgramLocation(Program program, Address addr, int row, int col, int charOffset) {
        this(program, ProgramLocation.getCodeUnitAddress(program, addr), addr, null, null, row, col, charOffset);
    }

    public ProgramLocation(Program program, Address addr, Address refAddr) {
        this(program, ProgramLocation.getCodeUnitAddress(program, addr), addr, null, refAddr, 0, 0, 0);
    }

    public ProgramLocation() {
    }

    public int[] getComponentPath() {
        return this.componentPath;
    }

    public Program getProgram() {
        return this.program;
    }

    public Address getAddress() {
        return this.addr;
    }

    public Address getByteAddress() {
        return this.byteAddr;
    }

    public Address getRefAddress() {
        return this.refAddr;
    }

    public void saveState(SaveState obj) {
        obj.putString("_CLASSNAME", this.getClass().getName());
        obj.putString("_ADDRESS", this.addr.toString());
        obj.putString("_BYTE_ADDR", this.byteAddr.toString());
        if (this.refAddr != null) {
            obj.putString("_REF_ADDRESS", this.refAddr.toString());
        }
        if (this.componentPath != null) {
            obj.putInts("_COMP_PATH", this.componentPath);
        }
        obj.putInt("_COLUMN", this.col);
        obj.putInt("_ROW", this.row);
        obj.putInt("_CHAR_OFFSET", this.charOffset);
    }

    public void restoreState(Program program1, SaveState obj) {
        this.program = program1;
        String addrStr = obj.getString("_ADDRESS", "0");
        String byteAddrStr = obj.getString("_BYTE_ADDR", addrStr);
        String refAddrStr = obj.getString("_REF_ADDRESS", null);
        this.componentPath = obj.getInts("_COMP_PATH", null);
        this.addr = ProgramUtilities.parseAddress(program1, addrStr);
        this.byteAddr = ProgramUtilities.parseAddress(program1, byteAddrStr);
        if (refAddrStr != null) {
            this.refAddr = ProgramUtilities.parseAddress(program1, refAddrStr);
        }
        this.col = obj.getInt("_COLUMN", 0);
        this.row = obj.getInt("_ROW", 0);
        this.charOffset = obj.getInt("_CHAR_OFFSET", 0);
    }

    public static ProgramLocation getLocation(Program program, SaveState saveState) {
        String className = saveState.getString("_CLASSNAME", null);
        if (className == null) {
            return null;
        }
        try {
            Class<?> locClass = Class.forName(className);
            ProgramLocation loc = (ProgramLocation)locClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            loc.restoreState(program, saveState);
            if (loc.getAddress() != null) {
                return loc;
            }
        }
        catch (RuntimeException locClass) {
        }
        catch (ClassNotFoundException locClass) {
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            Msg.showError(ProgramLocation.class, null, (String)"Programming Error", (Object)("Class " + className + " must have public default constructor!"), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Msg.showError(ProgramLocation.class, null, (String)"Programming Error", (Object)("Class " + className + " default constructor threw an exception!"), (Throwable)e);
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.program, this.addr);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('@');
        buf.append(this.addr.toString());
        if (!this.addr.equals(this.byteAddr)) {
            buf.append(", byteAddr=");
            buf.append(this.byteAddr.toString());
        }
        if (this.refAddr != null) {
            buf.append(", refAddr=");
            buf.append(this.refAddr.toString());
        }
        if (this.componentPath != null && this.componentPath.length != 0) {
            buf.append(", componentPath=");
            for (int i = 0; i < this.componentPath.length; ++i) {
                if (i != 0) {
                    buf.append(':');
                }
                buf.append(Integer.toString(this.componentPath[i]));
            }
        }
        buf.append(", row=");
        buf.append(this.row);
        buf.append(", col=");
        buf.append(this.col);
        buf.append(", charOffset=");
        buf.append(this.charOffset);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgramLocation other = (ProgramLocation)obj;
        if (this.program != other.program) {
            return false;
        }
        if (ProgramLocation.compareAddr(this.addr, other.addr) != 0) {
            return false;
        }
        if (ProgramLocation.compareAddr(this.refAddr, other.refAddr) != 0) {
            return false;
        }
        if (ProgramLocation.compareAddr(this.byteAddr, other.byteAddr) != 0) {
            return false;
        }
        if (!this.checkComponentPath(this.componentPath, other.componentPath)) {
            return false;
        }
        return this.row == other.row && this.col == other.col && this.charOffset == other.charOffset;
    }

    @Override
    public int compareTo(ProgramLocation other) {
        if (other == this) {
            return 0;
        }
        int result = ProgramLocationComparator.INSTANCE.compare(this, other);
        if (result == 0 && (result = this.row - other.row) == 0 && (result = this.col - other.col) == 0) {
            result = this.charOffset - other.charOffset;
        }
        return result;
    }

    private boolean checkComponentPath(int[] p1, int[] p2) {
        if (p1 == null) {
            return p2 == null || p2.length == 0;
        }
        if (p2 == null) {
            return p1.length == 0;
        }
        if (p1.length != p2.length) {
            return false;
        }
        for (int i = 0; i < p1.length; ++i) {
            if (p1[i] == p2[i]) continue;
            return false;
        }
        return true;
    }

    protected static int compareAddr(Address addr1, Address addr2) {
        if (addr1 == null) {
            if (addr2 == null) {
                return 0;
            }
            return -1;
        }
        if (addr2 == null) {
            return 1;
        }
        return addr1.compareTo(addr2);
    }

    private static Address getCodeUnitAddress(Program p, Address addr) {
        if (addr == null) {
            NullPointerException exc = new NullPointerException("Null address passed to ProgramLocation");
            ProgramLocation.showException(exc);
        }
        if (p == null) {
            return addr;
        }
        CodeUnit cu = p.getListing().getCodeUnitContaining(addr);
        if (cu instanceof Data) {
            Data data = (Data)cu;
            cu = data.getPrimitiveAt((int)addr.subtract(data.getAddress()));
        }
        if (cu != null) {
            return cu.getMinAddress();
        }
        return addr;
    }

    private static void showException(Exception exception) {
        Msg.showError(ProgramLocation.class, null, (String)exception.getMessage(), (Object)(exception.getMessage() + ".  Trace and remove this problem"), (Throwable)exception);
    }

    public boolean isValid(Program testProgram) {
        return this.addr == null || testProgram.getAddressFactory().isValidAddress(this.addr);
    }

    public int getRow() {
        return this.row;
    }

    public int getCharOffset() {
        return this.charOffset;
    }

    public int getColumn() {
        return this.col;
    }
}

