/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;
import java.util.Arrays;

public class CommentFieldLocation
extends CodeUnitLocation {
    protected String[] comment;
    protected int type;

    public CommentFieldLocation(Program program, Address addr, int[] componentPath, String[] comment, int type, int row, int charOffset) {
        super(program, addr, componentPath, row, 0, charOffset);
        this.comment = comment;
        if (comment == null) {
            this.comment = new String[0];
        }
        this.type = type;
    }

    public CommentFieldLocation() {
    }

    protected void validateType() {
        if (this.type != 1 && this.type != 2 && this.type != 0 && this.type != 4 && this.type != 3 && this.type != -1) {
            throw new IllegalArgumentException("The comment type was " + this.type + ", but it must be from 0 to 4");
        }
    }

    public String[] getComment() {
        return this.comment;
    }

    public int getCommentType() {
        return this.type;
    }

    @Override
    public String toString() {
        return super.toString() + ", Comment Type = " + this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.comment);
        result = 31 * result + this.type;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommentFieldLocation other = (CommentFieldLocation)obj;
        if (!Arrays.equals(this.comment, other.comment)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putStrings("_COMMENT", this.comment);
        obj.putInt("_TYPE", this.type);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.comment = obj.getStrings("_COMMENT", new String[0]);
        this.type = obj.getInt("_TYPE", 0);
    }
}

