/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class JumpTable {
    private AddressSpace preferredSpace;
    private Address opAddress;
    private Address[] addressTable;
    private Integer[] labelTable;
    private LoadTable[] loadTable;
    private BasicOverride override;

    private Address translateOverlayAddress(Address addr) {
        if (addr != null && this.preferredSpace.isOverlaySpace()) {
            OverlayAddressSpace overlaySpace = (OverlayAddressSpace)this.preferredSpace;
            return overlaySpace.getOverlayAddress(addr);
        }
        return addr;
    }

    public JumpTable(AddressSpace preferredSpace) {
        this.preferredSpace = preferredSpace;
        this.opAddress = null;
        this.addressTable = null;
        this.labelTable = null;
        this.loadTable = null;
        this.override = null;
    }

    public JumpTable(Address addr, ArrayList<Address> destlist, boolean override) {
        this.opAddress = addr;
        this.preferredSpace = this.opAddress.getAddressSpace();
        this.labelTable = null;
        this.loadTable = null;
        if (override) {
            this.addressTable = null;
            this.override = new BasicOverride(destlist);
        } else {
            this.addressTable = new Address[destlist.size()];
            destlist.toArray(this.addressTable);
            this.override = null;
        }
    }

    public boolean isEmpty() {
        if (this.addressTable == null) {
            return true;
        }
        return this.addressTable.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreXml(XmlPullParser parser, AddressFactory addrFactory) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"jumptable"});
        try {
            ArrayList<Address> aTable = new ArrayList<Address>();
            ArrayList<Integer> lTable = new ArrayList<Integer>();
            ArrayList<LoadTable> ldTable = new ArrayList<LoadTable>();
            if (!parser.peek().isStart()) {
                return;
            }
            XmlElement addrel = parser.start(new String[]{"addr"});
            Address switchAddr = this.translateOverlayAddress(AddressXML.readXML(addrel, addrFactory));
            parser.end(addrel);
            while (parser.peek().isStart()) {
                if (parser.peek().getName().equals("dest")) {
                    XmlElement subel = parser.start(new String[]{"dest"});
                    Address caseAddr = this.translateOverlayAddress(AddressXML.readXML(subel, addrFactory));
                    aTable.add(caseAddr);
                    String slabel = subel.getAttribute("label");
                    if (slabel != null) {
                        int label = SpecXmlUtils.decodeInt((String)slabel);
                        lTable.add(label);
                    }
                    parser.end(subel);
                    continue;
                }
                if (parser.peek().getName().equals("loadtable")) {
                    LoadTable loadtable = new LoadTable();
                    loadtable.restoreXml(parser, addrFactory);
                    ldTable.add(loadtable);
                    continue;
                }
                parser.discardSubTree();
            }
            this.opAddress = switchAddr;
            this.addressTable = new Address[aTable.size()];
            aTable.toArray(this.addressTable);
            this.labelTable = new Integer[lTable.size()];
            lTable.toArray(this.labelTable);
            this.loadTable = new LoadTable[ldTable.size()];
            ldTable.toArray(this.loadTable);
        }
        finally {
            parser.end(el);
        }
    }

    public void buildXml(StringBuilder buf) {
        buf.append("<jumptable>\n");
        AddressXML.buildXML(buf, this.opAddress);
        buf.append('\n');
        if (this.addressTable != null) {
            for (Address element : this.addressTable) {
                buf.append("<dest");
                AddressXML.appendAttributes(buf, element);
                buf.append("/>\n");
            }
        }
        if (this.override != null) {
            this.override.buildXml(buf);
        }
        buf.append("</jumptable>\n");
    }

    public Address getSwitchAddress() {
        return this.opAddress;
    }

    public Address[] getCases() {
        return (Address[])this.addressTable.clone();
    }

    public Integer[] getLabelValues() {
        return (Integer[])this.labelTable.clone();
    }

    public LoadTable[] getLoadTables() {
        return (LoadTable[])this.loadTable.clone();
    }

    public void writeOverride(Function func) throws InvalidInputException {
        if (this.override == null) {
            throw new InvalidInputException("Jumptable is not an override");
        }
        Address[] destlist = this.override.getDestinations();
        if (destlist.length == 0) {
            throw new InvalidInputException("Jumptable has no destinations");
        }
        if (!func.getBody().contains(this.opAddress)) {
            throw new InvalidInputException("Switch is not in function body");
        }
        Program program = func.getProgram();
        SymbolTable symtab = program.getSymbolTable();
        Namespace space = HighFunction.findCreateOverrideSpace(func);
        if (space == null) {
            throw new InvalidInputException("Could not create \"override\" namespace");
        }
        if (!HighFunction.clearNamespace(symtab, space = HighFunction.findCreateNamespace(symtab, space, "jmp_" + this.opAddress.toString()))) {
            throw new InvalidInputException("Jumptable override namespace contains non-label symbols.");
        }
        HighFunction.createLabelSymbol(symtab, this.opAddress, "switch", space, SourceType.USER_DEFINED, false);
        for (int i = 0; i < destlist.length; ++i) {
            String nm = "case_" + Integer.toString(i);
            HighFunction.createLabelSymbol(symtab, destlist[i], nm, space, SourceType.USER_DEFINED, false);
        }
    }

    public static JumpTable readOverride(Namespace space, SymbolTable symtab) {
        Address branchind = null;
        ArrayList<Address> destlist = new ArrayList<Address>();
        SymbolIterator iter = symtab.getSymbols(space);
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (!(sym instanceof CodeSymbol)) continue;
            Address addr = sym.getAddress();
            if (sym.getName().equals("switch")) {
                branchind = addr;
                continue;
            }
            if (!sym.getName().startsWith("case")) continue;
            destlist.add(addr);
        }
        if (branchind != null && destlist.size() > 0) {
            return new JumpTable(branchind, destlist, true);
        }
        return null;
    }

    public class BasicOverride {
        private Address[] destlist;

        public BasicOverride(ArrayList<Address> dlist) {
            this.destlist = new Address[dlist.size()];
            dlist.toArray(this.destlist);
        }

        public Address[] getDestinations() {
            return this.destlist;
        }

        public void buildXml(StringBuilder buf) {
            buf.append("<basicoverride>\n");
            for (Address element : this.destlist) {
                buf.append("<dest");
                AddressXML.appendAttributes(buf, element);
                buf.append("/>\n");
            }
            buf.append("</basicoverride>\n");
        }
    }

    public class LoadTable {
        Address addr;
        int size;
        int num;

        LoadTable() {
        }

        public Address getAddress() {
            return this.addr;
        }

        public int getSize() {
            return this.size;
        }

        public int getNum() {
            return this.num;
        }

        public void restoreXml(XmlPullParser parser, AddressFactory addrFactory) {
            XmlElement el = parser.start(new String[]{"loadtable"});
            this.size = SpecXmlUtils.decodeInt((String)el.getAttribute("size"));
            this.num = SpecXmlUtils.decodeInt((String)el.getAttribute("num"));
            XmlElement subel = parser.start(new String[]{"addr"});
            this.addr = JumpTable.this.translateOverlayAddress(AddressXML.readXML(subel, addrFactory));
            parser.end(subel);
            parser.end(el);
        }
    }
}

