/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBBuffer;
import db.DBHandle;
import db.DBRecord;
import db.Schema;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapterV0;
import ghidra.program.database.mem.MemoryMapDBAdapterV1;
import ghidra.program.database.mem.MemoryMapDBAdapterV2;
import ghidra.program.database.mem.MemoryMapDBAdapterV3;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

abstract class MemoryMapDBAdapter {
    static Schema BLOCK_SCHEMA = MemoryMapDBAdapterV3.V3_BLOCK_SCHEMA;
    static Schema SUB_BLOCK_SCHEMA = MemoryMapDBAdapterV3.V3_SUB_BLOCK_SCHEMA;
    static final int NAME_COL = 0;
    static final int COMMENTS_COL = 1;
    static final int SOURCE_COL = 2;
    static final int PERMISSIONS_COL = 3;
    static final int START_ADDR_COL = 4;
    static final int LENGTH_COL = 5;
    static final int SEGMENT_COL = 6;
    static final int SUB_PARENT_ID_COL = 0;
    static final int SUB_TYPE_COL = 1;
    static final int SUB_LENGTH_COL = 2;
    static final int SUB_START_OFFSET_COL = 3;
    static final int SUB_INT_DATA1_COL = 4;
    static final int SUB_LONG_DATA2_COL = 5;
    static final byte SUB_TYPE_BIT_MAPPED = 0;
    static final byte SUB_TYPE_BYTE_MAPPED = 1;
    static final byte SUB_TYPE_BUFFER = 2;
    static final byte SUB_TYPE_UNITIALIZED = 3;
    static final byte SUB_TYPE_FILE_BYTES = 4;

    MemoryMapDBAdapter() {
    }

    static MemoryMapDBAdapter getAdapter(DBHandle handle, int openMode, MemoryMapDB memMap, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new MemoryMapDBAdapterV3(handle, memMap, 0x40000000L, true);
        }
        try {
            return new MemoryMapDBAdapterV3(handle, memMap, 0x40000000L, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            MemoryMapDBAdapter adapter = MemoryMapDBAdapter.findReadOnlyAdapter(handle, memMap);
            if (openMode == 3) {
                adapter = MemoryMapDBAdapter.upgrade(handle, adapter, memMap, monitor);
            }
            return adapter;
        }
    }

    static MemoryMapDBAdapter findReadOnlyAdapter(DBHandle handle, MemoryMapDB memMap) throws VersionException, IOException {
        try {
            return new MemoryMapDBAdapterV2(handle, memMap);
        }
        catch (VersionException versionException) {
            try {
                return new MemoryMapDBAdapterV1(handle, memMap);
            }
            catch (VersionException versionException2) {
                return new MemoryMapDBAdapterV0(handle, memMap);
            }
        }
    }

    static MemoryMapDBAdapter upgrade(DBHandle handle, MemoryMapDBAdapter oldAdapter, MemoryMapDB memMap, TaskMonitor monitor) throws VersionException, IOException {
        try {
            monitor.setMessage("Upgrading Memory Blocks...");
            List<MemoryBlockDB> blocks = oldAdapter.getMemoryBlocks();
            oldAdapter.deleteTable(handle);
            monitor.initialize((long)(blocks.size() * 2));
            MemoryMapDBAdapterV3 newAdapter = new MemoryMapDBAdapterV3(handle, memMap, 0x40000000L, true);
            for (MemoryBlockDB block : blocks) {
                MemoryBlockDB newBlock = null;
                if (block.isInitialized()) {
                    DBBuffer buf = block.getBuffer();
                    newBlock = ((MemoryMapDBAdapter)newAdapter).createInitializedBlock(block.getName(), block.getStart(), buf, block.getPermissions());
                } else {
                    Address mappedAddress = null;
                    if (block.isMapped()) {
                        MemoryBlockSourceInfo info = block.getSourceInfos().get(0);
                        mappedAddress = info.getMappedRange().get().getMinAddress();
                    }
                    newBlock = ((MemoryMapDBAdapter)newAdapter).createBlock(block.getType(), block.getName(), block.getStart(), block.getSize(), mappedAddress, false, block.getPermissions(), 0);
                }
                newBlock.setComment(block.getComment());
                newBlock.setSourceName(block.getSourceName());
            }
            ((MemoryMapDBAdapter)newAdapter).refreshMemory();
            return newAdapter;
        }
        catch (AddressOverflowException e) {
            throw new AssertException((Throwable)((Object)e));
        }
    }

    abstract DBBuffer getBuffer(int var1) throws IOException;

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract void refreshMemory() throws IOException;

    abstract List<MemoryBlockDB> getMemoryBlocks();

    abstract MemoryBlockDB createInitializedBlock(String var1, Address var2, InputStream var3, long var4, int var6) throws AddressOverflowException, IOException;

    abstract MemoryBlockDB createInitializedBlock(String var1, Address var2, DBBuffer var3, int var4) throws AddressOverflowException, IOException;

    abstract MemoryBlockDB createBlock(MemoryBlockType var1, String var2, Address var3, long var4, Address var6, boolean var7, int var8, int var9) throws AddressOverflowException, IOException;

    abstract void deleteMemoryBlock(long var1) throws IOException;

    abstract void updateBlockRecord(DBRecord var1) throws IOException;

    abstract DBBuffer createBuffer(int var1, byte var2) throws IOException;

    abstract MemoryMapDB getMemoryMap();

    abstract void deleteSubBlock(long var1) throws IOException;

    protected abstract void updateSubBlockRecord(DBRecord var1) throws IOException;

    abstract DBRecord createSubBlockRecord(long var1, long var3, long var5, byte var7, int var8, long var9) throws IOException;

    protected abstract MemoryBlockDB createBlock(String var1, Address var2, long var3, int var5, List<SubMemoryBlock> var6) throws IOException;

    protected abstract MemoryBlockDB createFileBytesBlock(String var1, Address var2, long var3, FileBytes var5, long var6, int var8) throws IOException, AddressOverflowException;
}

