/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.RecordTranslator;
import db.Schema;
import ghidra.program.database.data.EnumValueDBAdapterNoTable;
import ghidra.program.database.data.EnumValueDBAdapterV0;
import ghidra.program.database.data.EnumValueDBAdapterV1;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class EnumValueDBAdapter
implements RecordTranslator {
    static final String ENUM_VALUE_TABLE_NAME = "Enumeration Values";
    static final Schema ENUM_VALUE_SCHEMA = EnumValueDBAdapterV1.SCHEMA;
    static final int ENUMVAL_NAME_COL = 0;
    static final int ENUMVAL_VALUE_COL = 1;
    static final int ENUMVAL_ID_COL = 2;
    static final int ENUMVAL_COMMENT_COL = 3;

    EnumValueDBAdapter() {
    }

    static EnumValueDBAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new EnumValueDBAdapterV1(handle, true);
        }
        try {
            return new EnumValueDBAdapterV1(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            EnumValueDBAdapter adapter = EnumValueDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = EnumValueDBAdapter.upgrade(handle, adapter);
            }
            return adapter;
        }
    }

    static EnumValueDBAdapter findReadOnlyAdapter(DBHandle handle) {
        try {
            return new EnumValueDBAdapterV0(handle);
        }
        catch (VersionException e) {
            return new EnumValueDBAdapterNoTable(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EnumValueDBAdapter upgrade(DBHandle handle, EnumValueDBAdapter oldAdapter) throws VersionException, IOException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        EnumValueDBAdapterV1 tmpAdapter = null;
        try {
            tmpAdapter = new EnumValueDBAdapterV1(tmpHandle, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                ((EnumValueDBAdapter)tmpAdapter).updateRecord(rec);
            }
            oldAdapter.deleteTable(handle);
            EnumValueDBAdapterV1 newAdapter = new EnumValueDBAdapterV1(handle, true);
            it = ((EnumValueDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                ((EnumValueDBAdapter)newAdapter).updateRecord(rec);
            }
            EnumValueDBAdapterV1 enumValueDBAdapterV1 = newAdapter;
            return enumValueDBAdapterV1;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract void createRecord(long var1, String var3, long var4, String var6) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(ENUM_VALUE_TABLE_NAME);
    }

    abstract void removeRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract Field[] getValueIdsInEnum(long var1) throws IOException;
}

