/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class SleighSymbol
implements Comparable<SleighSymbol> {
    private String name;
    int id;
    int scopeid;
    private boolean wasSought = false;
    public final Location location;

    public String toString() {
        return this.name;
    }

    public String toDetailedString() {
        return this.name + "-" + this.scopeid + ":" + this.id;
    }

    public void setWasSought(boolean wasSought) {
        this.wasSought = wasSought;
    }

    public boolean wasSought() {
        return this.wasSought;
    }

    public SleighSymbol(Location location) {
        this.location = location;
    }

    public SleighSymbol(Location location, String nm) {
        this.location = location;
        this.name = nm;
        this.id = 0;
    }

    public void dispose() {
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public symbol_type getType() {
        return symbol_type.dummy_symbol;
    }

    public void saveXml(PrintStream s) {
    }

    public void restoreXml(Element el, SleighBase trans) {
    }

    protected final void saveSleighSymbolXmlHeader(PrintStream s) {
        s.append(" name=\"").append(this.name).append("\"");
        s.append(" id=\"0x").print(Long.toHexString(this.id));
        s.append("\"");
        s.append(" scope=\"0x");
        s.print(Long.toHexString(this.scopeid));
        s.append("\"");
    }

    protected void saveXmlHeader(PrintStream s) {
        this.saveSleighSymbolXmlHeader(s);
    }

    void restoreXmlHeader(Element el) {
        this.name = el.getAttributeValue("name");
        this.id = XmlUtils.decodeUnknownInt(el.getAttributeValue("id"));
        this.scopeid = XmlUtils.decodeUnknownInt(el.getAttributeValue("scope"));
    }

    @Override
    public int compareTo(SleighSymbol o) {
        return this.id - o.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
    }
}

