/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler;

import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.AssemblerBuilder;
import ghidra.app.plugin.assembler.AssemblySelector;
import ghidra.app.plugin.assembler.sleigh.SleighAssemblerBuilder;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import java.util.HashMap;
import java.util.Map;

public final class Assemblers {
    private static Map<LanguageID, AssemblerBuilder> builders = new HashMap<LanguageID, AssemblerBuilder>();

    protected static AssemblerBuilder getBuilderForLang(Language lang) {
        AssemblerBuilder ab = builders.get(lang.getLanguageID());
        if (ab != null) {
            return ab;
        }
        if (lang instanceof SleighLanguage) {
            ab = new SleighAssemblerBuilder((SleighLanguage)lang);
            builders.put(lang.getLanguageID(), ab);
            return ab;
        }
        throw new UnsupportedOperationException("Unsupported language type: " + lang.getClass());
    }

    public static Assembler getAssembler(Program program, AssemblySelector selector) {
        AssemblerBuilder b = Assemblers.getBuilderForLang(program.getLanguage());
        return b.getAssembler(selector, program);
    }

    public static Assembler getAssembler(Language lang, AssemblySelector selector) {
        AssemblerBuilder b = Assemblers.getBuilderForLang(lang);
        return b.getAssembler(selector);
    }

    public static Assembler getAssembler(Program program) {
        return Assemblers.getAssembler(program, new AssemblySelector());
    }

    public static Assembler getAssembler(Language lang) {
        return Assemblers.getAssembler(lang, new AssemblySelector());
    }
}

