/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.dbgeng;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.impl.dbgeng.client.DebugClientInternal;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import ghidra.util.Msg;
import java.lang.ref.Cleaner;

public class DbgEng {
    private static final Cleaner CLEANER = Cleaner.create();

    public static OpaqueCleanable releaseWhenPhantom(Object owner, IUnknown obj) {
        ReleaseCOMObject state = new ReleaseCOMObject(obj);
        return new OpaqueCleanable(state, CLEANER.register(owner, state));
    }

    public static OpaqueCleanable releaseWhenPhantom(Object owner, WinNT.HANDLE handle) {
        ReleaseHANDLE state = new ReleaseHANDLE(handle);
        return new OpaqueCleanable(state, CLEANER.register(owner, state));
    }

    public static DebugClient debugConnect(String remoteOptions) {
        WString options = new WString(remoteOptions);
        return DebugClientInternal.tryPreferredInterfaces((refiid, ppClient) -> DbgEngNative.INSTANCE.DebugConnectWide(options, refiid, ppClient));
    }

    public static DebugClient debugCreate() {
        return DebugClientInternal.tryPreferredInterfaces(DbgEngNative.INSTANCE::DebugCreate);
    }

    public static DebugClient debugCreate(int options) {
        WinDef.DWORD dwOpts = new WinDef.DWORD((long)options);
        return DebugClientInternal.tryPreferredInterfaces((refiid, ppClient) -> DbgEngNative.INSTANCE.DebugCreateEx(refiid, dwOpts, ppClient));
    }

    public static class OpaqueCleanable {
        private final Object state;
        private final Cleaner.Cleanable cleanable;

        public OpaqueCleanable(Object state, Cleaner.Cleanable cleanable) {
            this.state = state;
            this.cleanable = cleanable;
        }
    }

    private static class ReleaseHANDLE
    implements Runnable {
        private final WinNT.HANDLE handle;

        public ReleaseHANDLE(WinNT.HANDLE handle) {
            this.handle = handle;
        }

        @Override
        public void run() {
            Kernel32Util.closeHandle((WinNT.HANDLE)this.handle);
        }
    }

    private static class ReleaseCOMObject
    implements Runnable {
        private final IUnknown obj;

        ReleaseCOMObject(IUnknown obj) {
            this.obj = obj;
        }

        @Override
        public void run() {
            Msg.debug((Object)this, (Object)("Releasing COM object: " + this.obj));
            this.obj.Release();
        }
    }
}

