/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ext4.Ext4Extent;
import ghidra.file.formats.ext4.Ext4ExtentHeader;
import ghidra.file.formats.ext4.Ext4ExtentIdx;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Ext4IBlock
implements StructConverter {
    private Ext4ExtentHeader header;
    private List<Ext4ExtentIdx> indexEntries;
    private List<Ext4Extent> extentEntries;
    private byte[] extra;
    private boolean isExtentTree;

    public static Ext4IBlock readIBlockWithExtents(ByteProvider provider, long offset) throws IOException {
        BinaryReader reader = new BinaryReader(provider, true);
        reader.setPointerIndex(offset);
        return new Ext4IBlock(reader, true);
    }

    public Ext4IBlock(ByteProvider provider, boolean isExtentTree) throws IOException {
        this(new BinaryReader(provider, true), isExtentTree);
    }

    public Ext4IBlock(BinaryReader reader, boolean isExtentTree) throws IOException {
        int extraBytes;
        this.isExtentTree = isExtentTree;
        int count = 0;
        if (isExtentTree) {
            boolean isIdxEntries;
            this.header = new Ext4ExtentHeader(reader);
            ++count;
            int numEntries = this.header.getEh_entries();
            boolean bl = isIdxEntries = this.header.getEh_depth() > 0;
            if (isIdxEntries) {
                this.indexEntries = new ArrayList<Ext4ExtentIdx>();
            } else {
                this.extentEntries = new ArrayList<Ext4Extent>();
            }
            int i = 0;
            while (i < numEntries) {
                if (isIdxEntries) {
                    this.indexEntries.add(new Ext4ExtentIdx(reader));
                } else {
                    this.extentEntries.add(new Ext4Extent(reader));
                }
                ++i;
                ++count;
            }
        }
        this.extra = (extraBytes = 60 - count * 12) > 0 ? reader.readNextByteArray(extraBytes) : new byte[0];
    }

    public Ext4ExtentHeader getHeader() {
        return this.header;
    }

    public List<Ext4ExtentIdx> getIndexEntries() {
        if (this.indexEntries == null) {
            return Collections.emptyList();
        }
        return this.indexEntries;
    }

    public List<Ext4Extent> getExtentEntries() {
        if (this.extentEntries == null) {
            return Collections.emptyList();
        }
        return this.extentEntries;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        int extra;
        StructureDataType structure;
        if (this.isExtentTree) {
            int i;
            structure = new StructureDataType("ext4_i_block_" + this.header.getEh_depth() + "_" + this.header.getEh_entries(), 0);
            structure.add(this.header.toDataType(), "header", null);
            if (this.extentEntries != null) {
                for (i = 0; i < this.extentEntries.size(); ++i) {
                    structure.add(this.extentEntries.get(i).toDataType(), "entry_" + i, null);
                }
            }
            if (this.indexEntries != null) {
                for (i = 0; i < this.indexEntries.size(); ++i) {
                    structure.add(this.indexEntries.get(i).toDataType(), "idx_" + i, null);
                }
            }
        } else {
            structure = new StructureDataType("ext4_i_block", 0);
        }
        int n = extra = structure.getLength() == 1 ? 60 : 60 - structure.getLength();
        if (extra > 0) {
            structure.add((DataType)new ArrayDataType(BYTE, extra, BYTE.getLength()), "extra", null);
        }
        return structure;
    }
}

