/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.file.formats.android.dex.format.EncodedTypeAddressPair;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EncodedCatchHandler
implements StructConverter {
    private int size;
    private int sizeLength;
    private List<EncodedTypeAddressPair> handlers = new ArrayList<EncodedTypeAddressPair>();
    private int catchAllAddress;
    private int catchAllAddressLength;

    public EncodedCatchHandler(BinaryReader reader) throws IOException {
        LEB128 leb128 = LEB128.readSignedValue((BinaryReader)reader);
        this.size = leb128.asInt32();
        this.sizeLength = leb128.getLength();
        for (int i = 0; i < Math.abs(this.size); ++i) {
            this.handlers.add(new EncodedTypeAddressPair(reader));
        }
        if (this.size <= 0) {
            leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
            this.catchAllAddress = leb128.asUInt32();
            this.catchAllAddressLength = leb128.getLength();
        }
    }

    public int getSize() {
        return this.size;
    }

    public List<EncodedTypeAddressPair> getPairs() {
        return this.handlers;
    }

    public int getCatchAllAddress() {
        return this.catchAllAddress;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("encoded_catch_handler_" + this.sizeLength + "_" + this.catchAllAddressLength + "_" + this.handlers.size());
        StructureDataType structure = new StructureDataType(builder.toString(), 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.sizeLength, BYTE.getLength()), "size", null);
        int index = 0;
        for (EncodedTypeAddressPair pair : this.handlers) {
            DataType dataType = pair.toDataType();
            structure.add(dataType, "handler_" + index, null);
            builder.append(pair.getDataTypeIdString());
        }
        if (this.size <= 0) {
            structure.add((DataType)new ArrayDataType(BYTE, this.catchAllAddressLength, BYTE.getLength()), "catch_all_addr", null);
        }
        structure.setCategoryPath(new CategoryPath("/dex/encoded_catch_handler"));
        try {
            structure.setName(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return structure;
    }
}

