/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.android.bootimg.VendorBootImageHeader;
import ghidra.file.formats.android.bootimg.VendorBootImageHeaderFactory;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@FileSystemInfo(type="androidvendorbootimg", description="Android Vendor Boot Images", factory=GFileSystemBaseFactory.class)
public class VendorBootImageFileSystem
extends GFileSystemBase {
    private VendorBootImageHeader header;
    private GFileImpl ramdiskFile;
    private GFileImpl dtbFile;
    private List<GFileImpl> fileList = new ArrayList<GFileImpl>();

    public VendorBootImageFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, 8L);
        return Arrays.equals(bytes, "VNDRBOOT".getBytes());
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        this.header = VendorBootImageHeaderFactory.getVendorBootImageHeader(this.provider, true);
        if (!this.header.getMagic().equals("VNDRBOOT")) {
            throw new IOException("Invalid Android boot image file!");
        }
        if (this.header.getVendorRamdiskSize() > 0) {
            this.ramdiskFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"ramdisk", (boolean)false, (long)this.header.getVendorRamdiskSize(), null);
            this.fileList.add(this.ramdiskFile);
        }
        if (this.header.getDtbSize() > 0) {
            this.dtbFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"dtb", (boolean)false, (long)this.header.getDtbSize(), null);
            this.fileList.add(this.dtbFile);
        }
    }

    public void close() throws IOException {
        this.ramdiskFile = null;
        this.dtbFile = null;
        this.header = null;
        super.close();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return directory == null || directory.equals(this.root) ? new ArrayList<GFileImpl>(this.fileList) : Collections.emptyList();
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        if (file == this.ramdiskFile) {
            return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.COMMENT_ATTR, (Object)"This is a ramdisk, it is a GZIP file containing a CPIO archive.")});
        }
        if (file == this.dtbFile) {
            return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.COMMENT_ATTR, (Object)"This is a DTB file. It appears unused at this time.")});
        }
        return null;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (file == this.ramdiskFile) {
            return new ByteProviderWrapper(this.provider, this.header.getVendorRamdiskOffset(), Integer.toUnsignedLong(this.header.getVendorRamdiskSize()), file.getFSRL());
        }
        if (file == this.dtbFile) {
            return new ByteProviderWrapper(this.provider, this.header.getDtbOffset(), Integer.toUnsignedLong(this.header.getDtbSize()), file.getFSRL());
        }
        return null;
    }
}

