/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class HexIntegerFormatModel
implements UniversalDataFormatModel {
    private int symbolSize = 8;

    @Override
    public String getName() {
        return "HexInteger";
    }

    @Override
    public int getUnitByteSize() {
        return 4;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        int o = position / 2;
        if (block.isBigEndian()) {
            return o;
        }
        return 3 - o;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        if (byteOffset > 3) {
            throw new IllegalArgumentException("invalid byteOffset: " + byteOffset);
        }
        if (block.isBigEndian()) {
            return byteOffset * 2;
        }
        return (3 - byteOffset) * 2;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        int i = block.getInt(index);
        String str = Integer.toHexString(i);
        return this.pad(str);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (charPosition < 0 || charPosition > this.symbolSize - 1) {
            return false;
        }
        char[] charArray = new char[]{c};
        String s = new String(charArray);
        try {
            Integer.parseInt(s, 16);
        }
        catch (Exception e) {
            return false;
        }
        byte cb = Byte.parseByte(new String(charArray), 16);
        int byteOffset = this.getByteOffset(block, charPosition);
        BigInteger saveIndex = index;
        index = index.add(BigInteger.valueOf(byteOffset));
        byte b = block.getByte(index);
        b = this.adjustByte(b, cb, charPosition);
        int intValue = this.getInt(block, saveIndex, b, byteOffset);
        block.setInt(saveIndex, intValue);
        return true;
    }

    @Override
    public int getGroupSize() {
        return 1;
    }

    @Override
    public void setGroupSize(int groupSize) {
        throw new UnsupportedOperationException("groups are not supported");
    }

    @Override
    public int getUnitDelimiterSize() {
        return 1;
    }

    @Override
    public boolean validateBytesPerLine(int bytesPerLine) {
        return bytesPerLine % 4 == 0;
    }

    private String pad(String value) {
        StringBuffer sb = new StringBuffer();
        int len = this.symbolSize - value.length();
        for (int i = 0; i < len; ++i) {
            sb.append("0");
        }
        sb.append(value);
        return sb.toString();
    }

    private byte adjustByte(byte b, byte newb, int charPosition) {
        if (charPosition % 2 == 0) {
            b = (byte)(b & 0xF);
            newb = (byte)(newb << 4);
        } else {
            b = (byte)(b & 0xF0);
        }
        b = (byte)(b + newb);
        return b;
    }

    private int getInt(ByteBlock block, BigInteger offset, byte newb, int byteOffset) {
        byte[] b = new byte[4];
        try {
            for (int i = 0; i < b.length; ++i) {
                b[i] = block.getByte(offset.add(BigInteger.valueOf(i)));
            }
            b[byteOffset] = newb;
            if (block.isBigEndian()) {
                return b[0] << 24 | b[1] << 16 & 0xFF0000 | b[2] << 8 & 0xFF00 | b[3] & 0xFF;
            }
            return b[3] << 24 | b[2] << 16 & 0xFF0000 | b[1] << 8 & 0xFF00 | b[0] & 0xFF;
        }
        catch (ByteBlockAccessException byteBlockAccessException) {
            return 0;
        }
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "HexInteger");
    }

    @Override
    public void dispose() {
    }
}

