/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.MapIteratorSTL;
import generic.stl.Pair;
import generic.stl.RedBlackNode;
import generic.stl.RedBlackTree;

public class ReverseMapIteratorSTL<K, V>
extends MapIteratorSTL<K, V> {
    ReverseMapIteratorSTL(RedBlackTree<K, V> tree, RedBlackNode<K, V> node) {
        super(tree, node);
    }

    @Override
    public IteratorSTL<Pair<K, V>> increment() {
        if (this.node == null) {
            throw new IndexOutOfBoundsException();
        }
        this.node = this.node.getPredecessor();
        return this;
    }

    @Override
    public IteratorSTL<Pair<K, V>> decrement() {
        if (this.node == null && this.tree.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        this.node = this.node == null ? this.tree.getFirst() : this.node.getSuccessor();
        return this;
    }

    public void delete() {
        if (this.node == null) {
            throw new IndexOutOfBoundsException();
        }
        RedBlackNode nextNode = this.node.getPredecessor();
        this.tree.deleteEntry(this.node);
        this.node = nextNode;
    }

    public void delete(int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(Pair<K, V> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBegin() {
        return this.node == this.tree.getLast();
    }

    @Override
    public IteratorSTL<Pair<K, V>> copy() {
        return new ReverseMapIteratorSTL<K, V>(this.tree, this.node);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReverseMapIteratorSTL other = (ReverseMapIteratorSTL)obj;
        return this.tree == other.tree && this.node == other.node;
    }
}

